/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;

public interface Tuple3DReadOnly {
    public double getX();

    public double getY();

    public double getZ();

    default public float getX32() {
        return (float)this.getX();
    }

    default public float getY32() {
        return (float)this.getY();
    }

    default public float getZ32() {
        return (float)this.getZ();
    }

    default public boolean containsNaN() {
        return EuclidCoreTools.containsNaN(this.getX(), this.getY(), this.getZ());
    }

    default public double getElement(Axis3D axis) {
        return axis.extract(this);
    }

    default public double getElement(int index) {
        switch (index) {
            case 0: {
                return this.getX();
            }
            case 1: {
                return this.getY();
            }
            case 2: {
                return this.getZ();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    default public float getElement32(int index) {
        switch (index) {
            case 0: {
                return this.getX32();
            }
            case 1: {
                return this.getY32();
            }
            case 2: {
                return this.getZ32();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    default public void get(double[] tupleArrayToPack) {
        this.get(0, tupleArrayToPack);
    }

    default public void get(int startIndex, double[] tupleArrayToPack) {
        tupleArrayToPack[startIndex++] = this.getX();
        tupleArrayToPack[startIndex++] = this.getY();
        tupleArrayToPack[startIndex] = this.getZ();
    }

    default public void get(float[] tupleArrayToPack) {
        this.get(0, tupleArrayToPack);
    }

    default public void get(int startIndex, float[] tupleArrayToPack) {
        tupleArrayToPack[startIndex++] = this.getX32();
        tupleArrayToPack[startIndex++] = this.getY32();
        tupleArrayToPack[startIndex] = this.getZ32();
    }

    default public void get(DMatrix tupleMatrixToPack) {
        this.get(0, 0, tupleMatrixToPack);
    }

    default public void get(int startRow, DMatrix tupleMatrixToPack) {
        this.get(startRow, 0, tupleMatrixToPack);
    }

    default public void get(int startRow, int column, DMatrix tupleMatrixToPack) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 3, column + 1, (Matrix)tupleMatrixToPack);
        tupleMatrixToPack.unsafe_set(startRow++, column, this.getX());
        tupleMatrixToPack.unsafe_set(startRow++, column, this.getY());
        tupleMatrixToPack.unsafe_set(startRow, column, this.getZ());
    }

    default public boolean epsilonEquals(Tuple3DReadOnly other, double epsilon) {
        return TupleTools.epsilonEquals(this, other, epsilon);
    }

    default public boolean equals(Tuple3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ();
    }
}

