/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public class Vector3D
implements Vector3DBasics,
GeometryObject<Vector3D> {
    private double x;
    private double y;
    private double z;

    public Vector3D() {
        this.setToZero();
    }

    public Vector3D(double x, double y, double z) {
        this.set(x, y, z);
    }

    public Vector3D(double[] vectorArray) {
        this.set(vectorArray);
    }

    public Vector3D(Tuple2DReadOnly tuple2DReadOnly) {
        this.set(tuple2DReadOnly);
    }

    public Vector3D(Tuple3DReadOnly other) {
        this.set(other);
    }

    @Override
    public void set(Vector3D other) {
        Vector3DBasics.super.set(other);
    }

    @Override
    public void setX(double x) {
        this.x = x;
    }

    @Override
    public void setY(double y) {
        this.y = y;
    }

    @Override
    public void setZ(double z) {
        this.z = z;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    public boolean equals(Object object) {
        if (object instanceof Tuple3DReadOnly) {
            return this.equals((Tuple3DReadOnly)object);
        }
        return false;
    }

    @Override
    public boolean epsilonEquals(Vector3D other, double epsilon) {
        return Vector3DBasics.super.epsilonEquals(other, epsilon);
    }

    @Override
    public boolean geometricallyEquals(Vector3D other, double epsilon) {
        return Vector3DBasics.super.geometricallyEquals(other, epsilon);
    }

    public String toString() {
        return EuclidCoreIOTools.getTuple3DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode(this.x, this.y, this.z);
    }
}

