/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.LinearTransform3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.transform.interfaces.AffineTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public interface AffineTransformReadOnly
extends Transform {
    public LinearTransform3DReadOnly getLinearTransform();

    public Vector3DReadOnly getTranslation();

    default public boolean hasLinearTransform() {
        return !this.getLinearTransform().isIdentity();
    }

    default public boolean hasTranslation() {
        return !TupleTools.isTupleZero(this.getTranslation(), 1.0E-10);
    }

    @Override
    default public void transform(Point3DReadOnly pointOriginal, Point3DBasics pointTransformed) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().transform(pointOriginal, pointTransformed);
        } else {
            pointTransformed.set(pointOriginal);
        }
        if (this.hasTranslation()) {
            pointTransformed.add(this.getTranslation());
        }
    }

    @Override
    default public void transform(Vector3DReadOnly vectorOriginal, Vector3DBasics vectorTransformed) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().transform(vectorOriginal, vectorTransformed);
        } else {
            vectorTransformed.set(vectorOriginal);
        }
    }

    @Override
    default public void transform(Orientation3DReadOnly orientationOriginal, Orientation3DBasics orientationTransformed) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().transform(orientationOriginal, orientationTransformed);
        } else {
            orientationTransformed.set(orientationOriginal);
        }
    }

    @Override
    default public void transform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().transform(vectorOriginal, vectorTransformed);
        } else {
            vectorTransformed.set(vectorOriginal);
        }
        if (this.hasTranslation()) {
            vectorTransformed.addX(vectorTransformed.getS() * this.getTranslation().getX());
            vectorTransformed.addY(vectorTransformed.getS() * this.getTranslation().getY());
            vectorTransformed.addZ(vectorTransformed.getS() * this.getTranslation().getZ());
        }
    }

    @Override
    default public void transform(Point2DReadOnly point2DOriginal, Point2DBasics point2DTransformed, boolean checkIfTransformInXYPlane) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().transform(point2DOriginal, point2DTransformed, checkIfTransformInXYPlane);
        } else {
            point2DTransformed.set(point2DOriginal);
        }
        if (this.hasTranslation()) {
            point2DTransformed.add(this.getTranslation().getX(), this.getTranslation().getY());
        }
    }

    @Override
    default public void transform(Vector2DReadOnly vector2DOriginal, Vector2DBasics vector2DTransformed, boolean checkIfTransformInXYPlane) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().transform(vector2DOriginal, vector2DTransformed, checkIfTransformInXYPlane);
        } else {
            vector2DTransformed.set(vector2DOriginal);
        }
    }

    @Override
    default public void transform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().transform(matrixOriginal, matrixTransformed);
        } else {
            matrixTransformed.set(matrixOriginal);
        }
    }

    @Override
    default public void transform(RigidBodyTransformReadOnly original, RigidBodyTransformBasics transformed) {
        transformed.set(original);
        transformed.preMultiply(this);
    }

    @Override
    default public void transform(AffineTransformReadOnly original, AffineTransformBasics transformed) {
        transformed.set(original);
        transformed.preMultiply(this);
    }

    @Override
    default public void inverseTransform(Point3DReadOnly pointOriginal, Point3DBasics pointTransformed) {
        pointTransformed.set(pointOriginal);
        if (this.hasTranslation()) {
            pointTransformed.sub(this.getTranslation());
        }
        if (this.hasLinearTransform()) {
            this.getLinearTransform().inverseTransform(pointTransformed);
        }
    }

    @Override
    default public void inverseTransform(Vector3DReadOnly vectorOriginal, Vector3DBasics vectorTransformed) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().inverseTransform(vectorOriginal, vectorTransformed);
        } else {
            vectorTransformed.set(vectorOriginal);
        }
    }

    @Override
    default public void inverseTransform(Orientation3DReadOnly orientationOriginal, Orientation3DBasics orientationTransformed) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().inverseTransform(orientationOriginal, orientationTransformed);
        } else {
            orientationTransformed.set(orientationOriginal);
        }
    }

    @Override
    default public void inverseTransform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        vectorTransformed.set(vectorOriginal);
        if (this.hasTranslation()) {
            vectorTransformed.subX(vectorTransformed.getS() * this.getTranslation().getX());
            vectorTransformed.subY(vectorTransformed.getS() * this.getTranslation().getY());
            vectorTransformed.subZ(vectorTransformed.getS() * this.getTranslation().getZ());
        }
        if (this.hasLinearTransform()) {
            this.getLinearTransform().inverseTransform(vectorTransformed, vectorTransformed);
        }
    }

    @Override
    default public void inverseTransform(Point2DReadOnly point2DOriginal, Point2DBasics point2DTransformed, boolean checkIfTransformInXYPlane) {
        point2DTransformed.set(point2DOriginal);
        if (this.hasTranslation()) {
            point2DTransformed.sub(this.getTranslation().getX(), this.getTranslation().getY());
        }
        if (this.hasLinearTransform()) {
            this.getLinearTransform().inverseTransform(point2DTransformed, checkIfTransformInXYPlane);
        }
    }

    @Override
    default public void inverseTransform(Vector2DReadOnly vector2DOriginal, Vector2DBasics vector2DTransformed, boolean checkIfTransformInXYPlane) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().inverseTransform(vector2DOriginal, vector2DTransformed, checkIfTransformInXYPlane);
        } else {
            vector2DTransformed.set(vector2DOriginal);
        }
    }

    @Override
    default public void inverseTransform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        if (this.hasLinearTransform()) {
            this.getLinearTransform().inverseTransform(matrixOriginal, matrixTransformed);
        } else {
            matrixTransformed.set(matrixOriginal);
        }
    }

    @Override
    default public void inverseTransform(RigidBodyTransformReadOnly original, RigidBodyTransformBasics transformed) {
        transformed.set(original);
        transformed.preMultiplyInvertOther(this);
    }

    @Override
    default public void inverseTransform(AffineTransformReadOnly original, AffineTransformBasics transformed) {
        transformed.set(original);
        transformed.preMultiplyInvertOther(this);
    }

    default public void get(DMatrix matrixToPack) {
        EuclidCoreTools.checkMatrixMinimumSize(4, 4, (Matrix)matrixToPack);
        this.getLinearTransform().get(matrixToPack);
        this.getTranslation().get(0, 3, matrixToPack);
        matrixToPack.unsafe_set(3, 0, 0.0);
        matrixToPack.unsafe_set(3, 1, 0.0);
        matrixToPack.unsafe_set(3, 2, 0.0);
        matrixToPack.unsafe_set(3, 3, 1.0);
    }

    default public void get(int startRow, int startColumn, DMatrix matrixToPack) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 4, startColumn + 4, (Matrix)matrixToPack);
        this.getLinearTransform().get(startRow, startColumn, matrixToPack);
        this.getTranslation().get(startRow, startColumn + 3, matrixToPack);
        matrixToPack.unsafe_set(startRow += 3, startColumn++, 0.0);
        matrixToPack.unsafe_set(startRow, startColumn++, 0.0);
        matrixToPack.unsafe_set(startRow, startColumn++, 0.0);
        matrixToPack.unsafe_set(startRow, startColumn, 1.0);
    }

    default public void get(double[] transformArrayToPack) {
        transformArrayToPack[0] = this.getLinearTransform().getM00();
        transformArrayToPack[1] = this.getLinearTransform().getM01();
        transformArrayToPack[2] = this.getLinearTransform().getM02();
        transformArrayToPack[3] = this.getTranslation().getX();
        transformArrayToPack[4] = this.getLinearTransform().getM10();
        transformArrayToPack[5] = this.getLinearTransform().getM11();
        transformArrayToPack[6] = this.getLinearTransform().getM12();
        transformArrayToPack[7] = this.getTranslation().getY();
        transformArrayToPack[8] = this.getLinearTransform().getM20();
        transformArrayToPack[9] = this.getLinearTransform().getM21();
        transformArrayToPack[10] = this.getLinearTransform().getM22();
        transformArrayToPack[11] = this.getTranslation().getZ();
        transformArrayToPack[12] = 0.0;
        transformArrayToPack[13] = 0.0;
        transformArrayToPack[14] = 0.0;
        transformArrayToPack[15] = 1.0;
    }

    default public void get(CommonMatrix3DBasics rotationScaleMarixToPack, Tuple3DBasics translationToPack) {
        rotationScaleMarixToPack.set(this.getLinearTransform());
        translationToPack.set(this.getTranslation());
    }

    default public boolean geometricallyEquals(AffineTransformReadOnly other, double epsilon) {
        return other.getLinearTransform().epsilonEquals(this.getLinearTransform(), epsilon) && other.getTranslation().geometricallyEquals(this.getTranslation(), epsilon);
    }

    default public boolean epsilonEquals(AffineTransformReadOnly other, double epsilon) {
        return this.getLinearTransform().epsilonEquals(other.getLinearTransform(), epsilon) && this.getTranslation().epsilonEquals(other.getTranslation(), epsilon);
    }

    default public boolean equals(AffineTransformReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getLinearTransform().equals(other.getLinearTransform()) && this.getTranslation().equals(other.getTranslation());
    }
}

