/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.docker;

import java.io.File;
import java.util.Objects;

public final class VolumeDef {
    private final String mountPoint;
    private final File location;
    private final boolean createDirectoryIfMissing;

    public VolumeDef(String mountPoint, File location) {
        this(mountPoint, location, false);
    }

    public VolumeDef(String mountPoint, File location, boolean createDirectoryIfMissing) {
        if (mountPoint == null || mountPoint.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.mountPoint = mountPoint;
        this.location = location;
        this.createDirectoryIfMissing = createDirectoryIfMissing;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public File getLocation() {
        return this.location;
    }

    public boolean isCreateDirectoryIfMissing() {
        return this.createDirectoryIfMissing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeDef volumeDef = (VolumeDef)o;
        return this.createDirectoryIfMissing == volumeDef.createDirectoryIfMissing && Objects.equals(this.mountPoint, volumeDef.mountPoint) && Objects.equals(this.location, volumeDef.location);
    }

    public int hashCode() {
        return Objects.hash(this.mountPoint, this.location, this.createDirectoryIfMissing);
    }
}

