/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.docker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import me.bazhenov.docker.ContainerNamespace;
import me.bazhenov.docker.PortRef;

final class NotificationMethod {
    private ContainerNamespace namespace;
    private final Method method;
    private List<PortRef> arguments;

    NotificationMethod(ContainerNamespace namespace, Method method, List<PortRef> arguments) {
        this.namespace = Objects.requireNonNull(namespace);
        this.method = Objects.requireNonNull(method);
        this.arguments = Objects.requireNonNull(arguments);
    }

    void call(Object test) {
        Object[] args = new Integer[this.arguments.size()];
        for (int i = 0; i < args.length; ++i) {
            PortRef port = this.arguments.get(i);
            args[i] = this.namespace.lookupHostPort(port.getContainerDefinition(), port.getContainerPort());
        }
        try {
            this.method.invoke(test, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    Method getMethod() {
        return this.method;
    }

    List<PortRef> getArguments() {
        return this.arguments;
    }
}

