/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.docker;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.bazhenov.docker.ContainerDefinition;

final class ContainerNamespace {
    private final Map<String, ContainerDefinition> defs;
    private final List<ContainerNamespace> importNamespaces;
    private final Map<ContainerDefinition, Map<Integer, Integer>> tcpPorts = new ConcurrentHashMap<ContainerDefinition, Map<Integer, Integer>>();

    ContainerNamespace(Map<String, ContainerDefinition> defs, List<ContainerNamespace> importNamespaces) {
        ContainerNamespace.ensureUniqueNames(defs, importNamespaces);
        this.defs = Collections.unmodifiableMap(Objects.requireNonNull(defs));
        this.importNamespaces = Collections.unmodifiableList(Objects.requireNonNull(importNamespaces));
    }

    private static void ensureUniqueNames(Map<String, ContainerDefinition> defs, List<ContainerNamespace> namespaces) {
        HashSet<String> visitedNamed = new HashSet<String>(defs.keySet());
        for (ContainerNamespace namespace : namespaces) {
            for (String name : namespace.getDefinedNames()) {
                if (visitedNamed.add(name)) continue;
                throw new IllegalArgumentException("Namespace has duplicated container with name: " + name);
            }
        }
    }

    int size() {
        return this.defs.size() + this.importNamespaces.stream().mapToInt(ContainerNamespace::size).sum();
    }

    ContainerDefinition getDefinition(String name) {
        ContainerDefinition definition = this.defs.get(name);
        if (definition != null) {
            return definition;
        }
        for (ContainerNamespace namespace : this.importNamespaces) {
            definition = namespace.getDefinition(name);
            if (definition == null) continue;
            return definition;
        }
        return null;
    }

    Collection<ContainerDefinition> getAllDefinitions() {
        return this.defs.values();
    }

    private Set<String> getDefinedNames() {
        return this.defs.keySet();
    }

    void registerPublishedTcpPorts(ContainerDefinition definition, Map<Integer, Integer> publishedTcpPorts) {
        if (!this.defs.containsValue(definition)) {
            throw new IllegalArgumentException("No definition for container found in namespace: " + definition.getImage());
        }
        this.tcpPorts.put(definition, publishedTcpPorts);
    }

    int lookupHostPort(ContainerDefinition definition, int containerPort) {
        Integer port = this.doLookupHostPort(definition, containerPort);
        if (port == null) {
            throw new IllegalArgumentException("Missing container in namespace: " + definition.getImage());
        }
        return port;
    }

    private Integer doLookupHostPort(ContainerDefinition definition, int containerPort) {
        Map<Integer, Integer> ports = this.tcpPorts.get(definition);
        if (ports != null) {
            Integer hostPort = ports.get(containerPort);
            if (hostPort == null) {
                throw new IllegalArgumentException("Port " + containerPort + " not registered in the container");
            }
            return hostPort;
        }
        for (ContainerNamespace namespace : this.importNamespaces) {
            Integer port = namespace.doLookupHostPort(definition, containerPort);
            if (port == null) continue;
            return port;
        }
        return null;
    }
}

