/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.schreibtrainer;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.data.TimedList;
import de.kosmos_lab.platform.exceptions.DeviceAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.SchemaNotFoundException;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.platform.web.servlets.schreibtrainer.SchreibtrainerConstants;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.parameters.RequestBody;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.json.JSONObject;

@ApiEndpoint(path="/schreibtrainer/clear", userLevel=1)
public class SchreibtrainerClearServlet
extends KosmoSAuthedServlet {
    public SchreibtrainerClearServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"schreibtrainer"}, summary="clear", description="clear words from pen", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="uuid", schema=@Schema(description="The UUID of the pen to clear", type=SchemaType.STRING, required=true))})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="The pen was cleared successfully"), @ApiResponse(responseCode=@ResponseCode(statusCode=422), description="The device has not the correct schema to be a pen")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws ParameterNotFoundException {
        String uuid = request.getString("uuid");
        try {
            Device device = SchreibtrainerConstants.getDevice(this.controller, this.server, uuid);
            if (device.getSchema().getId().equalsIgnoreCase("https://kosmos-lab.de/schema/StabiloPen2.json")) {
                TimedList wl = SchreibtrainerConstants.getWordList(this.controller, this.server, device);
                wl.clear();
                device.updateFromJSON(this.server, new JSONObject().put("text", (Object)"").put("wordList", (Object)wl.toJSONArray()), this.controller.getSource("stabilo"));
                SchreibtrainerClearServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)new JSONObject());
                return;
            }
            response.setStatus(422);
            SchreibtrainerClearServlet.sendText((BaseServletRequest)request, (HttpServletResponse)response, (String)("Device " + uuid + " does not have schema: https://kosmos-lab.de/schema/StabiloPen2.json"));
            return;
        }
        catch (SchemaNotFoundException e) {
            e.printStackTrace();
        }
        catch (DeviceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(500);
            return;
        }
        response.setStatus(500);
    }
}

