/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.schreibtrainer;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.platform.web.servlets.schreibtrainer.SchreibtrainerConstants;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.parameters.RequestBody;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.annotations.tags.Tag;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import jakarta.servlet.http.HttpServletResponse;
import org.json.JSONObject;

@Tag(name="schreibtrainer", description="Schreibtrainer")
@ApiEndpoint(path="/schreibtrainer/add", userLevel=1)
public class SchreibtrainerAddServlet
extends KosmoSAuthedServlet {
    public SchreibtrainerAddServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"schreibtrainer"}, summary="add", description="Add a new pen to the system", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="uuid", schema=@Schema(description="The UUID of the pen to add", type=SchemaType.STRING, required=true))})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="The pen was added successfully")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws ParameterNotFoundException {
        JSONObject o = request.getBodyAsJSONObject();
        try {
            if (o.has("uuid")) {
                SchreibtrainerConstants.getDevice(this.controller, this.server, o.getString("uuid"));
                response.setStatus(204);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        response.setStatus(500);
    }
}

