/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.schema;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.DataSchema;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.ArraySchema;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.ObjectSchema;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

@ApiEndpoint(path="/schema/list", userLevel=1)
@ObjectSchema(componentName="schema", properties={@SchemaProperty(name="$id", schema=@Schema(description="The unique id of the schema", type=SchemaType.STRING, required=true)), @SchemaProperty(name="title", schema=@Schema(description="The title of the schema", type=SchemaType.STRING)), @SchemaProperty(name="type", schema=@Schema(description="The type of the schema", type=SchemaType.STRING, required=true)), @SchemaProperty(name="$schema", schema=@Schema(description="The schema definition, defines what is needed and so on", type=SchemaType.STRING, defaultValue="http://json-schema.org/draft-07/schema#")), @SchemaProperty(name="examples", array=@ArraySchema(schema=@Schema(type=SchemaType.OBJECT, description="List of examples for this schema"))), @SchemaProperty(name="failures", array=@ArraySchema(schema=@Schema(type=SchemaType.OBJECT, description="List of bad examples for this schema, all examples in here should fail"))), @SchemaProperty(name="required", array=@ArraySchema(schema=@Schema(type=SchemaType.STRING, description="List of required properties"))), @SchemaProperty(name="additionalProperties", schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="true", description="Are additional properties allowed?")), @SchemaProperty(name="properties", schema=@Schema(type=SchemaType.OBJECT, defaultValue="{}", description="The definition of the actual properties"))})
public class SchemaListServlet
extends KosmoSAuthedServlet {
    public SchemaListServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"schema"}, summary="list", description="Lists all known schemas", responses={@ApiResponse(description="List of devices", responseCode=@ResponseCode(statusCode=200), content={@Content(mediaType="application/json", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(ref="#/components/schemas/schema")), examples={@ExampleObject(name="example", value="[{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"additionalProperties\":false,\"title\":\"All\",\"type\":\"object\",\"properties\":{\"rockerSwitch2Status\":{\"description\":\"Status of rocker switch 2\",\"readOnly\":true,\"title\":\"rockerSwitch2Status\",\"type\":\"string\",\"enum\":[\"up\",\"released\",\"down\"]},\"hob3HeatLevelSetting\":{\"multipleOf\":10,\"unit\":\"%\",\"maximum\":100,\"description\":\"Heat level setting of hob 3.\",\"readOnly\":false,\"title\":\"hob3HeatLevelSetting\",\"type\":\"integer\",\"minimum\":0},\"homeButtonGreenLED\":{\"description\":\"Green LED of the home button.\",\"readOnly\":false,\"title\":\"homeButtonGreenLED\",\"type\":\"boolean\"},\"roadCondition\":{\"readOnly\":true,\"title\":\"roadCondition\",\"type\":\"string\",\"enum\":[\"Dry\",\"Damp\",\"Wet\",\"IceCovered\"]},\"averageTruckSpeed\":{\"unit\":\"km/h\",\"maximum\":300,\"description\":\"Average Speed of traffic on a lane.\",\"readOnly\":true,\"title\":\"averageTruckSpeed\",\"type\":\"number\",\"minimum\":0},\"icePercentage\":{\"unit\":\"%\",\"maximum\":100,\"readOnly\":true,\"title\":\"icePercentage\",\"type\":\"number\",\"minimum\":0},\"activePowerTotal\":{\"unit\":\"kW\",\"description\":\"Total active power.\",\"readOnly\":true,\"title\":\"activePowerTotal\",\"type\":\"number\"},\"dishwasherLoadType\":{\"description\":\"Load type of the dishwasher\",\"readOnly\":false,\"title\":\"dishwasherLoadType\",\"type\":\"boolean\"},\"mechanicalHandlePosition\":{\"description\":\"Position of the mechanical handle, e.g. of a\",\"readOnly\":true,\"title\":\"mechanicalHandlePosition\",\"type\":\"string\",\"enum\":[\"Up\",\"Down\",\"Horizontal\"]},\"hydrogenSulfidePPM\":{\"unit\":\"ppm\",\"maximum\":1000000,\"description\":\"Hydrogen sulfide level in ppm\",\"readOnly\":true,\"title\":\"hydrogenSulfidePPM\",\"type\":\"number\",\"minimum\":0},\"waterDetected\":{\"description\":\"Defines whether water has been detected or\",\"readOnly\":true,\"title\":\"waterDetected\",\"type\":\"boolean\"},\"particlePM10\":{\"unit\":\"g/m\ufffd\",\"maximum\":10000,\"description\":\"Particulate matter PM10\",\"readOnly\":true,\"title\":\"particlePM10\",\"type\":\"number\",\"minimum\":0},\"activeOxygen\":{\"unit\":\"g/m\ufffd\",\"maximum\":1000000,\"description\":\"Active oxygen level\",\"readOnly\":true,\"title\":\"activeOxygen\",\"type\":\"number\",\"minimum\":0},\"repeaterRssi\":{\"unit\":\"dBm\",\"maximum\":0,\"description\":\"Received Signal Strength Indication of\",\"readOnly\":true,\"title\":\"repeaterRssi\",\"type\":\"number\",\"minimum\":-150},\"powerUsage\":{\"unit\":\"W\",\"maximum\":3680,\"description\":\"The current electric power load of a home\",\"readOnly\":true,\"title\":\"powerUsage\",\"type\":\"number\",\"minimum\":0},\"cumulativePowerUsage\":{\"unit\":\"Wh\",\"description\":\"Cumulative power usage\",\"readOnly\":true,\"title\":\"cumulativePowerUsage\",\"type\":\"integer\",\"minimum\":0},\"BloodPressureDiastolic\":{\"unit\":\"mmHg\",\"maximum\":300,\"description\":\"Diastolic blood pressure.\",\"readOnly\":true,\"title\":\"BloodPressureDiastolic\",\"type\":\"number\",\"minimum\":0},\"windAzimuth\":{\"unit\":\"\ufffd\",\"maximum\":360,\"description\":\"Wind azimuth angle, where 0\ufffd is north.\",\"readOnly\":true,\"title\":\"windAzimuth\",\"type\":\"number\",\"minimum\":0},\"currentPlaylist\":{\"description\":\"Current playlist set in the media player.\",\"readOnly\":false,\"title\":\"currentPlaylist\",\"type\":\"string\"},\"powerDensity\":{\"unit\":\"W/m\ufffd\",\"maximum\":1000000,\"description\":\"Power density of a surface\",\"readOnly\":true,\"title\":\"powerDensity\",\"type\":\"number\",\"minimum\":0},\"hourlyPrecipitation\":{\"unit\":\"mm/m\ufffd/h\",\"maximum\":400,\"description\":\"Hourly rainfall amount.\",\"readOnly\":true,\"title\":\"hourlyPrecipitation\",\"type\":\"number\",\"minimum\":0},\"printJobCommand\":{\"description\":\"Print command sent to the printer, allowing\",\"readOnly\":false,\"title\":\"printJobCommand\",\"type\":\"string\",\"enum\":[\"Pause\",\"Stop\",\"Print\"]},\"extruder1Temperature\":{\"unit\":\"\ufffdC\",\"maximum\":500,\"description\":\"Current extruder 1 temperature\",\"readOnly\":true,\"title\":\"extruder1Temperature\",\"type\":\"number\",\"minimum\":0},\"extruder2Temperature\":{\"unit\":\"\ufffdC\",\"maximum\":500,\"description\":\"Current extruder 2 temperature\",\"readOnly\":true,\"title\":\"extruder2Temperature\",\"type\":\"number\",\"minimum\":0},\"gatewayIdentifier\":{\"description\":\"Identifier of the gateway of this device\",\"readOnly\":true,\"title\":\"gatewayIdentifier\",\"type\":\"string\"},\"outsideEnvironmentTemperature\":{\"unit\":\"\ufffdC\",\"maximum\":60,\"description\":\"Current temperature outside of the home\",\"readOnly\":true,\"title\":\"outsideEnvironmentTemperature\",\"type\":\"number\",\"minimum\":-60},\"nitrogenDioxide\":{\"unit\":\"g/m\ufffd\",\"maximum\":1000000,\"description\":\"Carbon dioxide level in ppm\",\"readOnly\":true,\"title\":\"nitrogenDioxide\",\"type\":\"number\",\"minimum\":0},\"configuredLocationName\":{\"description\":\"Location configured in the device\",\"readOnly\":true,\"title\":\"configuredLocationName\",\"type\":\"string\"},\"timeOfDay\":{\"description\":\"Time of day\",\"readOnly\":true,\"title\":\"timeOfDay\",\"type\":\"string\",\"enum\":[\"Day\",\"Night\",\"Sunrise\",\"Sunset\"]},\"pushButtonState\":{\"description\":\"Describes the state of a push button, which\",\"readOnly\":true,\"title\":\"pushButtonState\",\"type\":\"boolean\"},\"moistureDetected\":{\"description\":\"Defines whether moisture has been detected\",\"readOnly\":true,\"title\":\"moistureDetected\",\"type\":\"boolean\"},\"currentProgramNumber\":{\"maximum\":999,\"description\":\"Stores the current program of the TV with a\",\"readOnly\":false,\"title\":\"currentProgramNumber\",\"type\":\"integer\",\"minimum\":0},\"ringing\":{\"description\":\"Indicates whether a device is ringing, e.g. a\",\"readOnly\":false,\"title\":\"ringing\",\"type\":\"boolean\"},\"snowIntensity\":{\"description\":\"Current snow fall intensity.\",\"readOnly\":true,\"title\":\"snowIntensity\",\"type\":\"string\",\"enum\":[\"No Snow\",\"Light Snow\",\"Snow\",\"Heavy Snow\"]},\"standby\":{\"description\":\"Standby mode status.\",\"readOnly\":false,\"title\":\"standby\",\"type\":\"boolean\"},\"latitude\":{\"unit\":\"\ufffd\",\"maximum\":90,\"description\":\"Latitude\",\"readOnly\":false,\"title\":\"latitude\",\"type\":\"number\",\"minimum\":-90},\"pedestrianSpeakerState\":{\"description\":\"Speaker, signaling visually handicapped\",\"readOnly\":true,\"title\":\"pedestrianSpeakerState\",\"type\":\"boolean\"},\"rainfallDetected\":{\"description\":\"Defines whether rainfall has been detected\",\"readOnly\":true,\"title\":\"rainfallDetected\",\"type\":\"boolean\"},\"current\":{\"unit\":\"A\",\"description\":\"Electric current\",\"readOnly\":true,\"title\":\"current\",\"type\":\"number\"},\"trafficLightState\":{\"description\":\"State a traffic light may have.\",\"readOnly\":true,\"title\":\"trafficLightState\",\"type\":\"string\",\"enum\":[\"Green\",\"Yellow\",\"YellowRed\",\"Red\"]},\"vehicleDriveRange\":{\"unit\":\"km\",\"description\":\"Remaining drive range of a vehicle.\",\"readOnly\":true,\"title\":\"vehicleDriveRange\",\"type\":\"number\",\"minimum\":0},\"currentIlluminanceWest\":{\"unit\":\"lx\",\"maximum\":100000,\"description\":\"Current illuminance from west\",\"readOnly\":true,\"title\":\"currentIlluminanceWest\",\"type\":\"number\",\"minimum\":0},\"homeButtonRedLED\":{\"description\":\"Red LED of the home button.\",\"readOnly\":false,\"title\":\"homeButtonRedLED\",\"type\":\"boolean\"},\"diffuseHorizontalIrradiance\":{\"unit\":\"W/m\ufffd\",\"description\":\"Diffuse Horizontal Irradiance (DHI).\",\"readOnly\":true,\"title\":\"diffuseHorizontalIrradiance\",\"type\":\"number\",\"minimum\":0},\"waterFilmHeight\":{\"unit\":\"m\",\"maximum\":6000,\"readOnly\":true,\"title\":\"waterFilmHeight\",\"type\":\"number\",\"minimum\":0},\"vibrationDetected\":{\"description\":\"Informs whether vibration has been detected\",\"readOnly\":true,\"title\":\"vibrationDetected\",\"type\":\"boolean\"},\"printBedTemperature\":{\"unit\":\"\ufffdC\",\"maximum\":500,\"description\":\"Current print bed temperature\",\"readOnly\":true,\"title\":\"printBedTemperature\",\"type\":\"number\",\"minimum\":0},\"rssi\":{\"unit\":\"dBm\",\"maximum\":0,\"description\":\"Received Signal Strength Indication\",\"readOnly\":true,\"title\":\"rssi\",\"type\":\"number\",\"minimum\":-150},\"reactivePower\":{\"unit\":\"W\",\"description\":\"Reactive power\",\"readOnly\":true,\"title\":\"reactivePower\",\"type\":\"number\"},\"rockerSwitch1Status\":{\"description\":\"Status of rocker switch 1\",\"readOnly\":true,\"title\":\"rockerSwitch1Status\",\"type\":\"string\",\"enum\":[\"up\",\"released\",\"down\"]},\"particlePM1\":{\"unit\":\"g/m\ufffd\",\"maximum\":10000,\"description\":\"Particulate matter PM1\",\"readOnly\":true,\"title\":\"particlePM1\",\"type\":\"number\",\"minimum\":0},\"bakingTemperatureSetting\":{\"multipleOf\":1,\"unit\":\"\ufffdC\",\"maximum\":300,\"description\":\"Baking temperature requested by the user.\",\"readOnly\":false,\"title\":\"bakingTemperatureSetting\",\"type\":\"number\",\"minimum\":40},\"printTimeRemaining\":{\"unit\":\"s\",\"description\":\"Remaining print time estimate\",\"readOnly\":true,\"title\":\"printTimeRemaining\",\"type\":\"integer\",\"minimum\":0},\"reactiveEnergyNegative\":{\"unit\":\"kvarh\",\"description\":\"Negative reactive energy (R-).\",\"readOnly\":true,\"title\":\"reactiveEnergyNegative\",\"type\":\"number\",\"minimum\":0},\"thermalPower\":{\"unit\":\"W\",\"description\":\"Thermal power generated by the power\",\"readOnly\":false,\"title\":\"thermalPower\",\"type\":\"number\"},\"acousticAlarmSignalOn\":{\"description\":\"Describes if the acoustic alarm signal is on\",\"readOnly\":false,\"title\":\"acousticAlarmSignalOn\",\"type\":\"boolean\"},\"freezerTemperatureSetting\":{\"multipleOf\":0.5,\"unit\":\"\ufffdC\",\"maximum\":-18,\"description\":\"Refrigerator temperature requested by the\",\"readOnly\":false,\"title\":\"freezerTemperatureSetting\",\"type\":\"number\",\"minimum\":-30},\"printBedTargetTemperature\":{\"unit\":\"\ufffdC\",\"maximum\":500,\"description\":\"Print bed target temperature\",\"readOnly\":false,\"title\":\"printBedTargetTemperature\",\"type\":\"number\",\"minimum\":0},\"bodyWeight\":{\"unit\":\"kg\",\"maximum\":300,\"description\":\"Holds the weight measurement of a human\",\"readOnly\":true,\"title\":\"bodyWeight\",\"type\":\"number\",\"minimum\":0},\"heatingTemperatureSetting\":{\"multipleOf\":0.5,\"unit\":\"\ufffdC\",\"maximum\":40,\"description\":\"Requested temperature of the heater, that is\",\"readOnly\":false,\"title\":\"heatingTemperatureSetting\",\"type\":\"number\",\"minimum\":0},\"open\":{\"description\":\"Is 'true' if the window is open, otherwise\",\"readOnly\":false,\"title\":\"open\",\"type\":\"boolean\"},\"fallDetected\":{\"readOnly\":true,\"title\":\"fallDetected\",\"type\":\"boolean\"},\"printJobProgress\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Print job progress\",\"readOnly\":true,\"title\":\"printJobProgress\",\"type\":\"number\",\"minimum\":0},\"sulfurDioxide\":{\"unit\":\"g/m\ufffd\",\"maximum\":1000000,\"description\":\"Sulfur dioxide level\",\"readOnly\":true,\"title\":\"sulfurDioxide\",\"type\":\"number\",\"minimum\":0},\"powerFeedRestrictionLevel\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Power feed restriction imposed on the solar\",\"readOnly\":false,\"title\":\"powerFeedRestrictionLevel\",\"type\":\"number\",\"minimum\":0},\"airPressureTrend\":{\"description\":\"Air pressure trend\",\"readOnly\":true,\"title\":\"airPressureTrend\",\"type\":\"string\",\"enum\":[\"Falling Rapidly\",\"Falling Slowly\",\"Steady\"]},\"recordingPhotoDestination\":{\"description\":\"Stores the destination path for the captured\",\"readOnly\":false,\"title\":\"recordingPhotoDestination\",\"type\":\"string\"},\"windCardinalDirection\":{\"description\":\"Cardinal direction of the wind.\",\"readOnly\":true,\"title\":\"windCardinalDirection\",\"type\":\"string\",\"enum\":[\"S\",\"SE\",\"SW\",\"E\",\"W\",\"NE\",\"N\",\"NW\"]},\"alarmLampOn\":{\"description\":\"Holds the status of the alarm lamp.\",\"readOnly\":false,\"title\":\"alarmLampOn\",\"type\":\"boolean\"},\"liveVideoSupportedResolutions\":{\"description\":\"Comma-separated list of supported live\",\"readOnly\":true,\"title\":\"liveVideoSupportedResolutions\",\"type\":\"string\"},\"soundVolume\":{\"multipleOf\":2,\"unit\":\"%\",\"maximum\":100,\"description\":\"Sound volume.\",\"readOnly\":false,\"title\":\"soundVolume\",\"type\":\"integer\",\"minimum\":0},\"carbonDioxidePPM\":{\"unit\":\"ppm\",\"maximum\":100000,\"description\":\"Carbon dioxide level in ppm\",\"readOnly\":true,\"title\":\"carbonDioxidePPM\",\"type\":\"number\",\"minimum\":0},\"windSpeed\":{\"unit\":\"m/s\",\"maximum\":130,\"description\":\"Wind speed\",\"readOnly\":true,\"title\":\"windSpeed\",\"type\":\"number\",\"minimum\":0},\"energyHarvesting\":{\"description\":\"Energy harvesting mode status\",\"readOnly\":false,\"title\":\"energyHarvesting\",\"type\":\"boolean\"},\"vehicleState\":{\"description\":\"State of the vehicle e.g. connected, charging\",\"readOnly\":false,\"title\":\"vehicleState\",\"type\":\"integer\"},\"dimmingLevel\":{\"multipleOf\":2,\"unit\":\"%\",\"maximum\":100,\"description\":\"Dimming level of the lamp, between 0 and\",\"readOnly\":false,\"title\":\"dimmingLevel\",\"type\":\"integer\",\"minimum\":0},\"airPressure\":{\"unit\":\"hPa\",\"maximum\":1150,\"description\":\"Barometric air pressure\",\"readOnly\":true,\"title\":\"airPressure\",\"type\":\"number\",\"minimum\":500},\"directNormalIrradiance\":{\"unit\":\"W/m\ufffd\",\"description\":\"Direct Normal Irradiance (DNI).\",\"readOnly\":true,\"title\":\"directNormalIrradiance\",\"type\":\"number\",\"minimum\":0},\"mediaURI\":{\"description\":\"Stores the URI of the media currently\",\"readOnly\":false,\"title\":\"mediaURI\",\"type\":\"string\"},\"rockerSwitchHorizontalStatus\":{\"description\":\"Status of a horizontal rocker switch\",\"readOnly\":true,\"title\":\"rockerSwitchHorizontalStatus\",\"type\":\"string\",\"enum\":[\"left\",\"released\",\"right\"]},\"globalHorizontalIrradiance\":{\"unit\":\"W/m\ufffd\",\"description\":\"Global Horizontal Irradiance (GHI).\",\"readOnly\":true,\"title\":\"globalHorizontalIrradiance\",\"type\":\"number\",\"minimum\":0},\"alarmSystemStatus\":{\"readOnly\":false,\"title\":\"alarmSystemStatus\",\"type\":\"string\",\"enum\":[\"Disarmed\",\"Armed\",\"Alarm Raised\"]},\"valvePosition\":{\"multipleOf\":5,\"unit\":\"%\",\"maximum\":100,\"description\":\"Current valve position of the heater.\",\"readOnly\":false,\"title\":\"valvePosition\",\"type\":\"number\",\"minimum\":0},\"recordingVideo\":{\"description\":\"Indicates whether the camera is currently\",\"readOnly\":false,\"title\":\"recordingVideo\",\"type\":\"boolean\"},\"minActiveTotalPower\":{\"unit\":\"kW\",\"description\":\"Minimum total active power.\",\"readOnly\":true,\"title\":\"minActiveTotalPower\",\"type\":\"number\"},\"roadSurfaceTemperature\":{\"unit\":\"\ufffdC\",\"maximum\":70,\"readOnly\":true,\"title\":\"roadSurfaceTemperature\",\"type\":\"number\",\"minimum\":-40},\"occupancyStatus\":{\"description\":\"Determines wheter a location (e.g. a parking\",\"readOnly\":true,\"title\":\"occupancyStatus\",\"type\":\"boolean\"},\"thunderstorm\":{\"description\":\"Determines if currently there is a\",\"readOnly\":true,\"title\":\"thunderstorm\",\"type\":\"boolean\"},\"humidityLevel\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Relative air humidity level\",\"readOnly\":true,\"title\":\"humidityLevel\",\"type\":\"number\",\"minimum\":0},\"hob2HeatLevelSetting\":{\"multipleOf\":10,\"unit\":\"%\",\"maximum\":100,\"description\":\"Heat level setting of hob 2.\",\"readOnly\":false,\"title\":\"hob2HeatLevelSetting\",\"type\":\"integer\",\"minimum\":0},\"movementDetected\":{\"description\":\"Defines whether a movement has been\",\"readOnly\":true,\"title\":\"movementDetected\",\"type\":\"boolean\"},\"fog\":{\"description\":\"Current fog status.\",\"readOnly\":true,\"title\":\"fog\",\"type\":\"boolean\"},\"rotationStatus\":{\"description\":\"Status of a rotary sensor\",\"readOnly\":true,\"title\":\"rotationStatus\",\"type\":\"string\",\"enum\":[\"counterclockwise\",\"no rotation\",\"clockwise\"]},\"carbonMonoxidePPM\":{\"unit\":\"ppm\",\"maximum\":1000000,\"description\":\"Carbon monoxide level in ppm\",\"readOnly\":true,\"title\":\"carbonMonoxidePPM\",\"type\":\"number\",\"minimum\":0},\"fanSpeedLevel\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Stores the speed level of the fan as a %\",\"readOnly\":false,\"title\":\"fanSpeedLevel\",\"type\":\"integer\",\"minimum\":0},\"averageCarSpeed\":{\"unit\":\"km/h\",\"maximum\":300,\"description\":\"Average Speed of traffic on a lane.\",\"readOnly\":true,\"title\":\"averageCarSpeed\",\"type\":\"number\",\"minimum\":0},\"speed\":{\"unit\":\"m/s\",\"maximum\":300000000,\"description\":\"Speed\",\"readOnly\":true,\"title\":\"speed\",\"type\":\"number\",\"minimum\":0},\"cabinetWorkingHeight\":{\"unit\":\"cm\",\"maximum\":200,\"description\":\"Cabinet working height\",\"readOnly\":false,\"title\":\"cabinetWorkingHeight\",\"type\":\"number\",\"minimum\":0},\"waterFeedTemperature\":{\"unit\":\"\ufffdC\",\"maximum\":100,\"description\":\"Water feed temperature of heater\",\"readOnly\":true,\"title\":\"waterFeedTemperature\",\"type\":\"number\",\"minimum\":0},\"floorNumber\":{\"maximum\":200,\"readOnly\":false,\"title\":\"floorNumber\",\"type\":\"integer\",\"minimum\":-5},\"printJobName\":{\"readOnly\":true,\"title\":\"printJobName\",\"type\":\"string\"},\"homeButtonBlueLED\":{\"description\":\"Blue LED of the home button.\",\"readOnly\":false,\"title\":\"homeButtonBlueLED\",\"type\":\"boolean\"},\"batteryVoltage\":{\"unit\":\"V\",\"maximum\":25,\"description\":\"Battery voltage indicating the power left in\",\"readOnly\":true,\"title\":\"batteryVoltage\",\"type\":\"number\",\"minimum\":0},\"locationLatitude\":{\"unit\":\"\ufffd\",\"maximum\":360,\"description\":\"Current geographical location latitude.\",\"readOnly\":true,\"title\":\"locationLatitude\",\"type\":\"number\",\"minimum\":0},\"solarElevationAngle\":{\"unit\":\"\ufffd\",\"maximum\":90,\"description\":\"Current altitude of the Sun, the angle\",\"readOnly\":true,\"title\":\"solarElevationAngle\",\"type\":\"number\",\"minimum\":-90},\"cloudiness\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"% of sky covered with clouds\",\"readOnly\":true,\"title\":\"cloudiness\",\"type\":\"integer\",\"minimum\":0},\"voltage\":{\"unit\":\"V\",\"description\":\"Electric voltage\",\"readOnly\":true,\"title\":\"voltage\",\"type\":\"number\"},\"ultravioletIndex\":{\"description\":\"Ultraviolet index (UV Index)\",\"readOnly\":true,\"title\":\"ultravioletIndex\",\"type\":\"number\",\"minimum\":0},\"contactDetected\":{\"description\":\"Defines whether a contact has been\",\"readOnly\":true,\"title\":\"contactDetected\",\"type\":\"boolean\"},\"electricalPower\":{\"unit\":\"W\",\"description\":\"Electrical power generated by the power\",\"readOnly\":false,\"title\":\"electricalPower\",\"type\":\"number\"},\"hue\":{\"unit\":\"\ufffd\",\"maximum\":360,\"description\":\"Hue of a light source. Together with the\",\"readOnly\":false,\"title\":\"hue\",\"type\":\"number\",\"minimum\":0},\"hob4HeatLevelRemaining\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Remaining heat level of hob 4.\",\"readOnly\":true,\"title\":\"hob4HeatLevelRemaining\",\"type\":\"integer\",\"minimum\":0},\"currentIlluminanceSouth\":{\"unit\":\"lx\",\"maximum\":100000,\"description\":\"Current illuminance from south\",\"readOnly\":true,\"title\":\"currentIlluminanceSouth\",\"type\":\"number\",\"minimum\":0},\"averageWindSpeed\":{\"unit\":\"m/s\",\"maximum\":130,\"description\":\"Average wind speed\",\"readOnly\":true,\"title\":\"averageWindSpeed\",\"type\":\"number\",\"minimum\":0},\"deicerDensity\":{\"unit\":\"g/m\ufffd\",\"maximum\":1000,\"readOnly\":true,\"title\":\"deicerDensity\",\"type\":\"number\",\"minimum\":0},\"relativeHumidityAtRoadTemperature\":{\"unit\":\"%\",\"maximum\":100,\"readOnly\":true,\"title\":\"relativeHumidityAtRoadTemperature\",\"type\":\"number\",\"minimum\":0},\"windowStatusAssessment\":{\"description\":\"Window status assessment based on\",\"readOnly\":true,\"title\":\"windowStatusAssessment\",\"type\":\"boolean\"},\"batteryTemperature\":{\"unit\":\"\ufffdC\",\"description\":\"Temperature of the battery.\",\"readOnly\":true,\"title\":\"batteryTemperature\",\"type\":\"number\",\"minimum\":-273.15},\"particlePM2dot5\":{\"unit\":\"g/m\ufffd\",\"maximum\":10000,\"description\":\"Particulate matter PM.\",\"readOnly\":true,\"title\":\"particlePM2dot5\",\"type\":\"number\",\"minimum\":0},\"freezingTemperature\":{\"readOnly\":true,\"title\":\"freezingTemperature\",\"type\":\"string\",\"enum\":[\"NotDetectable\",\"EqualsRoadTemperature\"]},\"occupancyButtonState\":{\"description\":\"Describes the state of a occupancy button,\",\"readOnly\":true,\"title\":\"occupancyButtonState\",\"type\":\"boolean\"},\"hob2HeatLevelRemaining\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Remaining heat level of hob 2.\",\"readOnly\":true,\"title\":\"hob2HeatLevelRemaining\",\"type\":\"integer\",\"minimum\":0},\"apiUrl\":{\"description\":\"URL to extended device API\",\"readOnly\":true,\"title\":\"apiUrl\",\"type\":\"string\"},\"programName\":{\"description\":\"Stores the name of the program of this\",\"readOnly\":false,\"title\":\"programName\",\"type\":\"string\"},\"locationLongitude\":{\"unit\":\"\ufffd\",\"maximum\":360,\"description\":\"Current geographical location longitude.\",\"readOnly\":true,\"title\":\"locationLongitude\",\"type\":\"number\",\"minimum\":0},\"presence\":{\"description\":\"Presence detection\",\"readOnly\":true,\"title\":\"presence\",\"type\":\"boolean\"},\"powerLineFrequency\":{\"unit\":\"Hz\",\"maximum\":150,\"description\":\"The nominal frequency of the oscillations of\",\"readOnly\":true,\"title\":\"powerLineFrequency\",\"type\":\"number\",\"minimum\":0},\"trafficLightBusLaneState\":{\"readOnly\":true,\"title\":\"trafficLightBusLaneState\",\"type\":\"string\",\"enum\":[\"CloseDoors\",\"GreenConsideringRTA\",\"Halt\"]},\"liveImageURI\":{\"description\":\"URI to the current still image.\",\"readOnly\":true,\"title\":\"liveImageURI\",\"type\":\"string\"},\"capacityLevel\":{\"unit\":\"Ah\",\"description\":\"Actual capacity level of the battery, unit Ah\",\"readOnly\":false,\"title\":\"capacityLevel\",\"type\":\"number\",\"minimum\":0},\"chargeRate\":{\"unit\":\"C\",\"description\":\"Charge rate, unit Coulomb\",\"readOnly\":false,\"title\":\"chargeRate\",\"type\":\"number\"},\"internalLampOn\":{\"description\":\"Holds the status of the internal lamp\",\"readOnly\":false,\"title\":\"internalLampOn\",\"type\":\"boolean\"},\"movementFromLeftToRightDetected\":{\"description\":\"Defines movement from right to left.\",\"readOnly\":true,\"title\":\"movementFromLeftToRightDetected\",\"type\":\"boolean\"},\"crossingsPerMinute\":{\"readOnly\":true,\"title\":\"crossingsPerMinute\",\"type\":\"integer\",\"minimum\":0},\"blindSlatAngle\":{\"unit\":\"\ufffd\",\"maximum\":180,\"description\":\"Angle of the slats, 0\ufffd is vertical, 90\ufffd is\",\"readOnly\":false,\"title\":\"blindSlatAngle\",\"type\":\"number\",\"minimum\":0},\"reactivePowerL1\":{\"unit\":\"kvar\",\"description\":\"Reactive power of phase 1 (L1).\",\"readOnly\":true,\"title\":\"reactivePowerL1\",\"type\":\"number\"},\"hob1HeatLevelRemaining\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Remaining heat level of hob 1.\",\"readOnly\":true,\"title\":\"hob1HeatLevelRemaining\",\"type\":\"integer\",\"minimum\":0},\"reactivePowerL3\":{\"unit\":\"kvar\",\"description\":\"Reactive power of phase 3 (L3).\",\"readOnly\":true,\"title\":\"reactivePowerL3\",\"type\":\"number\"},\"reactivePowerL2\":{\"unit\":\"kvar\",\"description\":\"Reactive power of phase 2 (L2).\",\"readOnly\":true,\"title\":\"reactivePowerL2\",\"type\":\"number\"},\"ambientVolumeLevel\":{\"multipleOf\":1,\"unit\":\"dB\",\"maximum\":150,\"description\":\"Sound volume of the environment.\",\"readOnly\":true,\"title\":\"ambientVolumeLevel\",\"type\":\"number\",\"minimum\":0},\"toggleState\":{\"description\":\"Toggle switch state\",\"readOnly\":true,\"title\":\"toggleState\",\"type\":\"boolean\"},\"batteryChargingState\":{\"description\":\"Indicates if the battery of the device is\",\"readOnly\":true,\"title\":\"batteryChargingState\",\"type\":\"boolean\"},\"displayStatus\":{\"description\":\"Indicates whether a display is on or off.\",\"readOnly\":false,\"title\":\"displayStatus\",\"type\":\"boolean\"},\"valveStatus\":{\"description\":\"Describes if the valve is open or closed.\",\"readOnly\":false,\"title\":\"valveStatus\",\"type\":\"boolean\"},\"dishwasherProgram\":{\"description\":\"Dish washer program\",\"readOnly\":false,\"title\":\"dishwasherProgram\",\"type\":\"string\",\"enum\":[\"Quick\",\"Eco\",\"Intensive\"]},\"deviceStatus\":{\"description\":\"Holds the status of the device.\",\"readOnly\":true,\"title\":\"deviceStatus\",\"type\":\"string\",\"enum\":[\"OK\",\"Driver Stopped\",\"Driver Not Ready\"]},\"rockerSwitchVerticalStatus\":{\"description\":\"Status of a vertical rocker switch\",\"readOnly\":true,\"title\":\"rockerSwitchVerticalStatus\",\"type\":\"string\",\"enum\":[\"up\",\"released\",\"down\"]},\"waterFilmHeightOnSurface\":{\"unit\":\"m\",\"maximum\":6000,\"readOnly\":true,\"title\":\"waterFilmHeightOnSurface\",\"type\":\"number\",\"minimum\":0},\"cabinetWorkingHeightMin\":{\"unit\":\"cm\",\"maximum\":200,\"description\":\"Cabinet minimum working height\",\"readOnly\":true,\"title\":\"cabinetWorkingHeightMin\",\"type\":\"number\",\"minimum\":0},\"outsideEnvironmentHumidityLevel\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Relative air humidity level outside\",\"readOnly\":true,\"title\":\"outsideEnvironmentHumidityLevel\",\"type\":\"number\",\"minimum\":0},\"angle\":{\"unit\":\"\ufffd\",\"maximum\":360,\"description\":\"The current angle\",\"readOnly\":true,\"title\":\"angle\",\"type\":\"number\",\"minimum\":0},\"activeEnergyPositive\":{\"unit\":\"kWh\",\"description\":\"Positive active energy (A+).\",\"readOnly\":true,\"title\":\"activeEnergyPositive\",\"type\":\"number\",\"minimum\":0},\"activePowerTotalSetPoint\":{\"unit\":\"kW\",\"description\":\"Set-point for total active power.\",\"readOnly\":false,\"title\":\"activePowerTotalSetPoint\",\"type\":\"number\"},\"BloodPressureSystolic\":{\"unit\":\"mmHg\",\"maximum\":300,\"description\":\"Systolic blood pressure.\",\"readOnly\":true,\"title\":\"BloodPressureSystolic\",\"type\":\"number\",\"minimum\":0},\"startTime\":{\"description\":\"Start time of the program, expressed in\",\"readOnly\":false,\"title\":\"startTime\",\"type\":\"string\"},\"supportedCommunicationIntervals\":{\"description\":\"Supported communication interval times in\",\"readOnly\":true,\"title\":\"supportedCommunicationIntervals\",\"type\":\"string\"},\"batteryLevel\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Battery level where 100% is a fully charged\",\"readOnly\":true,\"title\":\"batteryLevel\",\"type\":\"number\",\"minimum\":0},\"currentEnvironmentTemperature\":{\"unit\":\"\ufffdC\",\"maximum\":60,\"description\":\"Current temperature in the environment\",\"readOnly\":true,\"title\":\"currentEnvironmentTemperature\",\"type\":\"number\",\"minimum\":-60},\"soilMoisture\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Soil moisture level\",\"readOnly\":true,\"title\":\"soilMoisture\",\"type\":\"number\",\"minimum\":0},\"blindLevel\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Level of the blind in percent, between 0\",\"readOnly\":false,\"title\":\"blindLevel\",\"type\":\"integer\",\"minimum\":0},\"declaredMaximumPower\":{\"unit\":\"W\",\"maximum\":3600,\"description\":\"Declared maximum power of a home\",\"readOnly\":false,\"title\":\"declaredMaximumPower\",\"type\":\"number\",\"minimum\":0},\"hydrogenSulfide\":{\"unit\":\"g/m\ufffd\",\"maximum\":1000000,\"description\":\"Hydrogen sulfide level\",\"readOnly\":true,\"title\":\"hydrogenSulfide\",\"type\":\"number\",\"minimum\":0},\"averageSpeed\":{\"unit\":\"km/h\",\"maximum\":300,\"description\":\"Average Speed of traffic on a lane.\",\"readOnly\":true,\"title\":\"averageSpeed\",\"type\":\"number\",\"minimum\":0},\"dewPoint\":{\"unit\":\"\ufffdC\",\"maximum\":40,\"description\":\"Dew point\",\"readOnly\":true,\"title\":\"dewPoint\",\"type\":\"number\",\"minimum\":-60},\"outsideEnvironmentApparentTemperature\":{\"unit\":\"\ufffdC\",\"maximum\":60,\"description\":\"Perceived temperature outside of the home\",\"readOnly\":true,\"title\":\"outsideEnvironmentApparentTemperature\",\"type\":\"number\",\"minimum\":-60},\"alarmSound\":{\"description\":\"Alarm sound file\",\"readOnly\":false,\"title\":\"alarmSound\",\"type\":\"string\"},\"hob3HeatLevelRemaining\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Remaining heat level of hob 3.\",\"readOnly\":true,\"title\":\"hob3HeatLevelRemaining\",\"type\":\"integer\",\"minimum\":0},\"sulfurDioxidePPM\":{\"unit\":\"ppm\",\"maximum\":1000000,\"description\":\"Sulfur dioxide level in ppm\",\"readOnly\":true,\"title\":\"sulfurDioxidePPM\",\"type\":\"number\",\"minimum\":0},\"extruder1TargetTemperature\":{\"unit\":\"\ufffdC\",\"maximum\":500,\"description\":\"Extruder 1 target temperature\",\"readOnly\":false,\"title\":\"extruder1TargetTemperature\",\"type\":\"number\",\"minimum\":0},\"heatingMode\":{\"description\":\"Mode of operation of the heater.\",\"readOnly\":false,\"title\":\"heatingMode\",\"type\":\"string\",\"enum\":[\"Normal\",\"AntiFreeze\",\"Summer\",\"Standby\"]},\"pedestrianLightState\":{\"description\":\"Pedestrian light state\",\"readOnly\":true,\"title\":\"pedestrianLightState\",\"type\":\"string\",\"enum\":[\"Green\",\"Red\",\"GreenFlashing\"]},\"currentWaterTemperature\":{\"unit\":\"\ufffdC\",\"maximum\":100,\"description\":\"Current temperature in the environment\",\"readOnly\":true,\"title\":\"currentWaterTemperature\",\"type\":\"number\",\"minimum\":0},\"printTimeTotal\":{\"unit\":\"s\",\"description\":\"Total print time estimate\",\"readOnly\":true,\"title\":\"printTimeTotal\",\"type\":\"integer\",\"minimum\":0},\"bodySensorLocation\":{\"description\":\"Describes the location of a sensor at the\",\"readOnly\":true,\"title\":\"bodySensorLocation\",\"type\":\"string\",\"enum\":[\"Chest\",\"Wrist\",\"Finger\",\"Hand\",\"Ear Lobe\",\"Foot\"]},\"mountingLocation\":{\"description\":\"Mounting locaation\",\"readOnly\":true,\"title\":\"mountingLocation\",\"type\":\"string\",\"enum\":[\"Indoor\",\"Outdoor\"]},\"voltageL1\":{\"unit\":\"V\",\"description\":\"Phase 1 (L1) voltage.\",\"readOnly\":true,\"title\":\"voltageL1\",\"type\":\"number\"},\"voltageL2\":{\"unit\":\"V\",\"description\":\"Phase 2 (L2) voltage.\",\"readOnly\":true,\"title\":\"voltageL2\",\"type\":\"number\"},\"currentIlluminanceEast\":{\"unit\":\"lx\",\"maximum\":100000,\"description\":\"Current illuminance from east\",\"readOnly\":true,\"title\":\"currentIlluminanceEast\",\"type\":\"number\",\"minimum\":0},\"voltageL3\":{\"unit\":\"V\",\"description\":\"Phase 3 (L3) voltage.\",\"readOnly\":true,\"title\":\"voltageL3\",\"type\":\"number\"},\"colorTemperature\":{\"multipleOf\":25,\"unit\":\"K\",\"maximum\":7000,\"description\":\"Color temperature\",\"readOnly\":false,\"title\":\"colorTemperature\",\"type\":\"integer\",\"minimum\":1500},\"availableAlarmSounds\":{\"description\":\"Available alarm sound files\",\"readOnly\":true,\"title\":\"availableAlarmSounds\",\"type\":\"string\"},\"saturation\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"Saturation of a light source. Together with\",\"readOnly\":false,\"title\":\"saturation\",\"type\":\"number\",\"minimum\":0},\"currentIlluminance\":{\"unit\":\"lx\",\"maximum\":100000,\"description\":\"Current illuminance in the environment\",\"readOnly\":true,\"title\":\"currentIlluminance\",\"type\":\"number\",\"minimum\":0},\"currentL3\":{\"unit\":\"A\",\"description\":\"Phase 3 (L3) current.\",\"readOnly\":true,\"title\":\"currentL3\",\"type\":\"number\"},\"vehicleConnectionStatus\":{\"description\":\"Determines whether the vehicle is\",\"readOnly\":true,\"title\":\"vehicleConnectionStatus\",\"type\":\"boolean\"},\"filamentVolumeTotal\":{\"unit\":\"cm\ufffd\",\"description\":\"Total filament volume estimate.\",\"readOnly\":true,\"title\":\"filamentVolumeTotal\",\"type\":\"number\",\"minimum\":0},\"locked\":{\"description\":\"Is 'true' if the window is locked, otherwise\",\"readOnly\":false,\"title\":\"locked\",\"type\":\"boolean\"},\"longitude\":{\"unit\":\"\ufffd\",\"maximum\":180,\"description\":\"Longitude\",\"readOnly\":false,\"title\":\"longitude\",\"type\":\"number\",\"minimum\":-180},\"communicationInterval\":{\"unit\":\"s\",\"maximum\":86400,\"description\":\"Maximum time between two data packets of\",\"readOnly\":false,\"title\":\"communicationInterval\",\"type\":\"integer\",\"minimum\":0},\"smokeDetected\":{\"description\":\"Defines whether smoke has been detected\",\"readOnly\":true,\"title\":\"smokeDetected\",\"type\":\"boolean\"},\"cabinetWorkingHeightMax\":{\"unit\":\"cm\",\"maximum\":200,\"description\":\"Cabinet maximum working height\",\"readOnly\":true,\"title\":\"cabinetWorkingHeightMax\",\"type\":\"number\",\"minimum\":0},\"recordingPhoto\":{\"description\":\"Indicates whether the camera is currently\",\"readOnly\":false,\"title\":\"recordingPhoto\",\"type\":\"boolean\"},\"nitrogenMonoxide\":{\"unit\":\"g/m\ufffd\",\"maximum\":1000000,\"description\":\"Nitrogen monoxide level\",\"readOnly\":true,\"title\":\"nitrogenMonoxide\",\"type\":\"number\",\"minimum\":0},\"secondsRemaining\":{\"unit\":\"s\",\"description\":\"Stores the remaining time (in seconds) for\",\"readOnly\":true,\"title\":\"secondsRemaining\",\"type\":\"integer\",\"minimum\":0},\"movementFromRightToLeftDetected\":{\"description\":\"Defines movement from left to right.\",\"readOnly\":true,\"title\":\"movementFromRightToLeftDetected\",\"type\":\"boolean\"},\"currentL1\":{\"unit\":\"A\",\"description\":\"Phase 1 (L1) current.\",\"readOnly\":true,\"title\":\"currentL1\",\"type\":\"number\"},\"currentL2\":{\"unit\":\"A\",\"description\":\"Phase 2 (L2) current.\",\"readOnly\":true,\"title\":\"currentL2\",\"type\":\"number\"},\"solarAzimuth\":{\"unit\":\"\ufffd\",\"maximum\":360,\"description\":\"Solar azimuth angle, where 0\ufffd is north.\",\"readOnly\":true,\"title\":\"solarAzimuth\",\"type\":\"number\",\"minimum\":0},\"waterTemperatureSetting\":{\"multipleOf\":0.5,\"unit\":\"\ufffdC\",\"maximum\":100,\"description\":\"Water temperature in Celsius.\",\"readOnly\":false,\"title\":\"waterTemperatureSetting\",\"type\":\"number\",\"minimum\":0},\"heartRate\":{\"unit\":\"bpm\",\"maximum\":250,\"description\":\"Heart rate per minute.\",\"readOnly\":true,\"title\":\"heartRate\",\"type\":\"integer\",\"minimum\":0},\"recordingVideoDestination\":{\"description\":\"Stores the destination path for the captured\",\"readOnly\":false,\"title\":\"recordingVideoDestination\",\"type\":\"string\"},\"connectionStatus\":{\"description\":\"Connection status of a device that needs to\",\"readOnly\":false,\"title\":\"connectionStatus\",\"type\":\"boolean\"},\"playbackState\":{\"description\":\"Stores the playback state of the device, one\",\"readOnly\":false,\"title\":\"playbackState\",\"type\":\"string\",\"enum\":[\"play\",\"pause\",\"stop\"]},\"contactSensorMountingType\":{\"description\":\"Mounting type of a contact sensor.\",\"readOnly\":false,\"title\":\"contactSensorMountingType\",\"type\":\"string\",\"enum\":[\"Window\",\"InnerDoor\",\"EntranceDoor\"]},\"currentTotal\":{\"unit\":\"A\",\"description\":\"Total current of all phases of the electrical\",\"readOnly\":true,\"title\":\"currentTotal\",\"type\":\"number\"},\"extruder2TargetTemperature\":{\"unit\":\"\ufffdC\",\"maximum\":500,\"description\":\"Extruder 2 target temperature\",\"readOnly\":false,\"title\":\"extruder2TargetTemperature\",\"type\":\"number\",\"minimum\":0},\"deicerDensityMeaning\":{\"readOnly\":true,\"title\":\"deicerDensityMeaning\",\"type\":\"string\",\"enum\":[\"NotDetectable\",\"RealValue\",\"MinimumValue\"]},\"rainIntensity\":{\"description\":\"Current rain intensity.\",\"readOnly\":true,\"title\":\"rainIntensity\",\"type\":\"string\",\"enum\":[\"No Rain\",\"Light Rain\",\"Rain\",\"Heavy Rain\"]},\"meterReading\":{\"unit\":\"Wh\",\"description\":\"Power reading\",\"readOnly\":true,\"title\":\"meterReading\",\"type\":\"number\"},\"carbonMonoxide\":{\"unit\":\"g/m\ufffd\",\"maximum\":1000000,\"description\":\"Carbon monoxide level\",\"readOnly\":true,\"title\":\"carbonMonoxide\",\"type\":\"number\",\"minimum\":0},\"electricCurrentLimit\":{\"unit\":\"A\",\"description\":\"Limits the electric charging by setting a limit\",\"readOnly\":false,\"title\":\"electricCurrentLimit\",\"type\":\"number\"},\"activeOxygenPPM\":{\"unit\":\"ppm\",\"maximum\":1000000,\"description\":\"Active oxygen level in ppm\",\"readOnly\":true,\"title\":\"activeOxygenPPM\",\"type\":\"number\",\"minimum\":0},\"lockBit\":{\"description\":\"Lock bit disables the controls of the device\",\"readOnly\":false,\"title\":\"lockBit\",\"type\":\"boolean\"},\"powerUsageEstimate\":{\"unit\":\"W\",\"maximum\":3680,\"description\":\"The current electric power load of a home\",\"readOnly\":true,\"title\":\"powerUsageEstimate\",\"type\":\"number\",\"minimum\":0},\"hob1HeatLevelSetting\":{\"multipleOf\":10,\"unit\":\"%\",\"maximum\":100,\"description\":\"Heat level setting of hob 1.\",\"readOnly\":false,\"title\":\"hob1HeatLevelSetting\",\"type\":\"integer\",\"minimum\":0},\"printerState\":{\"description\":\"Current state of the printer. Offline means\",\"readOnly\":true,\"title\":\"printerState\",\"type\":\"string\",\"enum\":[\"Offline\",\"Online\",\"Ready\",\"Preparing\",\"Heating\"]},\"powerProduction\":{\"unit\":\"W\",\"maximum\":3680,\"description\":\"The current electric power produced by a\",\"readOnly\":true,\"title\":\"powerProduction\",\"type\":\"number\",\"minimum\":0},\"mediaTitle\":{\"description\":\"Stores the title of the media currently played.\",\"readOnly\":false,\"title\":\"mediaTitle\",\"type\":\"string\"},\"activePowerL3\":{\"unit\":\"kW\",\"description\":\"Active power of phase 3 (L3).\",\"readOnly\":true,\"title\":\"activePowerL3\",\"type\":\"number\"},\"averageMotorcycleSpeed\":{\"unit\":\"km/h\",\"maximum\":300,\"description\":\"Average Speed of traffic on a lane.\",\"readOnly\":true,\"title\":\"averageMotorcycleSpeed\",\"type\":\"number\",\"minimum\":0},\"hob4HeatLevelSetting\":{\"multipleOf\":10,\"unit\":\"%\",\"maximum\":100,\"description\":\"Heat level setting of hob 4.\",\"readOnly\":false,\"title\":\"hob4HeatLevelSetting\",\"type\":\"integer\",\"minimum\":0},\"sunsetTime\":{\"description\":\"Today's sunset time in milliseconds since\",\"readOnly\":true,\"title\":\"sunsetTime\",\"type\":\"string\"},\"activePowerL2\":{\"unit\":\"kW\",\"description\":\"Active power of phase 2 (L2).\",\"readOnly\":true,\"title\":\"activePowerL2\",\"type\":\"number\"},\"activePowerL1\":{\"unit\":\"kW\",\"description\":\"Active power of phase 1 (L1).\",\"readOnly\":true,\"title\":\"activePowerL1\",\"type\":\"number\"},\"stateOfHealth\":{\"unit\":\"%\",\"maximum\":100,\"description\":\"State of battery health\",\"readOnly\":true,\"title\":\"stateOfHealth\",\"type\":\"integer\",\"minimum\":0},\"stopTime\":{\"description\":\"Stop time of the program, expressed in\",\"readOnly\":false,\"title\":\"stopTime\",\"type\":\"string\"},\"on\":{\"description\":\"Stores the on/off status of the device, with\",\"readOnly\":false,\"title\":\"on\",\"type\":\"boolean\"},\"sunriseTime\":{\"description\":\"Today's sunrise time in milliseconds since\",\"readOnly\":true,\"title\":\"sunriseTime\",\"type\":\"string\"},\"currentIlluminanceNorth\":{\"unit\":\"lx\",\"maximum\":100000,\"description\":\"Current illuminance from north\",\"readOnly\":true,\"title\":\"currentIlluminanceNorth\",\"type\":\"number\",\"minimum\":0},\"particlePM0dot1\":{\"unit\":\"g/m\ufffd\",\"maximum\":10000,\"description\":\"Particulate matter PM.\",\"readOnly\":true,\"title\":\"particlePM0dot1\",\"type\":\"number\",\"minimum\":0},\"hvacOperationMode\":{\"description\":\"Determines if the HVAC is heating or\",\"readOnly\":false,\"title\":\"hvacOperationMode\",\"type\":\"boolean\"},\"liveVideoResolution\":{\"description\":\"Resolution of the live video image.\",\"readOnly\":false,\"title\":\"liveVideoResolution\",\"type\":\"string\",\"enum\":[\"160x120\",\"320x176\",\"320x240\",\"480x272\"]},\"liveVideoURI\":{\"description\":\"URI (possibly relative to IOLITE host)\",\"readOnly\":true,\"title\":\"liveVideoURI\",\"type\":\"string\"},\"northAzimuth\":{\"unit\":\"\ufffd\",\"maximum\":360,\"description\":\"North azimuth of an element, describing its\",\"readOnly\":true,\"title\":\"northAzimuth\",\"type\":\"integer\",\"minimum\":0},\"reactivePowerTotal\":{\"unit\":\"kvar\",\"description\":\"Total reactive power.\",\"readOnly\":true,\"title\":\"reactivePowerTotal\",\"type\":\"number\"},\"maxActiveTotalPower\":{\"unit\":\"kW\",\"description\":\"Maximum total active power.\",\"readOnly\":true,\"title\":\"maxActiveTotalPower\",\"type\":\"number\"},\"refrigeratorTemperatureSetting\":{\"multipleOf\":0.5,\"unit\":\"\ufffdC\",\"maximum\":8,\"description\":\"Refrigerator temperature requested by the\",\"readOnly\":false,\"title\":\"refrigeratorTemperatureSetting\",\"type\":\"number\",\"minimum\":2},\"blindDriveStatus\":{\"description\":\"Drive property enables a relative control of\",\"readOnly\":false,\"title\":\"blindDriveStatus\",\"type\":\"string\",\"enum\":[\"moving in\",\"moving out\",\"stopped\"]},\"friction\":{\"maximum\":1,\"readOnly\":true,\"title\":\"friction\",\"type\":\"number\",\"minimum\":0},\"activeEnergyNegative\":{\"unit\":\"kWh\",\"description\":\"Negative active energy (A-).\",\"readOnly\":true,\"title\":\"activeEnergyNegative\",\"type\":\"number\",\"minimum\":0},\"extremeWeather\":{\"description\":\"Describes if there are currently extreme\",\"readOnly\":true,\"title\":\"extremeWeather\",\"type\":\"boolean\"},\"reactiveEnergyPositive\":{\"unit\":\"kvarh\",\"description\":\"Positive reactive energy (R+).\",\"readOnly\":true,\"title\":\"reactiveEnergyPositive\",\"type\":\"number\",\"minimum\":0}},\"$id\":\"https://kosmos-lab.de/schema/All.json\"},{\"$schema\":\"http://json-schema.org/draft-07/schema#\",\"title\":\"Person\",\"type\":\"object\",\"properties\":{\"firstName\":{\"description\":\"The person's first name.\",\"type\":\"string\"},\"lastName\":{\"description\":\"The person's last name.\",\"type\":\"string\"},\"age\":{\"description\":\"Age in years which must be equal to or greater than zero.\",\"type\":\"integer\",\"minimum\":0}},\"$id\":\"https://example.com/person.schema.json\"}]")})})})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, UnauthorizedException {
        JSONArray arr = new JSONArray();
        for (DataSchema d : this.controller.getAllSchemas()) {
            JSONObject o = new JSONObject(d.getRawSchema().toMap());
            o.remove("examples");
            o.remove("failures");
            arr.put((Object)o);
        }
        SchemaListServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONArray)arr);
    }
}

