/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.gesture;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.exceptions.GestureNotFoundException;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.platform.web.servlets.gesture.GestureListServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.ParameterIn;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONArray;

@ApiEndpoint(path="/gesture/delete", userLevel=1)
public class GestureDeleteServlet
extends KosmoSAuthedServlet {
    public GestureDeleteServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"device"}, summary="delete", description="Delete a gesture from the system.", parameters={@Parameter(name="id", in=ParameterIn.QUERY, schema=@Schema(description="The uuid of the device to delete", type=SchemaType.STRING, minLength=3, required=true))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="The gesture was added successfully", ref="#/components/responses/gestureList")})
    public void delete(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, ParameterNotFoundException, GestureNotFoundException, UnauthorizedException {
        String id = request.getString("id");
        if (this.controller.getGestureProvider().deleteGesture(id)) {
            GestureDeleteServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONArray)GestureListServlet.getGestureList(this.controller));
            return;
        }
        throw new GestureNotFoundException(id);
    }
}

