/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.device;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.exceptions.DeviceNotFoundException;
import de.kosmos_lab.platform.exceptions.NoAccessToScope;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.ParameterIn;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.ObjectSchema;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.parameters.RequestBody;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONObject;

@ApiEndpoint(path="/device/location", userLevel=1)
@ObjectSchema(componentName="deviceLocation", properties={@SchemaProperty(name="x", schema=@Schema(description="the x coordinate of the device", type=SchemaType.NUMBER, required=false)), @SchemaProperty(name="y", schema=@Schema(description="the y coordinate of the device", type=SchemaType.NUMBER, required=false)), @SchemaProperty(name="z", schema=@Schema(description="the z coordinate of the device", type=SchemaType.NUMBER, required=false)), @SchemaProperty(name="w", schema=@Schema(description="the width of the device", type=SchemaType.NUMBER, required=false)), @SchemaProperty(name="d", schema=@Schema(description="the depth of the device", type=SchemaType.NUMBER, required=false)), @SchemaProperty(name="h", schema=@Schema(description="the height of the device", type=SchemaType.NUMBER, required=false)), @SchemaProperty(name="roll", schema=@Schema(description="the roll of the device", type=SchemaType.NUMBER, required=false)), @SchemaProperty(name="pitch", schema=@Schema(description="the pitch of the device", type=SchemaType.NUMBER, required=false)), @SchemaProperty(name="yaw", schema=@Schema(description="the yaw of the device", type=SchemaType.NUMBER, required=false)), @SchemaProperty(name="area", schema=@Schema(description="the area the device is located in", type=SchemaType.STRING, required=false))})
public class DeviceLocationServlet
extends KosmoSAuthedServlet {
    public DeviceLocationServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"device"}, summary="get location", description="Get the location of the device", parameters={@Parameter(name="uuid", in=ParameterIn.QUERY, schema=@Schema(description="The uuid of the device to get", type=SchemaType.STRING, minLength=3, required=true))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="the location of the device", content={@Content(mediaType="application/json", examples={@ExampleObject(name="light1", value="{\"x\":10,\"y\":124,\"z\":24,\"area\":\"livingroom\"}"), @ExampleObject(name="light2", value="{\"x\":145,\"y\":125,\"z\":125,\"roll\":12,\"pitch\":24,\"yaw\":46,\"w\":10,\"d\":10,\"h\":10,\"area\":\"bedroom\"}")}, schema=@Schema(ref="#/components/schemas/deviceLocation"))})})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, NoAccessToScope, DeviceNotFoundException, ParameterNotFoundException, UnauthorizedException {
        String uuid = request.getUUID();
        Device.Location loc = this.controller.getLocation(request.getKosmoSUser(), uuid);
        if (loc != null) {
            DeviceLocationServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)loc.toJSON());
        } else {
            DeviceLocationServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)new JSONObject());
        }
    }

    @Override
    @Operation(tags={"device"}, summary="set location", description="set the location of the device", requestBody=@RequestBody(required=true, content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="uuid", schema=@Schema(description="The uuid of the device to get", type=SchemaType.STRING, minLength=3, required=true)), @SchemaProperty(name="location", schema=@Schema(ref="#/components/schemas/deviceLocation", required=true))}, examples={@ExampleObject(name="moved MultiSensor2 to bedroom", value="{\"uuid\":\"multi2\",\"location\":{\"area\":\"bedroom\",\"x\":140,\"y\":120,\"z\":85}}"), @ExampleObject(name="MultiSensor17 changed rotation", value="{\"uuid\":\"multi2\",\"location\":{\"yaw\":140,\"pitch\":120,\"roll\":85}}")})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="the (full) location of the device - also contains the parameters that were already there and not overwritten by the request", content={@Content(mediaType="application/json", examples={@ExampleObject(name="light1", value="{\"x\":10,\"y\":124,\"z\":24,\"area\":\"livingroom\"}"), @ExampleObject(name="light2", value="{\"x\":145,\"y\":125,\"z\":125,\"roll\":12,\"pitch\":24,\"yaw\":46,\"w\":10,\"d\":10,\"h\":10,\"area\":\"bedroom\"}")}, schema=@Schema(ref="#/components/schemas/deviceLocation"))})})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, DeviceNotFoundException, ParameterNotFoundException, NoAccessToScope, UnauthorizedException {
        JSONObject o = request.getBodyAsJSONObject();
        if (!o.has("uuid")) {
            try {
                o.put("uuid", (Object)request.getString("uuid"));
            }
            catch (ParameterNotFoundException e) {
                e.printStackTrace();
            }
        }
        DeviceLocationServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)this.controller.setLocation(request.getKosmoSUser(), o, this.getSource(request)).toJSON());
    }
}

