/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.exceptions.NoAccessException;
import de.kosmos_lab.platform.exceptions.NoAccessToGroup;
import de.kosmos_lab.platform.exceptions.NoAccessToScope;
import de.kosmos_lab.platform.exceptions.NotFoundException;
import de.kosmos_lab.platform.exceptions.NotObjectSchemaException;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.web.exceptions.AlreadyExistsException;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.persistence.exceptions.NotFoundInPersistenceException;
import de.kosmos_lab.web.server.WebServer;
import de.kosmos_lab.web.server.servlets.BaseServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.everit.json.schema.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KosmoSServlet
extends BaseServlet {
    protected static final Logger logger = LoggerFactory.getLogger((String)"KosmoSServlet");
    protected final IController controller;
    protected final KosmoSWebServer server;
    final ALLOW_AUTH allow_auth;

    public KosmoSServlet(KosmoSWebServer server, IController controller) {
        this(server, controller, ALLOW_AUTH.PARAMETER_AND_HEADER);
    }

    public KosmoSServlet(KosmoSWebServer server, IController controller, ALLOW_AUTH allow_auth) {
        super((WebServer)server);
        this.server = server;
        this.controller = controller;
        this.allow_auth = allow_auth;
    }

    public void delete(KosmoSHttpServletRequest request, HttpServletResponse response) throws UnauthorizedException, ServletException, IOException, NotObjectSchemaException, ParameterNotFoundException, NotFoundException, ValidationException, NoAccessException {
        response.setStatus(405);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (this.isAllowed(request, response)) {
                this.addCORSHeader(request, response);
                this.delete(new KosmoSHttpServletRequest(request), response);
            }
        }
        catch (Exception e) {
            this.handleException(request, response, e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (this.isAllowed(request, response)) {
                this.addCORSHeader(request, response);
                this.get(new KosmoSHttpServletRequest(request), response);
            }
        }
        catch (Exception e) {
            this.handleException(request, response, e);
        }
    }

    public void doOptions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.addCORSHeader(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (this.isAllowed(request, response)) {
                this.addCORSHeader(request, response);
                this.post(new KosmoSHttpServletRequest(request), response);
            }
        }
        catch (Exception e) {
            this.handleException(request, response, e);
        }
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {
        super.doPut(request, response);
        try {
            if (this.isAllowed(request, response)) {
                this.addCORSHeader(request, response);
                this.put(new KosmoSHttpServletRequest(request), response);
            }
        }
        catch (Exception e) {
            this.handleException(request, response, e);
        }
    }

    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws UnauthorizedException, ServletException, IOException, NotObjectSchemaException, ParameterNotFoundException, NotFoundException, ValidationException, NoAccessException, NotFoundInPersistenceException {
        response.setStatus(405);
    }

    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws UnauthorizedException, ServletException, IOException, NotObjectSchemaException, ParameterNotFoundException, NotFoundException, ValidationException, NotFoundInPersistenceException, AlreadyExistsException, NoAccessException {
        response.setStatus(405);
    }

    public void put(KosmoSHttpServletRequest request, HttpServletResponse response) throws UnauthorizedException, ServletException, IOException, NotObjectSchemaException, ParameterNotFoundException, NotFoundException, ValidationException, NoAccessToScope, NoAccessToGroup {
        response.setStatus(405);
    }

    public static enum ALLOW_AUTH {
        HEADER_ONLY,
        PARAMETER_AND_HEADER;

    }
}

