/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.web.IAuthProvider;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.exceptions.LoginFailedException;
import java.util.Hashtable;
import javax.annotation.Nonnull;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthLDAP
implements IAuthProvider {
    public static final Logger logger = LoggerFactory.getLogger((String)"AuthLDAP");
    private final IController controller;

    public AuthLDAP(IController controller) {
        this.controller = controller;
    }

    public static IAuthProvider getInstance(IController controller) {
        JSONObject ldap = controller.getConfig().optJSONObject("ldap");
        if (ldap != null) {
            return new AuthLDAP(controller);
        }
        throw new IllegalArgumentException("did not contain ldap configuration");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IUser tryLogin(@Nonnull String user, @Nonnull String password) throws LoginFailedException {
        logger.info("trying to login as {} with ldap", (Object)user);
        JSONObject ldap = this.controller.getConfig().optJSONObject("ldap");
        if (ldap == null) {
            logger.error("did not find ldap config");
            throw new IllegalArgumentException("did not contain ldap configuration");
        }
        try {
            Hashtable<String, String> environment = new Hashtable<String, String>();
            environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            environment.put("java.naming.provider.url", ldap.getString("server"));
            environment.put("java.naming.security.authentication", "simple");
            environment.put("java.naming.security.principal", String.format("uid=%s,%s", user, ldap.getString("userdn")));
            environment.put("java.naming.security.credentials", password);
            InitialDirContext context = new InitialDirContext(environment);
            NamingEnumeration<? extends Attribute> a = context.getAttributes(String.format("uid=%s,%s", user, ldap.getString("userdn"))).getAll();
            while (true) {
                if (!a.hasMore()) {
                    context.close();
                    return this.controller.getUserCreateIfUnavailable(String.format("ldap:%s", user));
                }
                Attribute atr = a.next();
                logger.info("attribute {}", (Object)atr);
            }
        }
        catch (Exception e) {
            try {
                logger.error("error while logging in via LDAP!", (Throwable)e);
                throw new LoginFailedException(e.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

