/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.web.IAuthProvider;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.exceptions.LoginFailedException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthKeyCloak
implements IAuthProvider {
    public static final Logger logger = LoggerFactory.getLogger((String)"AuthKeyCloak");
    private final IController controller;

    public AuthKeyCloak(IController controller) {
        this.controller = controller;
    }

    public static IAuthProvider getInstance(IController controller) {
        JSONObject keycloak = controller.getConfig().optJSONObject("keycloak");
        if (keycloak != null) {
            return new AuthKeyCloak(controller);
        }
        throw new IllegalArgumentException("did not contain keycloak configuration");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IUser tryLogin(@Nonnull String user, @Nonnull String password) throws LoginFailedException {
        InputStream instream;
        block12: {
            logger.info("trying to login as {} with keycloak", (Object)user);
            JSONObject keycloak = this.controller.getConfig().optJSONObject("keycloak");
            if (keycloak == null) throw new IllegalArgumentException("did not contain keycloak configuration");
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httppost = new HttpPost(String.format("%s/realms/%s/protocol/openid-connect/token", keycloak.getString("server"), keycloak.getString("realm")));
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(5);
            params.add(new BasicNameValuePair("client_id", keycloak.getString("clientId")));
            params.add(new BasicNameValuePair("client_secret", keycloak.getString("clientSecret")));
            params.add(new BasicNameValuePair("username", user));
            params.add(new BasicNameValuePair("password", password));
            params.add(new BasicNameValuePair("grant_type", "password"));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (entity == null) return null;
            instream = entity.getContent();
            String s = new String(instream.readAllBytes());
            JSONObject json = new JSONObject(s);
            String at = json.optString("access_token", null);
            if (json.has("error") && json.has("error_description")) {
                throw new LoginFailedException(json.getString("error_description"));
            }
            if (at == null || json.has("error")) break block12;
            IUser iUser = this.controller.getUserCreateIfUnavailable(String.format("keycloak:%s", user));
            if (instream == null) return iUser;
            instream.close();
            return iUser;
        }
        try {
            try {
                if (instream == null) return null;
                instream.close();
                return null;
                {
                    catch (Throwable throwable) {
                        if (instream == null) throw throwable;
                        try {
                            instream.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (LoginFailedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        catch (LoginFailedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

