/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.rules;

import de.kosmos_lab.platform.rules.RulesService;
import de.kosmos_lab.web.data.IUser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesExecuter
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)"RulesExecuter");
    private final IUser user;
    private final RulesService service;
    String pythonCmd = "python";
    private Process pr;
    private boolean stopped = false;

    public RulesExecuter(RulesService service, IUser user) {
        this.service = service;
        this.user = user;
        this.pr = null;
    }

    public void exit() {
        this.stopped = true;
        if (this.pr != null) {
            this.pr.destroy();
        }
    }

    public void restart() {
        if (this.pr != null) {
            this.pr.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Process pr2 = Runtime.getRuntime().exec("python3 --version");
            if (pr2.waitFor() == 0) {
                this.pythonCmd = "python3";
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("could not execute python3 checker", (Throwable)e);
        }
        while (!this.stopped) {
            BufferedReader in = null;
            try {
                String line;
                Object cmd = "";
                File dir = new File("rules/");
                logger.info("working dir: {}", (Object)System.getProperty("user.dir"));
                cmd = this.pythonCmd + " rules/" + this.user.getUUID().getLeastSignificantBits() + ".py";
                logger.info("executing: {}", cmd);
                this.pr = Runtime.getRuntime().exec((String)cmd, null, dir);
                in = new BufferedReader(new InputStreamReader(this.pr.getErrorStream(), StandardCharsets.UTF_8));
                while ((line = in.readLine()) != null) {
                    logger.warn("User({}), stderr:{}", (Object)this.user.getUUID().getLeastSignificantBits(), (Object)line);
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                in = new BufferedReader(new InputStreamReader(this.pr.getInputStream(), StandardCharsets.UTF_8));
                while ((line = in.readLine()) != null) {
                    logger.warn("User({}), stdout:{}", (Object)this.user.getUUID().getLeastSignificantBits(), (Object)line);
                }
                try {
                    this.pr.waitFor();
                }
                catch (InterruptedException e) {
                    logger.error("could not wait for python", (Throwable)e);
                }
                in.close();
            }
            catch (IOException e) {
                logger.error("could not wait execute python", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error("could not sleep?", (Throwable)e);
            }
        }
    }
}

