/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.ros2;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.exceptions.DeviceNotFoundException;
import de.kosmos_lab.platform.exceptions.NoAccessToScope;
import de.kosmos_lab.platform.smarthome.CommandInterface;
import de.kosmos_lab.platform.smarthome.CommandSourceName;
import de.kosmos_lab.platform.utils.KosmoSHelper;
import de.kosmos_lab.utils.JSONPatch;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.SystemUtils;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.everit.json.schema.ValidationException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import std_msgs.msg.dds.Bool;
import std_msgs.msg.dds.BoolPubSubType;
import std_msgs.msg.dds.Float32;
import std_msgs.msg.dds.Float32PubSubType;
import std_msgs.msg.dds.Float64;
import std_msgs.msg.dds.Float64PubSubType;
import std_msgs.msg.dds.Int32;
import std_msgs.msg.dds.Int32PubSubType;
import std_msgs.msg.dds.Int64;
import std_msgs.msg.dds.Int64PubSubType;
import std_msgs.msg.dds.StringPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Subscription;
import us.ihmc.util.PeriodicNonRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicRealtimeThreadSchedulerFactory;

public class ROS2Controller
implements CommandInterface {
    protected static final Logger logger = LoggerFactory.getLogger((String)"Ros2Controller");
    private final IController controller;
    private final String pre;
    private final ROS2Controller me;
    private final ConcurrentHashMap<String, ROS2Publisher> publishers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ROS2Subscription> subscriptions = new ConcurrentHashMap();
    ROS2Node node = null;

    public ROS2Controller(IController controller) {
        this.me = this;
        this.pre = "kosmos";
        this.controller = controller;
        logger.info("booting ROS2Controller");
        if (KosmoSHelper.getEnvBool("USE_ROS2") || controller.getConfig().has("ros2")) {
            PeriodicRealtimeThreadSchedulerFactory threadFactory = SystemUtils.IS_OS_LINUX ? new PeriodicRealtimeThreadSchedulerFactory(20) : new PeriodicNonRealtimeThreadSchedulerFactory();
            try {
                this.node = new ROS2Node(DomainFactory.PubSubImplementation.FAST_RTPS, "KosmoS_Platform");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public TopicDataType<? extends Packet<? extends Packet<?>>> getType(Schema schema) {
        if (!(schema instanceof ObjectSchema)) {
            if (schema instanceof NumberSchema) {
                if (((NumberSchema)schema).requiresInteger()) {
                    return new Int32PubSubType();
                }
                if (((NumberSchema)schema).requiresInteger()) {
                    return new Float64PubSubType();
                }
            }
            if (schema instanceof BooleanSchema) {
                return new BoolPubSubType();
            }
            if (schema instanceof StringSchema) {
                return new StringPubSubType();
            }
        }
        return null;
    }

    private void sendState(Device device, String uuid, JSONObject json, ObjectSchema schema, String pre_state) {
        logger.info("sendState {} {}", (Object)uuid, (Object)json);
        if (json == null) {
            return;
        }
        if (pre_state.startsWith("/")) {
            pre_state = pre_state.substring(1);
        }
        for (final Map.Entry entry : schema.getPropertySchemas().entrySet()) {
            ROS2Subscription subscriber;
            Schema prop_schema = (Schema)entry.getValue();
            String topic = String.format("/%s/%s/%s%s", this.pre, uuid.replace(".", "_").replace("-", "_"), pre_state, entry.getKey());
            ROS2Publisher publisher = this.publishers.get(topic);
            if (prop_schema instanceof ReferenceSchema) {
                prop_schema = ((ReferenceSchema)prop_schema).getReferredSchema();
            }
            TopicDataType<? extends Packet<? extends Packet<?>>> type = this.getType(prop_schema);
            if (publisher == null) {
                if (prop_schema instanceof ObjectSchema) {
                    String t = String.format("%s/%s/", pre_state, entry.getKey());
                    this.sendState(device, uuid, json.optJSONObject((String)entry.getKey()), (ObjectSchema)prop_schema, t);
                } else if (type != null) {
                    try {
                        publisher = this.node.createPublisher(type, topic);
                        this.publishers.put(topic, publisher);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (publisher == null) continue;
            try {
                Object v = json.opt((String)entry.getKey());
                if (v != null) {
                    Int64 i;
                    if (type instanceof Int64PubSubType) {
                        if (v instanceof Long || v instanceof Integer) {
                            i = new Int64();
                            i.setData(((Long)v).longValue());
                            v = i;
                        }
                    } else if (type instanceof Int32PubSubType) {
                        if (v instanceof Long || v instanceof Integer) {
                            i = new Int32();
                            i.setData(((Integer)v).intValue());
                            v = i;
                        }
                    } else if (type instanceof Float32PubSubType) {
                        if (v instanceof Double || v instanceof Float || v instanceof Long || v instanceof Integer) {
                            i = new Float32();
                            i.setData(((Float)v).floatValue());
                            v = i;
                        }
                    } else if (type instanceof Float64PubSubType) {
                        if (v instanceof Double || v instanceof Float || v instanceof Integer || v instanceof Long) {
                            i = new Float64();
                            i.setData(((Double)v).doubleValue());
                            v = i;
                        }
                    } else if (type instanceof BoolPubSubType) {
                        if (v instanceof Boolean) {
                            if (((Boolean)v).booleanValue()) {
                                v = new Bool();
                                ((Bool)v).setData(true);
                            } else {
                                v = new Bool();
                                ((Bool)v).setData(false);
                            }
                        }
                    } else if (type instanceof StringPubSubType) {
                        std_msgs.msg.dds.String t = new std_msgs.msg.dds.String();
                        t.setData(v.toString());
                        v = t;
                    }
                    logger.info("publishing to {} : {}", (Object)topic, v);
                    publisher.publish(v);
                }
            }
            catch (Exception e) {
                logger.error("Exception ", (Throwable)e);
            }
            if (schema.isReadOnly() != null && schema.isReadOnly().booleanValue() || type == null || (subscriber = this.subscriptions.get(topic)) != null) continue;
            try {
                logger.info("creating topic {} pre_state {}", (Object)topic, (Object)pre_state);
                subscriber = this.node.createSubscription(type, (NewMessageListener)new KosmosNewMessageListener<Object>(device, pre_state){

                    public void onNewDataMessage(Subscriber<Object> subscriber) {
                        Object data = subscriber.readNextData();
                        logger.info("pre_State was: {}", (Object)this.pre_state);
                        if (data instanceof Int32) {
                            data = ((Int32)data).data_;
                        } else if (data instanceof Int64) {
                            data = ((Int64)data).data_;
                        } else if (data instanceof Float64) {
                            data = ((Float64)data).data_;
                        } else if (data instanceof Float32) {
                            data = Float.valueOf(((Float32)data).data_);
                        } else if (data instanceof Bool) {
                            data = ((Bool)data).data_;
                        } else if (data instanceof std_msgs.msg.dds.String) {
                            data = ((std_msgs.msg.dds.String)data).data_.toString();
                        }
                        if (this.pre_state.length() > 0) {
                            JSONObject patch = new JSONObject();
                            String path = String.format("%s%s", this.pre_state, entry.getKey());
                            logger.info("path {}", (Object)path);
                            patch.put("op", (Object)"add").put("path", (Object)path).put("value", data);
                            JSONObject j = JSONPatch.apply((JSONObject)new JSONObject(), (JSONArray)new JSONArray().put((Object)patch));
                            logger.info("new JSON: {}", (Object)j);
                            try {
                                ROS2Controller.this.controller.parseSet((CommandInterface)ROS2Controller.this.me, this.device, j, ROS2Controller.this.controller.getSource(this.getClass().getName()), null);
                            }
                            catch (DeviceNotFoundException e) {
                                throw new RuntimeException((Throwable)((Object)e));
                            }
                            catch (NoAccessToScope e) {
                                throw new RuntimeException((Throwable)((Object)e));
                            }
                            catch (ValidationException e) {
                                j = JSONPatch.apply((JSONObject)this.device, (JSONArray)new JSONArray().put((Object)patch));
                                try {
                                    ROS2Controller.this.controller.parseSet((CommandInterface)ROS2Controller.this.me, this.device, j, ROS2Controller.this.controller.getSource(this.getClass().getName()), null);
                                }
                                catch (DeviceNotFoundException e2) {
                                    throw new RuntimeException((Throwable)((Object)e2));
                                }
                                catch (NoAccessToScope e2) {
                                    throw new RuntimeException((Throwable)((Object)e2));
                                }
                            }
                        } else {
                            JSONObject j = new JSONObject();
                            j.put((String)entry.getKey(), data);
                            try {
                                ROS2Controller.this.controller.parseSet((CommandInterface)ROS2Controller.this.me, this.device, j, ROS2Controller.this.controller.getSource(this.getClass().getName()), null);
                            }
                            catch (DeviceNotFoundException e) {
                                throw new RuntimeException((Throwable)((Object)e));
                            }
                            catch (NoAccessToScope e) {
                                throw new RuntimeException((Throwable)((Object)e));
                            }
                            catch (ValidationException e) {
                                j = new JSONObject(this.device.toMap());
                                j.put((String)entry.getKey(), data);
                                try {
                                    ROS2Controller.this.controller.parseSet((CommandInterface)ROS2Controller.this.me, this.device, j, ROS2Controller.this.controller.getSource(this.getClass().getName()), null);
                                }
                                catch (DeviceNotFoundException ex) {
                                    throw new RuntimeException((Throwable)((Object)ex));
                                }
                                catch (NoAccessToScope ex) {
                                    throw new RuntimeException((Throwable)((Object)ex));
                                }
                            }
                        }
                    }
                }, topic);
                this.subscriptions.put(topic, subscriber);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void deviceAdded(@Nullable CommandInterface from, @Nonnull Device device, @Nonnull CommandSourceName source) {
        if (this.node != null) {
            this.sendState(device, device.getUniqueID(), device, device.getSchema(), "");
        }
    }

    @Override
    public void deviceRemoved(@Nullable CommandInterface from, @Nonnull Device device, @Nonnull CommandSourceName source) {
    }

    @Override
    public void deviceUpdate(@Nullable CommandInterface from, @Nonnull Device device, @Nullable String key, @Nonnull CommandSourceName source) {
        if (this.node != null) {
            if (key == null) {
                this.sendState(device, device.getUniqueID(), device, device.getSchema(), "");
            } else {
                JSONObject json = new JSONObject();
                json.put(key, device.get(key));
                this.sendState(device, device.getUniqueID(), json, device.getSchema(), "");
            }
        }
    }

    @Override
    public void stop() {
        if (this.node != null) {
            this.node.destroy();
        }
    }

    @Override
    public String getSourceName() {
        return "ROS2";
    }

    public abstract class KosmosNewMessageListener<T>
    implements NewMessageListener<T> {
        public final Device device;
        public final String pre_state;

        KosmosNewMessageListener(Device device, String pre_state) {
            this.device = device;
            this.pre_state = pre_state;
        }
    }
}

