/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.persistence;

import de.kosmos_lab.platform.data.DataSchema;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.data.DeviceText;
import de.kosmos_lab.platform.data.Group;
import de.kosmos_lab.platform.data.KosmoSUser;
import de.kosmos_lab.platform.data.LogEntry;
import de.kosmos_lab.platform.data.Scope;
import de.kosmos_lab.platform.exceptions.GroupAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.ScopeAlreadyExistsException;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.persistence.exceptions.NotFoundInPersistenceException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.json.JSONObject;

public interface IPersistence {
    public void addDevice(@Nonnull Device var1);

    @Nonnull
    public Group addGroup(@Nonnull String var1, @Nonnull IUser var2) throws GroupAlreadyExistsException;

    public void addGroupAdmin(@Nonnull Group var1, @Nonnull IUser var2);

    public void addGroupUser(@Nonnull Group var1, @Nonnull IUser var2);

    public void addSchema(@Nonnull DataSchema var1);

    @Nonnull
    public Scope addScope(@Nonnull String var1, @Nonnull IUser var2) throws ScopeAlreadyExistsException;

    public void addScopeAdmin(@Nonnull Scope var1, @Nonnull IUser var2);

    public void addScopeGroup(@Nonnull Scope var1, @Nonnull Group var2);

    public void addScopeAdminGroup(@Nonnull Scope var1, @Nonnull Group var2);

    public void addScopeUser(@Nonnull Scope var1, @Nonnull IUser var2);

    public void addUser(@Nonnull IUser var1);

    public void delDevice(@Nonnull Device var1);

    public void delGroup(@Nonnull Group var1);

    public void delGroupAdmin(@Nonnull Group var1, @Nonnull IUser var2);

    public void delGroupUser(@Nonnull Group var1, @Nonnull IUser var2);

    public void delSchema(@Nonnull DataSchema var1);

    public void delScope(@Nonnull Scope var1);

    public void delScopeAdmin(@Nonnull Scope var1, @Nonnull IUser var2);

    public void delScopeUser(@Nonnull Scope var1, @Nonnull IUser var2);

    public void delUser(@Nonnull IUser var1);

    public void fillDeviceScopes(@Nonnull Device var1);

    public void fillGroup(@Nonnull Group var1);

    public void fillScope(@Nonnull Scope var1);

    @Nonnull
    public Group getGroup(@Nonnull String var1) throws NotFoundInPersistenceException;

    @Nonnull
    public Group getGroup(int var1) throws NotFoundInPersistenceException;

    @Nonnull
    public JSONObject getLastState(@Nonnull String var1);

    public int getNumberOfDevicesWithSchema(@Nonnull DataSchema var1);

    @Nonnull
    public DataSchema getSchema(@Nonnull String var1) throws NotFoundInPersistenceException;

    @Nonnull
    public Scope getScope(int var1) throws NotFoundInPersistenceException;

    @Nonnull
    public Scope getScope(@Nonnull String var1) throws NotFoundInPersistenceException;

    @Nonnull
    public List<LogEntry> getStates(long var1, long var3, @Nonnull String[] var5);

    @Nonnull
    public List<LogEntry> getStates(long var1, long var3, @Nonnull Set<String> var5);

    @Nonnull
    public IUser getUser(int var1) throws NotFoundInPersistenceException;

    @Nonnull
    public IUser getUser(@Nonnull String var1) throws NotFoundInPersistenceException;

    public void init();

    @Nonnull
    public Collection<Device> initDevices();

    @Nonnull
    public Collection<Group> initGroups();

    @Nonnull
    public Collection<DataSchema> initSchema();

    @Nonnull
    public Collection<Scope> initScopes();

    @Nonnull
    public List<KosmoSUser> initUsers();

    public void setDelScope(@Nonnull Device var1, @Nonnull Scope var2);

    public void setName(@Nonnull Device var1, @Nonnull String var2);

    public void setPassword(@Nonnull IUser var1, @Nonnull String var2, @Nonnull String var3);

    public void setReadScope(@Nonnull Device var1, @Nonnull Scope var2);

    public void setWriteScope(@Nonnull Device var1, @Nonnull Scope var2);

    public void updateLastUpdate(@Nonnull Device var1);

    public void updateLocation(@Nonnull Device var1);

    public void fillTexts(Device var1);

    public void addDeviceText(DeviceText var1);

    public void updateDeviceText(DeviceText var1);
}

