/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.gesture;

import de.kosmos_lab.platform.gesture.data.Gesture;
import de.kosmos_lab.platform.gesture.data.Point;
import de.kosmos_lab.platform.gesture.utils.Geometry;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class QPointCloudRecognizer {
    public static final boolean useEarlyAbandoning = true;
    public static final boolean useLowerBounding = true;

    @CheckForNull
    static Gesture Classify(@Nonnull Gesture candidate, @Nonnull Collection<Gesture> templateSet) {
        float minDistance = Float.MAX_VALUE;
        Gesture gestureClass = null;
        for (Gesture template : templateSet) {
            float dist = QPointCloudRecognizer.GreedyCloudMatch(candidate, template, minDistance);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            gestureClass = template;
        }
        return gestureClass;
    }

    private static float CloudDistance(@Nonnull Point[] points1, @Nonnull Point[] points2, int startIndex, float minSoFar) {
        int n = points1.length;
        int[] indexesNotMatched = new int[n];
        for (int j = 0; j < n; ++j) {
            indexesNotMatched[j] = j;
        }
        float sum = 0.0f;
        int i = startIndex;
        int weight = n;
        int indexNotMatched = 0;
        do {
            int index = -1;
            float minDistance = Float.MAX_VALUE;
            for (int j = indexNotMatched; j < n; ++j) {
                float dist = Geometry.sqrEuclideanDistance(points1[i], points2[indexesNotMatched[j]]);
                if (!(dist < minDistance)) continue;
                minDistance = dist;
                index = j;
            }
            indexesNotMatched[index] = indexesNotMatched[indexNotMatched];
            int n2 = weight--;
            if ((sum += (float)n2 * minDistance) >= minSoFar) {
                return sum;
            }
            i = (i + 1) % n;
            ++indexNotMatched;
        } while (i != startIndex);
        return sum;
    }

    private static float[] ComputeLowerBound(@Nonnull Point[] points1, @Nonnull Point[] points2, int[][] LUT, int step) {
        int i;
        int n = points1.length;
        float[] LB = new float[n / step + 1];
        float[] SAT = new float[n];
        LB[0] = 0.0f;
        for (i = 0; i < n; ++i) {
            int index = LUT[points1[i].lookupY / 16][points1[i].lookupX / 16];
            float dist = Geometry.sqrEuclideanDistance(points1[i], points2[index]);
            SAT[i] = i == 0 ? dist : SAT[i - 1] + dist;
            LB[0] = LB[0] + (float)(n - i) * dist;
        }
        i = step;
        int indexLB = 1;
        while (i < n) {
            LB[indexLB] = LB[0] + (float)i * SAT[n - 1] - (float)n * SAT[i - 1];
            i += step;
            ++indexLB;
        }
        return LB;
    }

    private static float GreedyCloudMatch(@Nonnull Gesture gesture1, @Nonnull Gesture gesture2, float minSoFar) {
        int n = gesture1.points.length;
        float eps = 0.5f;
        int step = (int)Math.floor(Math.pow(n, 1.0f - eps));
        float[] LB1 = QPointCloudRecognizer.ComputeLowerBound(gesture1.points, gesture2.points, gesture2.lookupTable, step);
        float[] LB2 = QPointCloudRecognizer.ComputeLowerBound(gesture2.points, gesture1.points, gesture1.lookupTable, step);
        int i = 0;
        int indexLB = 0;
        while (i < n) {
            if (LB1[indexLB] < minSoFar) {
                minSoFar = Math.min(minSoFar, QPointCloudRecognizer.CloudDistance(gesture1.points, gesture2.points, i, minSoFar));
            }
            if (LB2[indexLB] < minSoFar) {
                minSoFar = Math.min(minSoFar, QPointCloudRecognizer.CloudDistance(gesture2.points, gesture1.points, i, minSoFar));
            }
            i += step;
            ++indexLB;
        }
        return minSoFar;
    }
}

