/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.KosmosPluginManager;
import de.kosmos_lab.platform.camera.subtitles.data.SubtitleEntry;
import de.kosmos_lab.platform.client.HTTPClient;
import de.kosmos_lab.platform.data.Config;
import de.kosmos_lab.platform.data.DataSchema;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.data.DeviceText;
import de.kosmos_lab.platform.data.Event;
import de.kosmos_lab.platform.data.Group;
import de.kosmos_lab.platform.data.KosmoSUser;
import de.kosmos_lab.platform.data.LogEntry;
import de.kosmos_lab.platform.data.LoggingRequest;
import de.kosmos_lab.platform.data.Scope;
import de.kosmos_lab.platform.data.StateUpdates;
import de.kosmos_lab.platform.exceptions.CameraNotFoundException;
import de.kosmos_lab.platform.exceptions.DeviceAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.DeviceNotFoundException;
import de.kosmos_lab.platform.exceptions.GroupAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.GroupNotFoundException;
import de.kosmos_lab.platform.exceptions.NoAccessException;
import de.kosmos_lab.platform.exceptions.NoAccessToRecording;
import de.kosmos_lab.platform.exceptions.NoAccessToScope;
import de.kosmos_lab.platform.exceptions.NotObjectSchemaException;
import de.kosmos_lab.platform.exceptions.SchemaNotFoundException;
import de.kosmos_lab.platform.exceptions.ScopeAlreadyExistsException;
import de.kosmos_lab.platform.exceptions.UserNotFoundException;
import de.kosmos_lab.platform.gesture.GestureProvider;
import de.kosmos_lab.platform.mqtt.MQTTBroker;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.platform.persistence.IPersistence;
import de.kosmos_lab.platform.persistence.KosmoSPersistence;
import de.kosmos_lab.platform.plugins.camera.ICamera;
import de.kosmos_lab.platform.ros2.ROS2Controller;
import de.kosmos_lab.platform.rules.RulesService;
import de.kosmos_lab.platform.smarthome.CommandInterface;
import de.kosmos_lab.platform.smarthome.CommandSourceName;
import de.kosmos_lab.platform.smarthome.EventInterface;
import de.kosmos_lab.platform.smarthome.SmartHomeInterface;
import de.kosmos_lab.platform.smarthome.ha.HomeAssistantHTTPClient;
import de.kosmos_lab.platform.utils.DataFactory;
import de.kosmos_lab.platform.utils.KosmoSHelper;
import de.kosmos_lab.platform.utils.SchemaComparator;
import de.kosmos_lab.platform.utils.TimeFunctions;
import de.kosmos_lab.platform.web.IAuthProvider;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.KosmoSWebSocketService;
import de.kosmos_lab.utils.HashFunctions;
import de.kosmos_lab.utils.JSONFunctions;
import de.kosmos_lab.utils.KosmosFileUtils;
import de.kosmos_lab.utils.StringFunctions;
import de.kosmos_lab.utils.Wildcard;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.exceptions.LoginFailedException;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.persistence.exceptions.NotFoundInPersistenceException;
import de.kosmos_lab.web.server.JWT;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.http.HttpMethod;
import org.everit.json.schema.ValidationException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DM_EXIT"})
public class KosmoSController
implements IController {
    protected static final Logger logger = LoggerFactory.getLogger((String)"KosmoSController");
    private static final Pattern extraneousKeyPattern = Pattern.compile("extraneous key \\[(?<keys>.*)\\] is not permitted");
    private static final long subDefaultTime = 10000L;
    private final JWT jwt;
    private final KosmosPluginManager pluginManager;
    private final Constants.RunMode runMode;
    private final KosmoSPersistence persistence;
    private final ConcurrentHashMap<Device, Boolean> logByDevice;
    private final HashSet<String> logWhiteListFilter;
    private final HashSet<String> logBlackListFilter;
    private ROS2Controller ros2controller;
    public ConcurrentHashMap<String, CommandSourceName> cacheSource;
    public DataSchema fallbackSchema;
    public ConcurrentHashMap<String, ICamera> cameras;
    public ConcurrentHashMap<ICamera, IUser> recordings;
    protected Config config;
    protected KosmoSWebServer webServer;
    protected RulesService rulesService;
    Set<SmartHomeInterface> smartEnvironments;
    ConcurrentHashMap<String, Scope> scopes;
    ConcurrentHashMap<Integer, Scope> scopesI;
    ConcurrentHashMap<String, Group> groups;
    ConcurrentHashMap<Integer, Group> groupsI;
    ConcurrentHashMap<String, DataSchema> schemas;
    ConcurrentHashMap<String, IUser> users;
    ConcurrentHashMap<UUID, IUser> usersI;
    ConcurrentHashMap<Integer, IUser> usersID;
    ConcurrentHashMap<String, Device> devices;
    Set<CommandInterface> commandInterfaces;
    Set<EventInterface> eventInterfaces;
    Set<IAuthProvider> authProviders;
    GestureProvider gestureProvider;
    ScheduledExecutorService scheduledExecutorService;
    private MQTTBroker mqttBroker;
    private boolean stopped;

    public KosmoSController() {
        this(new File("config/config.json"));
    }

    public KosmoSController(File configFile) {
        this(configFile, Constants.RunMode.NORMAL);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public KosmoSController(@Nonnull File configFile, Constants.RunMode runMode) {
        block118: {
            this.logByDevice = new ConcurrentHashMap();
            this.logWhiteListFilter = new HashSet();
            this.logBlackListFilter = new HashSet();
            this.cacheSource = new ConcurrentHashMap();
            this.fallbackSchema = null;
            this.cameras = new ConcurrentHashMap();
            this.recordings = new ConcurrentHashMap();
            this.smartEnvironments = ConcurrentHashMap.newKeySet();
            this.scopes = new ConcurrentHashMap();
            this.scopesI = new ConcurrentHashMap();
            this.groups = new ConcurrentHashMap();
            this.groupsI = new ConcurrentHashMap();
            this.schemas = new ConcurrentHashMap();
            this.users = new ConcurrentHashMap();
            this.usersI = new ConcurrentHashMap();
            this.usersID = new ConcurrentHashMap();
            this.devices = new ConcurrentHashMap();
            this.commandInterfaces = ConcurrentHashMap.newKeySet();
            this.eventInterfaces = ConcurrentHashMap.newKeySet();
            this.authProviders = ConcurrentHashMap.newKeySet();
            this.scheduledExecutorService = Executors.newScheduledThreadPool(5);
            this.stopped = false;
            logger.info("Starting KosmoSController with config {} in runMode {}", (Object)configFile, (Object)runMode);
            this.runMode = runMode;
            try {
                this.config = new Config(configFile);
            }
            catch (FileNotFoundException e) {
                this.config = new Config();
                this.config.setFile(configFile);
            }
            catch (IOException e) {
                logger.error("Exception while reading config file: ", (Throwable)e);
                System.exit(1);
            }
            this.config.save();
            this.jwt = new JWT(this.config.getString("jwt"));
            this.persistence = new KosmoSPersistence(this.config.getJSONObject("sql"), this, false);
            JSONObject logging = this.config.optJSONObject("logging");
            if (logging != null) {
                int i;
                JSONArray list = logging.optJSONArray("blacklist");
                if (list != null) {
                    for (i = 0; i < list.length(); ++i) {
                        try {
                            this.logBlackListFilter.add(list.getString(i));
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if ((list = logging.optJSONArray("whitelist")) != null) {
                    for (i = 0; i < list.length(); ++i) {
                        try {
                            this.logWhiteListFilter.add(list.getString(i));
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            this.persistence.init();
            if (runMode == Constants.RunMode.TEST) {
                String ruleDir = this.getFileString("rules");
                for (String f : new String[]{"kosmos.py"}) {
                    try {
                        File file = new File(String.format("rules/%s", f));
                        if (!file.exists()) continue;
                        FileUtils.copyFile((File)file, (File)new File(String.format("%s/%s", ruleDir, f)));
                    }
                    catch (IOException file) {
                        // empty catch block
                    }
                }
            }
            this.gestureProvider = new GestureProvider(true, this.getFileString("gestures"));
            this.rulesService = new RulesService(this, this.getFileString("rules"));
            if (runMode == Constants.RunMode.NORMAL) {
                Object schema2;
                File[] fileList;
                Object schemaDir;
                int i;
                if (KosmoSHelper.getEnvBool("USE_ROS2") || this.config.has("ros2")) {
                    // empty if block
                }
                if (this.users.isEmpty()) {
                    File f;
                    String USERS = KosmoSHelper.getEnv("USERS");
                    if (USERS != null) {
                        try {
                            JSONArray arr = new JSONArray(USERS);
                            for (int i2 = 0; i2 < arr.length(); ++i2) {
                                JSONObject obj = arr.getJSONObject(i2);
                                this.addUser(obj.getString("username"), obj.getString("password"), obj.optInt("level", 1));
                            }
                        }
                        catch (JSONException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if ((f = this.getFile("config/users.json")).exists()) {
                        JSONArray arr = new JSONArray(KosmosFileUtils.readFile((File)f));
                        for (i = 0; i < arr.length(); ++i) {
                            try {
                                JSONObject obj = arr.getJSONObject(i);
                                this.addUser(obj.getString("username"), obj.getString("password"), obj.optInt("level", 1));
                                continue;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    if (this.users.isEmpty()) {
                        this.addUser("admin", "pass", 100);
                        this.addUser("user", "pass", 1);
                        this.addUser("user2", "pass", 1);
                        this.addUser("context", "pass", 1);
                    }
                }
                if (((File)(schemaDir = new File("schema"))).exists() && (fileList = ((File)schemaDir).listFiles()) != null) {
                    File[] arr = fileList;
                    i = arr.length;
                    for (int ex = 0; ex < i; ++ex) {
                        File schemaFile = arr[ex];
                        if (!schemaFile.getName().endsWith(".json")) continue;
                        try {
                            schema2 = DataFactory.getSchema(schemaFile);
                            if (schema2 == null || ((DataSchema)schema2).getSchema() == null) continue;
                            try {
                                this.getPersistence().getSchema(((DataSchema)schema2).getSchema().getId());
                            }
                            catch (NotFoundInPersistenceException ex2) {
                                this.getPersistence().addSchema((DataSchema)schema2);
                            }
                            continue;
                        }
                        catch (NotObjectSchemaException schema2) {
                            // empty catch block
                        }
                    }
                }
                try {
                    File dfile = this.getFile("config/devices.json");
                    if (dfile.exists()) {
                        JSONArray devices = new JSONArray(KosmosFileUtils.readFile((File)dfile));
                        for (i = 0; i < devices.length(); ++i) {
                            JSONObject o = devices.getJSONObject(i);
                            try {
                                this.parseAddDevice(this.persistence, o, this.getSource("HTTPApi:user"), this.getUser("user"), false);
                                continue;
                            }
                            catch (DeviceAlreadyExistsException e) {
                                JSONObject state = o.getJSONObject("state");
                                if (state == null || state.keySet().size() <= 0) continue;
                                try {
                                    this.parseSet((CommandInterface)this.persistence, o.getString("uuid"), state, this.getSource("HTTPApi:user"), this.getUser("user"));
                                    continue;
                                }
                                catch (NoAccessToScope noAccessToScope) {
                                    noAccessToScope.printStackTrace();
                                }
                            }
                        }
                        break block118;
                    }
                    String CREATE_ALL_DEVICE = KosmoSHelper.getEnv("CREATE_ALL_DEVICE");
                    if (KosmoSHelper.getEnvBool("CREATE_ALL_DEVICE")) {
                        try {
                            DataSchema ds = this.getSchema("https://kosmos-lab.de/schema/All.json");
                            if (ds == null) {
                                logger.info("no DS?");
                            } else if (!ds.getRawSchema().has("title")) {
                                logger.info("no title?!");
                            } else if (ds.getRawSchema().has("examples")) {
                                JSONArray examples = ds.getRawSchema().getJSONArray("examples");
                                if (examples.length() > 0) {
                                    String uuid = ds.getSchema().getTitle() + "0";
                                    if (!this.devices.containsKey(uuid)) {
                                        JSONObject ex = examples.getJSONObject(0);
                                        JSONObject o = new JSONObject();
                                        o.put("state", (Object)ex);
                                        o.put("schema", (Object)ds.getSchema().getId());
                                        o.put("uuid", (Object)uuid);
                                        try {
                                            this.parseAddDevice(this.persistence, o, this.getSource("HTTPApi:admin"), this.getUser("admin"));
                                        }
                                        catch (DeviceAlreadyExistsException e) {
                                            e.printStackTrace();
                                        }
                                        catch (ParameterNotFoundException e) {
                                            e.printStackTrace();
                                        }
                                        catch (SchemaNotFoundException e) {
                                            e.printStackTrace();
                                        }
                                        catch (ValidationException e) {
                                            e.printStackTrace();
                                        }
                                    } else {
                                        logger.info("example already exists {}", (Object)uuid);
                                    }
                                }
                            } else {
                                logger.info("no examples?!");
                            }
                        }
                        catch (SchemaNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    if (KosmoSHelper.getEnvBool("CREATE_DEVICES")) {
                        JSONObject state;
                        JSONObject obj;
                        HashMap<String, Integer> perSchema = new HashMap<String, Integer>();
                        for (Device d : this.devices.values()) {
                            if (d.getSchema() == null) continue;
                            String id = d.getSchema().getId();
                            Integer amount = (Integer)perSchema.get(id);
                            if (amount == null) {
                                perSchema.put(id, 1);
                                continue;
                            }
                            perSchema.put(id, 1 + amount);
                        }
                        IUser admin = this.getUser("admin");
                        if (admin == null) {
                            admin = this.users.values().iterator().next();
                        }
                        int min = 2;
                        schema2 = "https://kosmos-lab.de/schema/Lamp.json";
                        Integer amnt = (Integer)perSchema.get(schema2);
                        if (amnt == null || amnt < min) {
                            for (int i3 = 0; i3 < min; ++i3) {
                                obj = new JSONObject();
                                obj.put("uuid", (Object)("virt_lamp_" + i3));
                                state = new JSONObject();
                                state.put("on", false);
                                obj.put("state", (Object)state);
                                obj.put("schema", schema2);
                                try {
                                    this.parseAddDevice(this.persistence, obj, this.getSource("virtual"), admin);
                                    continue;
                                }
                                catch (DeviceAlreadyExistsException deviceAlreadyExistsException) {
                                    continue;
                                }
                                catch (ParameterNotFoundException e) {
                                    logger.error("Could not add Lamp because Parameter was not found!", (Throwable)e);
                                    continue;
                                }
                                catch (SchemaNotFoundException e) {
                                    logger.error("Could not add Lamp because Schema was not found!", (Throwable)((Object)e));
                                }
                            }
                        }
                        if ((amnt = (Integer)perSchema.get(schema2 = "https://kosmos-lab.de/schema/DimmableLamp.json")) == null || amnt < min) {
                            for (int i4 = 0; i4 < min; ++i4) {
                                obj = new JSONObject();
                                obj.put("uuid", (Object)("virt_dim_lamp_" + i4));
                                state = new JSONObject();
                                state.put("on", false);
                                state.put("dimmingLevel", 0);
                                obj.put("schema", schema2);
                                obj.put("state", (Object)state);
                                try {
                                    this.parseAddDevice(this.persistence, obj, this.getSource("virtual"), admin);
                                    continue;
                                }
                                catch (DeviceAlreadyExistsException e) {
                                    continue;
                                }
                                catch (ParameterNotFoundException e) {
                                    logger.error("Could not add Dimmable Lamp because Parameter was not found!", (Throwable)e);
                                    continue;
                                }
                                catch (SchemaNotFoundException e) {
                                    logger.error("Could not add Dimmable Lamp because Schema was not found!", (Throwable)((Object)e));
                                }
                            }
                        }
                        if ((amnt = (Integer)perSchema.get(schema2 = "https://kosmos-lab.de/schema/HSVLamp.json")) == null || amnt < min) {
                            for (int i5 = 0; i5 < min; ++i5) {
                                obj = new JSONObject();
                                obj.put("uuid", (Object)("virt_hsv_lamp_" + i5));
                                state = new JSONObject();
                                state.put("on", false);
                                state.put("hue", 0);
                                state.put("saturation", 0);
                                state.put("dimmingLevel", 0);
                                obj.put("state", (Object)state);
                                obj.put("schema", schema2);
                                try {
                                    this.parseAddDevice(this.persistence, obj, this.getSource("virtual"), admin);
                                    continue;
                                }
                                catch (DeviceAlreadyExistsException e) {
                                    continue;
                                }
                                catch (ParameterNotFoundException e) {
                                    logger.error("Could not add HSV Lamp because Parameter was not found!", (Throwable)e);
                                    continue;
                                }
                                catch (SchemaNotFoundException e) {
                                    logger.error("Could not add HSV Lamp because Schema was not found!", (Throwable)((Object)e));
                                }
                            }
                        }
                        if ((amnt = (Integer)perSchema.get(schema2 = "https://kosmos-lab.de/schema/OccupancySensor.json")) == null || amnt < min) {
                            for (int i6 = 0; i6 < min; ++i6) {
                                obj = new JSONObject();
                                obj.put("uuid", (Object)("virt_occupancy_sensor_" + i6));
                                state = new JSONObject();
                                state.put("occupancy", false);
                                obj.put("state", (Object)state);
                                obj.put("schema", schema2);
                                try {
                                    this.parseAddDevice(this.persistence, obj, this.getSource("virtual"), admin);
                                    continue;
                                }
                                catch (DeviceAlreadyExistsException e) {
                                    continue;
                                }
                                catch (ParameterNotFoundException e) {
                                    logger.error("Could not add Occupancy Sensor because Parameter was not found!", (Throwable)e);
                                    continue;
                                }
                                catch (SchemaNotFoundException e) {
                                    logger.error("Could not add Occupancy Sensor because Schema was not found!", (Throwable)((Object)e));
                                }
                            }
                        }
                        if ((amnt = (Integer)perSchema.get(schema2 = "https://kosmos-lab.de/schema/TemperatureSensor.json")) == null || amnt < min) {
                            for (int i7 = 0; i7 < min; ++i7) {
                                obj = new JSONObject();
                                obj.put("uuid", (Object)("virt_sensor_temp_" + i7));
                                obj.put("schema", schema2);
                                state = new JSONObject();
                                state.put("currentEnvironmentTemperature", 21.5);
                                obj.put("state", (Object)state);
                                obj.put("schema", schema2);
                                try {
                                    this.parseAddDevice(this.persistence, obj, this.getSource("virtual"), admin);
                                    continue;
                                }
                                catch (DeviceAlreadyExistsException e) {
                                    continue;
                                }
                                catch (ParameterNotFoundException e) {
                                    logger.error("Could not add Temperature Sensor because Parameter was not found!", (Throwable)e);
                                    continue;
                                }
                                catch (SchemaNotFoundException e) {
                                    logger.error("Could not add Temperature Sensor because Schema was not found!", (Throwable)((Object)e));
                                }
                            }
                        }
                        if ((amnt = (Integer)perSchema.get(schema2 = "https://kosmos-lab.de/schema/Heater.json")) == null || amnt < min) {
                            for (int i8 = 0; i8 < min; ++i8) {
                                obj = new JSONObject();
                                obj.put("uuid", (Object)("virt_heater_" + i8));
                                state = new JSONObject();
                                state.put("heatingTemperatureSetting", 21.5);
                                obj.put("state", (Object)state);
                                obj.put("schema", schema2);
                                try {
                                    this.parseAddDevice(this.persistence, obj, this.getSource("virtual"), admin);
                                    continue;
                                }
                                catch (DeviceAlreadyExistsException | SchemaNotFoundException | ParameterNotFoundException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Exception while reading devices.json", (Throwable)e);
                }
            }
        }
        this.pluginManager = new KosmosPluginManager();
        for (Class cls : this.pluginManager.getAllClassesFor(IAuthProvider.class)) {
            try {
                logger.info("found IAuthProvider class {}", (Object)cls.getCanonicalName());
                Method m = cls.getMethod("getInstance", IController.class);
                Object p = m.invoke(null, this);
                if (p == null) continue;
                this.authProviders.add((IAuthProvider)p);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            this.webServer = new KosmoSWebServer(this);
        }
        catch (Exception e) {
            logger.error("Fatal exception while starting WebServer", (Throwable)e);
            System.exit(0);
        }
        try {
            this.mqttBroker = new MQTTBroker(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setupHA();
        if (this.config.has("cameras")) {
            try {
                JSONArray camsJSON = this.config.getJSONArray("cameras");
                for (int i = 0; i < camsJSON.length(); ++i) {
                    try {
                        JSONObject camJSON = camsJSON.getJSONObject(i);
                        String clazz = camJSON.getString("clazz");
                        if (clazz == null) continue;
                        Class c = null;
                        try {
                            c = Class.forName(clazz);
                        }
                        catch (ClassNotFoundException min) {
                            // empty catch block
                        }
                        if (c == null) {
                            try {
                                c = this.pluginManager.getClass(clazz);
                            }
                            catch (ClassNotFoundException min) {
                                // empty catch block
                            }
                        }
                        if (c != null) {
                            if (ICamera.class.isAssignableFrom(c)) {
                                ICamera cam = (ICamera)c.getConstructor(JSONObject.class).newInstance(camJSON);
                                this.cameras.put(cam.getName(), cam);
                            } else {
                                logger.error("Could NOT parse {} as ICamera", (Object)c.getName());
                            }
                        }
                        if (c != null) continue;
                        logger.error("could not find class {} for camera", (Object)clazz);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error("exception while parsing camera {}", (Object)ex.getMessage(), (Object)ex);
                    }
                }
            }
            catch (Exception ex) {
                logger.error("exception while parsing cameras {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        logger.info("KosmoS startup complete");
    }

    private static JSONObject fixValidation(@Nonnull JSONObject json, @Nonnull ValidationException exception) {
        Matcher m;
        String message;
        String keyword;
        logger.error("trying to fix ValidationException {} {}", (Object)json, (Object)exception.getMessage());
        JSONObject exceptionjson = exception.toJSON();
        if (exceptionjson.has("keyword") && (keyword = exceptionjson.getString("keyword")).equals("additionalProperties") && (message = exceptionjson.getString("message")) != null && (m = extraneousKeyPattern.matcher(message)).matches()) {
            for (String key : m.group("keys").split(",")) {
                logger.warn("removing extraneous Key {} to fix JSONValidation", (Object)key);
                json.remove(key);
            }
            return json;
        }
        return null;
    }

    public static String shortUUID(String input) {
        if (input.startsWith("light.")) {
            return input.substring(6);
        }
        if (input.startsWith("sensor.")) {
            return input.substring(7);
        }
        if (input.startsWith("binary_sensor.")) {
            return input.substring(14);
        }
        return input;
    }

    public static String getFileString(String name, Constants.RunMode mode) {
        switch (mode) {
            case TEST: 
            case PLUGIN_TEST: {
                return String.format("./_test/%s", name);
            }
            case NORMAL: {
                return String.format("./%s", name);
            }
        }
        return null;
    }

    public static File getFile(String name, Constants.RunMode mode) {
        String dir = KosmoSController.getFileString(name, mode);
        File f = new File(dir);
        f.getParentFile().mkdirs();
        return f;
    }

    @Override
    public void addDeviceText(Device device, String key, String value) {
        DeviceText deviceText = device.getText(key);
        if (deviceText == null) {
            deviceText = new DeviceText(device, key, value);
            this.getPersistence().addDeviceText(deviceText);
        } else {
            deviceText.setValue(value);
            this.getPersistence().updateDeviceText(deviceText);
        }
    }

    @Override
    public void addEventInterface(EventInterface eventInterface) {
        this.eventInterfaces.add(eventInterface);
    }

    @Override
    public void fireEvent(Event event, EventInterface source) {
        for (EventInterface eventInterface : this.eventInterfaces) {
            if (eventInterface == source) continue;
            eventInterface.eventFired(source, event);
        }
    }

    public void addDevice(@Nonnull CommandInterface from, @Nonnull Device device, boolean addPermanent, @Nonnull CommandSourceName source) {
        this.devices.put(device.getUniqueID(), device);
        this.getPersistence().fillDeviceScopes(device);
        this.getPersistence().fillTexts(device);
        for (CommandInterface t : this.commandInterfaces) {
            if (!addPermanent && t instanceof IPersistence) {
                try {
                    ((IPersistence)((Object)t)).delDevice(device);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            t.deviceAdded(from, device, source);
        }
    }

    @Override
    public void addDevice(@Nonnull CommandInterface from, @Nonnull Device device, boolean addPermanent) {
        this.addDevice(from, device, addPermanent, this.getSource(from.getSourceName()));
    }

    public void addDevice(@Nonnull CommandInterface from, @Nonnull Device device, boolean addPermanent, @Nonnull String source) {
        this.addDevice(from, device, addPermanent, this.getSource(source));
    }

    @Override
    @Nonnull
    public Group addGroup(@Nonnull String name, @Nonnull IUser user) throws GroupAlreadyExistsException {
        return this.getPersistence().addGroup(name, user);
    }

    @Override
    public void addGroupAdmin(@Nonnull Group group, @Nonnull IUser user) {
        this.getPersistence().addGroupAdmin(group, user);
    }

    @Override
    public void addGroupUser(@Nonnull Group group, @Nonnull IUser user) {
        this.getPersistence().addGroupUser(group, user);
    }

    @Override
    public void addSchema(@Nonnull DataSchema dataSchema) {
        this.getPersistence().addSchema(dataSchema);
    }

    @Override
    public Scope addScope(@Nonnull String name, @Nonnull IUser user) throws ScopeAlreadyExistsException {
        return this.getPersistence().addScope(name, user);
    }

    @Override
    public void addScopeAdmin(Scope scope, IUser user) {
        this.getPersistence().addScopeAdmin(scope, user);
    }

    @Override
    public void addScopeGroup(@Nonnull Scope scope, @Nonnull Group group) {
        this.getPersistence().addScopeGroup(scope, group);
    }

    @Override
    public void addScopeAdminGroup(@Nonnull Scope scope, @Nonnull Group group) {
        this.getPersistence().addScopeAdminGroup(scope, group);
    }

    @Override
    public void addScopeUser(@Nonnull Scope scope, @Nonnull IUser user) {
        this.getPersistence().addScopeUser(scope, user);
    }

    @Override
    public void addSmartHome(@Nonnull SmartHomeInterface smartHomeInterface) {
        this.smartEnvironments.add(smartHomeInterface);
        this.commandInterfaces.add(smartHomeInterface);
    }

    public void addUser(String username, String password, int level) {
        String salt = StringFunctions.generateRandomKey();
        this.addUser(new KosmoSUser(this, username, 0, level, this.hashSaltPepper(password, salt), salt));
    }

    @Override
    public void addUser(@Nonnull IUser u) {
        this.getPersistence().addUser(u);
        this.cacheUser(u);
    }

    @Override
    public void addCommandInterface(@Nonnull CommandInterface commandInterface) {
        this.commandInterfaces.add(commandInterface);
    }

    @Override
    public void cacheDevice(@Nonnull Device device) {
        this.devices.put(device.getUniqueID(), device);
    }

    @Override
    public void setDeviceLocation(@Nonnull String uuid, @Nonnull Device.Location loc) {
        try {
            Device d = this.getDevice(uuid);
            d.setLocation(loc);
        }
        catch (DeviceNotFoundException deviceNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void cacheGroup(@Nonnull Group group) {
        this.groups.put(group.getName(), group);
        this.groupsI.put(group.getID(), group);
    }

    @Override
    public void cacheSchema(@Nonnull DataSchema dataSchema) {
        this.schemas.put(dataSchema.getSchema().getId(), dataSchema);
    }

    @Override
    public void cacheScope(@Nonnull Scope scope) {
        this.scopes.put(scope.getName(), scope);
        this.scopesI.put(scope.getID(), scope);
    }

    @Override
    public void cacheUser(@Nonnull IUser user) {
        this.users.put(user.getName().toLowerCase(), user);
        this.usersI.put(user.getUUID(), user);
        if (user instanceof KosmoSUser) {
            this.usersID.put(((KosmoSUser)user).getID(), user);
        }
    }

    @Override
    public void createSubs(@Nonnull String path, @Nonnull String filename, @Nonnull Calendar videoStart, @Nonnull Calendar videoEnd, @Nonnull List<LoggingRequest> uuids, long delta) {
        HashSet<String> uuidList = new HashSet<String>();
        HashMap<String, Set<String>> proplist = new HashMap<String, Set<String>>();
        for (LoggingRequest request : uuids) {
            uuidList.add(request.getUuid());
            proplist.put(request.getUuid(), request.getProperties());
        }
        List<LogEntry> logs = this.getLogs(videoStart, videoEnd, uuidList);
        HashMap<String, LinkedList<SubtitleEntry>> uuidsubs = new HashMap<String, LinkedList<SubtitleEntry>>();
        HashMap<String, SubtitleEntry> subbacklog = new HashMap<String, SubtitleEntry>();
        for (LogEntry logEntry : logs) {
            long t;
            SubtitleEntry lastentry = (SubtitleEntry)subbacklog.get(logEntry.getUuid());
            if (lastentry != null && lastentry.to > (t = logEntry.getDate().getTime())) {
                lastentry.to = t;
            }
            JSONObject json = new JSONObject();
            for (String p : (Set)proplist.get(logEntry.getUuid())) {
                json.put(p, logEntry.getState().opt(p));
            }
            SubtitleEntry myEntry = new SubtitleEntry(logEntry.getDate().getTime(), logEntry.getDate().getTime() + 10000L, json.toString(), logEntry.getUuid());
            subbacklog.put(logEntry.getUuid(), myEntry);
            LinkedList<SubtitleEntry> list = (LinkedList<SubtitleEntry>)uuidsubs.get(logEntry.getUuid());
            if (list == null) {
                list = new LinkedList<SubtitleEntry>();
                uuidsubs.put(logEntry.getUuid(), list);
            }
            list.add(myEntry);
        }
        TreeMap<Long, LinkedList<SubtitleEntry>> sortedEntries = new TreeMap<Long, LinkedList<SubtitleEntry>>();
        for (LoggingRequest r : uuids) {
            String uuid = r.getUuid();
            List list = (List)uuidsubs.get(uuid);
            if (list == null) continue;
            StringBuilder sb = new StringBuilder();
            int i = 1;
            for (SubtitleEntry e : list) {
                long d1 = e.from - videoStart.getTimeInMillis() + delta;
                long d2 = e.to - videoStart.getTimeInMillis() + delta;
                sb.append(i++).append('\n').append(TimeFunctions.createSRTTimestamp(d1)).append(" --> ").append(TimeFunctions.createSRTTimestamp(d2)).append('\n').append(e.text).append("\n\n");
                LinkedList<SubtitleEntry> mylist = (LinkedList<SubtitleEntry>)sortedEntries.get(e.from);
                if (mylist == null) {
                    mylist = new LinkedList<SubtitleEntry>();
                    sortedEntries.put(e.from, mylist);
                }
                mylist.add(e);
            }
            File f = new File(path + "/" + filename + "." + KosmoSController.shortUUID(uuid) + ".srt");
            KosmosFileUtils.writeToFile((File)f, (String)sb.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        int totali = 1;
        for (List v : sortedEntries.values()) {
            for (SubtitleEntry e : v) {
                long d1 = e.from - videoStart.getTimeInMillis() + delta;
                long d2 = e.to - videoStart.getTimeInMillis() + delta;
                stringBuilder.append(totali++).append('\n').append(TimeFunctions.createSRTTimestamp(d1)).append(" --> ").append(TimeFunctions.createSRTTimestamp(d2)).append('\n').append(KosmoSController.shortUUID(e.getUuid())).append(":").append(e.text).append("\n\n");
            }
        }
        KosmosFileUtils.writeToFile((File)new File(path + "/" + filename + ".srt"), (String)stringBuilder.toString());
    }

    @Override
    public boolean currentlyInTesting() {
        return this.runMode != Constants.RunMode.NORMAL;
    }

    @Override
    public void delGroup(@Nonnull Group group) {
        logger.info("deleting group {}", (Object)group.getName());
        this.groups.remove(group.getName());
        this.groupsI.remove(group.getID());
        this.getPersistence().delGroup(group);
    }

    @Override
    public boolean delGroupAdmin(@Nonnull Group group, @Nonnull IUser user) {
        if (group.hasAdmin(user)) {
            this.getPersistence().delGroupAdmin(group, user);
            return true;
        }
        return false;
    }

    @Override
    public boolean delGroupUser(@Nonnull Group group, IUser user) {
        if (group.hasUser(user)) {
            this.getPersistence().delGroupUser(group, user);
            return true;
        }
        return false;
    }

    @Override
    public boolean delScopeAdmin(@Nonnull Scope scope, @Nonnull IUser user) {
        if (scope.hasAdmin(user)) {
            this.getPersistence().delScopeAdmin(scope, user);
            return true;
        }
        return false;
    }

    @Override
    public boolean delScopeUser(@Nonnull Scope scope, @Nonnull IUser user) {
        if (scope.hasUser(user)) {
            this.getPersistence().delScopeUser(scope, user);
            return true;
        }
        return false;
    }

    @Override
    public void deleteDevice(@Nonnull CommandInterface from, @Nonnull Device device, @Nonnull CommandSourceName source) {
        this.devices.remove(device.getUniqueID());
        for (CommandInterface t : this.commandInterfaces) {
            t.deviceRemoved(from, device, source);
        }
    }

    @Override
    public void deleteDevice(@Nonnull CommandInterface from, @Nonnull Device device) {
        this.deleteDevice(from, device, this.getSource(from.getSourceName()));
    }

    @Override
    public void deleteDevice(@Nonnull CommandInterface from, @Nonnull Device device, @Nonnull String source) {
        this.deleteDevice(from, device, this.getSource(source));
    }

    @Override
    public void deleteSchema(@Nonnull DataSchema schema) {
        this.getPersistence().delSchema(schema);
        this.schemas.remove(schema.getSchema().getId());
    }

    @Override
    public void deleteScope(@Nonnull Scope scope) {
        this.persistence.delScope(scope);
        this.scopes.remove(scope.getName());
        this.scopesI.remove(scope.getID());
    }

    @Override
    public void deleteUser(@Nonnull IUser user) {
        this.users.remove(user.getName().toLowerCase());
        this.getPersistence().delUser(user);
    }

    @Override
    public DataSchema findSchema(@Nonnull String manufacturer, @Nonnull String model) throws SchemaNotFoundException {
        return this.getFallBackSchema();
    }

    @Override
    public Collection<Device> getAllDevices() {
        HashSet<Device> set = new HashSet<Device>();
        set.addAll(this.devices.values());
        return set;
    }

    @Override
    public Collection<Group> getAllGroupsWithAdmin(@Nonnull IUser user) {
        LinkedList<Group> list = new LinkedList<Group>();
        for (Group s : this.groups.values()) {
            if (!s.hasAdmin(user)) continue;
            list.add(s);
        }
        return list;
    }

    @Override
    public Collection<Group> getAllGroupsWithUser(@Nonnull IUser user) {
        LinkedList<Group> list = new LinkedList<Group>();
        for (Group s : this.groups.values()) {
            if (!s.hasUser(user)) continue;
            list.add(s);
        }
        return list;
    }

    @Override
    public Collection<DataSchema> getAllSchemas() {
        TreeSet<DataSchema> set = new TreeSet<DataSchema>(new SchemaComparator());
        set.addAll(this.schemas.values());
        return set;
    }

    @Override
    public Collection<Scope> getAllScopesWithAdmin(@Nonnull IUser user) {
        LinkedList<Scope> list = new LinkedList<Scope>();
        for (Scope s : this.scopes.values()) {
            if (!s.hasAdmin(user)) continue;
            list.add(s);
        }
        return list;
    }

    @Override
    public Collection<Scope> getAllScopesWithUser(@Nonnull IUser user) {
        LinkedList<Scope> list = new LinkedList<Scope>();
        for (Scope s : this.scopes.values()) {
            if (!s.hasUser(user)) continue;
            list.add(s);
        }
        return list;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    @Nonnull
    public Device getDevice(@Nonnull String uuid) throws DeviceNotFoundException {
        Device d = this.devices.get(uuid);
        if (d != null) {
            return d;
        }
        throw new DeviceNotFoundException(uuid);
    }

    @Override
    @Nonnull
    public DataSchema getFallBackSchema() {
        if (this.fallbackSchema == null) {
            try {
                this.fallbackSchema = new DataSchema(new JSONObject().put("$id", (Object)"https://kosmos-lab.de/schema/NoSchema.json").put("$schema", (Object)"http://json-schema.org/draft-07/schema#").put("additionalProperties", true).put("failures", (Object)new JSONArray()).put("examples", (Object)new JSONArray()));
            }
            catch (NotObjectSchemaException e) {
                throw new RuntimeException("could not convert the fallback schema to a DataSchema");
            }
        }
        return this.fallbackSchema;
    }

    @Override
    public GestureProvider getGestureProvider() {
        return this.gestureProvider;
    }

    @Override
    @Nonnull
    public Group getGroup(int id, Constants.CacheMode cacheMode) throws GroupNotFoundException {
        Group group = this.groupsI.get(id);
        if (cacheMode == Constants.CacheMode.CACHE_AND_PERSISTENCE && group == null) {
            try {
                group = this.getPersistence().getGroup(id);
            }
            catch (NotFoundInPersistenceException notFoundInPersistenceException) {
                // empty catch block
            }
        }
        if (group == null) {
            throw new GroupNotFoundException(id);
        }
        return group;
    }

    @Override
    @Nonnull
    public Group getGroup(@Nonnull String name, Constants.CacheMode cacheMode) throws GroupNotFoundException {
        Group group = this.groups.get(name);
        if (cacheMode == Constants.CacheMode.CACHE_AND_PERSISTENCE && group == null) {
            try {
                return this.getPersistence().getGroup(name);
            }
            catch (NotFoundInPersistenceException notFoundInPersistenceException) {
                // empty catch block
            }
        }
        if (group == null) {
            throw new GroupNotFoundException(name);
        }
        return group;
    }

    public Device getHADeviceByDomain(String entityid) {
        try {
            try {
                return this.getDevice(entityid);
            }
            catch (DeviceNotFoundException exx) {
                Device d = null;
                Matcher m = Constants.domainSplitPattern.matcher(entityid);
                if (m.matches()) {
                    String uuid = m.group("uuid");
                    int lastIndex = 0;
                    while (lastIndex >= 0) {
                        try {
                            int nextIndex = uuid.indexOf(95, lastIndex);
                            if (nextIndex <= -1) continue;
                            String uuid1 = uuid.substring(0, nextIndex);
                            String attr1 = uuid.substring(nextIndex + 1);
                            logger.warn("split domain {} {}", (Object)uuid1, (Object)attr1);
                            d = this.getDevice(uuid1);
                            try {
                                if (d != null) {
                                    logger.warn("dev found for split domain {} {}", (Object)uuid1, (Object)attr1);
                                    if (d.has(attr1)) {
                                        logger.warn("FOUND! split domain {} {}", (Object)uuid1, (Object)attr1);
                                        return d;
                                    }
                                    for (String key : d.keySet()) {
                                        try {
                                            if (!key.equalsIgnoreCase(attr1)) continue;
                                            logger.warn("FOUND! split domain {} {}", (Object)uuid1, (Object)attr1);
                                            return d;
                                        }
                                        catch (Exception ex) {
                                            logger.warn("Exception:", (Throwable)ex);
                                        }
                                    }
                                    d = null;
                                }
                                if ((lastIndex = nextIndex + 1) < uuid.length()) continue;
                                return null;
                            }
                            catch (Exception ex) {
                                logger.warn("Exception:", (Throwable)ex);
                            }
                        }
                        catch (Exception ex) {
                            logger.warn("exception", (Throwable)ex);
                        }
                    }
                }
                return d;
            }
        }
        catch (Exception ex) {
            logger.error("error in HADevice", (Throwable)ex);
            return null;
        }
    }

    @Override
    public JWT getJwt() {
        return this.jwt;
    }

    @Override
    @CheckForNull
    public Device.Location getLocation(@Nonnull IUser user, @Nonnull String uuid) throws DeviceNotFoundException, NoAccessToScope {
        return this.getDevice(uuid, user, Scope.ScopeType.read).getLocation();
    }

    @Override
    public List<LogEntry> getLogs(@Nonnull Calendar calStart, @Nonnull Calendar calEnd, @Nonnull String[] uuids) {
        return this.getPersistence().getStates(calStart.getTimeInMillis(), calEnd.getTimeInMillis(), uuids);
    }

    @Override
    public List<LogEntry> getLogs(@Nonnull Calendar calStart, @Nonnull Calendar calEnd, @Nonnull Set<String> uuids) {
        return this.getPersistence().getStates(calStart.getTimeInMillis(), calEnd.getTimeInMillis(), uuids);
    }

    @Override
    public Collection<String> getMatchingUUID(@Nonnull String u) {
        LinkedList<String> list = new LinkedList<String>();
        for (Device d : this.getAllDevices()) {
            if (!Wildcard.matches((String)u, (String)d.getUniqueID())) continue;
            list.add(d.getUniqueID());
        }
        return list;
    }

    @Override
    public String getPasswordHash(String input, String salt) {
        return HashFunctions.getSaltedAndPepperdHash((String)input, (String)salt, (String)this.getPepper());
    }

    protected String getPepper() {
        return this.config.getString("pepper");
    }

    @Override
    public IPersistence getPersistence() {
        return this.persistence;
    }

    @Override
    public RulesService getRulesService() {
        return this.rulesService;
    }

    @Override
    public DataSchema getSchema(@Nonnull String id) throws SchemaNotFoundException {
        DataSchema s = this.schemas.get(id);
        if (s != null) {
            return s;
        }
        try {
            return this.getPersistence().getSchema(id);
        }
        catch (NotFoundInPersistenceException notFoundInPersistenceException) {
            try {
                HTTPClient c = new HTTPClient();
                JSONObject o = c.fetchJSONObject(id, HttpMethod.GET);
                if (o != null) {
                    s = new DataSchema(o);
                    this.addSchema(s);
                    return s;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SchemaNotFoundException(id);
        }
    }

    @Override
    public Scope getScope(int id, Constants.CacheMode cacheMode) throws NotFoundInPersistenceException {
        Scope scope = this.scopesI.get(id);
        if (cacheMode == Constants.CacheMode.CACHE_AND_PERSISTENCE && scope == null) {
            scope = this.getPersistence().getScope(id);
        }
        return scope;
    }

    @Override
    @Nonnull
    public Scope getScope(@Nonnull String name, Constants.CacheMode cacheMode) throws NotFoundInPersistenceException {
        Scope scope = this.scopes.get(name);
        if (cacheMode == Constants.CacheMode.CACHE_AND_PERSISTENCE && scope == null) {
            scope = this.getPersistence().getScope(name);
        }
        return scope;
    }

    @Override
    @SuppressFBWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"})
    public CommandSourceName getSource(@Nonnull String key) {
        CommandSourceName s = this.cacheSource.get(key);
        if (s == null) {
            s = () -> key;
            this.cacheSource.put(key, s);
        }
        return s;
    }

    @Override
    public HashMap<Device, StateUpdates> getUpdates(@Nonnull Collection<String> uuids, long maxage) {
        HashMap<Device, StateUpdates> updates = new HashMap<Device, StateUpdates>();
        for (String u : uuids) {
            try {
                Device d = this.getDevice(u);
                StateUpdates changes = d.getChanges(maxage);
                if (changes == null) continue;
                updates.put(d, changes);
            }
            catch (DeviceNotFoundException ex) {
                logger.info("Exception:", (Throwable)((Object)ex));
            }
        }
        return updates;
    }

    @Override
    public IUser getUser(@Nonnull String username) {
        IUser user = this.users.get(username.toLowerCase());
        if (user == null) {
            try {
                user = this.getPersistence().getUser(username);
            }
            catch (NotFoundInPersistenceException e) {
                logger.warn("could not find user {}", (Object)username);
            }
        }
        return user;
    }

    @Override
    public IUser getUser(int userid) throws UserNotFoundException {
        IUser user = this.usersID.get(userid);
        if (user == null) {
            try {
                user = this.getPersistence().getUser(userid);
            }
            catch (NotFoundInPersistenceException e) {
                logger.warn("could not find user {}", (Object)userid);
                throw new UserNotFoundException("" + userid);
            }
        }
        return user;
    }

    @Override
    public IUser getUserCreateIfUnavailable(@Nonnull String user) {
        logger.info("looking for {}", (Object)user);
        IUser u = this.getUser(user);
        if (u == null) {
            logger.info("needing to create user {}", (Object)user);
            this.addUser(user, StringFunctions.generateRandomKey(), 1);
            u = this.getUser(user);
        }
        logger.info("returning {}", (Object)u);
        return u;
    }

    @Override
    public KosmoSWebServer getWebServer() {
        return this.webServer;
    }

    @Override
    public String hashPepper(@Nonnull String input) {
        return HashFunctions.getSaltedHash((String)input, (String)this.getPepper());
    }

    @Override
    public String hashSaltPepper(@Nonnull String input, @Nonnull String salt) {
        return HashFunctions.getSaltedAndPepperdHash((String)input, (String)salt, (String)this.getPepper());
    }

    @Override
    public void parseAddDevice(@Nonnull CommandInterface from, @Nonnull JSONObject o, @Nonnull CommandSourceName source, @Nonnull IUser user) throws ValidationException, DeviceAlreadyExistsException, ParameterNotFoundException, SchemaNotFoundException {
        this.parseAddDevice(from, o, source, user, true);
    }

    @Override
    public void parseAddDevice(@Nonnull CommandInterface from, @Nonnull JSONObject o, @Nonnull CommandSourceName source, @Nonnull IUser user, boolean permanent) throws ValidationException, DeviceAlreadyExistsException, ParameterNotFoundException, SchemaNotFoundException {
        if (o != null) {
            String schemaName = o.optString("schema", null);
            if (schemaName == null) {
                throw new ParameterNotFoundException("schema");
            }
            DataSchema schema = this.getSchema(schemaName);
            if (schema != null) {
                if (o.has("uuid")) {
                    String uuid = o.getString("uuid");
                    try {
                        this.getDevice(uuid);
                        throw new DeviceAlreadyExistsException(uuid);
                    }
                    catch (DeviceNotFoundException deviceNotFoundException) {
                        Device d;
                        block26: {
                            String name = o.optString("name", uuid);
                            JSONObject json = o.optJSONObject("state");
                            if (json == null) {
                                json = new JSONObject();
                            }
                            d = new Device(this, source, schema, json, name, uuid, user, false);
                            this.addDevice(from, d, permanent, source);
                            try {
                                String sname;
                                Scope scope;
                                if (!o.has("scopes")) break block26;
                                JSONObject scopes = o.getJSONObject("scopes");
                                if (scopes.has("read")) {
                                    scope = null;
                                    sname = scopes.getString("read");
                                    try {
                                        scope = this.getScope(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                                    }
                                    catch (NotFoundInPersistenceException e) {
                                        try {
                                            scope = this.addScope(sname, user);
                                        }
                                        catch (ScopeAlreadyExistsException ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                    if (scope != null) {
                                        this.setReadScope(d, scope);
                                    }
                                }
                                if (scopes.has("write")) {
                                    scope = null;
                                    sname = scopes.getString("write");
                                    try {
                                        scope = this.getScope(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                                    }
                                    catch (NotFoundInPersistenceException e) {
                                        try {
                                            scope = this.addScope(sname, user);
                                        }
                                        catch (ScopeAlreadyExistsException ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                    if (scope != null) {
                                        this.setWriteScope(d, scope);
                                    }
                                }
                                if (!scopes.has("del")) break block26;
                                scope = null;
                                sname = scopes.getString("del");
                                try {
                                    scope = this.getScope(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                                }
                                catch (NotFoundInPersistenceException e) {
                                    try {
                                        scope = this.addScope(sname, user);
                                    }
                                    catch (ScopeAlreadyExistsException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                if (scope != null) {
                                    this.setDelScope(d, scope);
                                }
                            }
                            catch (JSONException jSONException) {
                                // empty catch block
                            }
                        }
                        this.cacheDevice(d);
                        this.publishUpdate(from, d, null, source);
                        return;
                    }
                }
                throw new ParameterNotFoundException("uuid");
            }
            throw new SchemaNotFoundException(schemaName);
        }
    }

    @Override
    public Device parseHASet(@Nonnull CommandInterface from, @Nonnull String uuid, @Nonnull JSONObject json, @Nonnull CommandSourceName source, @Nonnull IUser user) throws DeviceNotFoundException, ValidationException, NoAccessToScope {
        Object state;
        Device d = null;
        int ptIndex = uuid.indexOf(46);
        if (ptIndex > 0) {
            try {
                d = this.getDevice(uuid.substring(ptIndex + 1));
            }
            catch (DeviceNotFoundException deviceNotFoundException) {
                // empty catch block
            }
        }
        try {
            d = this.getDevice(uuid);
        }
        catch (DeviceNotFoundException deviceNotFoundException) {
            // empty catch block
        }
        if (d == null) {
            if (json.has("state") && (state = json.get("state")) instanceof JSONObject) {
                logger.info("state is object {}", state);
                JSONObject sjson = (JSONObject)state;
                String device_class = sjson.optString("device_class");
                if (device_class != null && device_class.equalsIgnoreCase("update")) {
                    return null;
                }
                if (sjson.has("supported_color_modes")) {
                    logger.info("has SCM {} {}", (Object)uuid, sjson.get("supported_color_modes"));
                    try {
                        JSONArray scm = sjson.getJSONArray("supported_color_modes");
                        if (JSONFunctions.hasEntries((JSONArray)scm, (String[])new String[]{"color_temp", "xy"})) {
                            json.put("schema", (Object)"https://kosmos-lab.de/schema/HAXYCCTLamp.json");
                        } else if (JSONFunctions.hasEntries((JSONArray)scm, (String[])new String[]{"color_temp", "hs"})) {
                            json.put("schema", (Object)"https://kosmos-lab.de/schema/HAHSCCTLamp.json");
                        } else if (JSONFunctions.hasEntries((JSONArray)scm, (String[])new String[]{"color_temp"})) {
                            json.put("schema", (Object)"https://kosmos-lab.de/schema/HACCTLamp.json");
                        } else if (JSONFunctions.hasEntries((JSONArray)scm, (String[])new String[]{"rgbw"})) {
                            json.put("schema", (Object)"https://kosmos-lab.de/schema/HARGBWLamp.json");
                        } else if (JSONFunctions.hasEntries((JSONArray)scm, (String[])new String[]{"rgb"})) {
                            json.put("schema", (Object)"https://kosmos-lab.de/schema/HARGBLamp.json");
                        } else if (JSONFunctions.hasEntries((JSONArray)scm, (String[])new String[]{"brightness"})) {
                            json.put("schema", (Object)"https://kosmos-lab.de/schema/HADimLamp.json");
                        } else if (JSONFunctions.hasEntries((JSONArray)scm, (String[])new String[]{"onoff"})) {
                            json.put("schema", (Object)"https://kosmos-lab.de/schema/HAToggleLamp.json");
                        }
                    }
                    catch (Exception scm) {}
                } else {
                    logger.info("has NO SCM {}", (Object)uuid);
                    if (uuid.startsWith("zone.") && JSONFunctions.hasEntries((JSONObject)sjson, (String[])new String[]{"latitude", "longitude", "radius", "passive", "state"})) {
                        json.put("schema", (Object)"https://kosmos-lab.de/schema/HAZone.json");
                    } else if (uuid.startsWith("person.") && JSONFunctions.hasEntries((JSONObject)sjson, (String[])new String[]{"user_id"})) {
                        json.put("schema", (Object)"https://kosmos-lab.de/schema/HAPerson.json");
                    } else if (uuid.startsWith("sun.") && JSONFunctions.hasEntries((JSONObject)sjson, (String[])new String[]{"next_rising"})) {
                        json.put("schema", (Object)"https://kosmos-lab.de/schema/HASun.json");
                    } else if (uuid.startsWith("weather.") && JSONFunctions.hasEntries((JSONObject)sjson, (String[])new String[]{"forecast"})) {
                        json.put("schema", (Object)"https://kosmos-lab.de/schema/HAWeather.json");
                    } else if (uuid.startsWith("switch.")) {
                        json.put("schema", (Object)"https://kosmos-lab.de/schema/HASwitch.json");
                    } else if (uuid.startsWith("cover.")) {
                        json.put("schema", (Object)"https://kosmos-lab.de/schema/HACover.json");
                    } else if (uuid.startsWith("sensor.")) {
                        String state_class = sjson.optString("state_class");
                        if (state_class == null || state_class.equalsIgnoreCase("humidity")) {
                            // empty if block
                        }
                        json.put("schema", (Object)"https://kosmos-lab.de/schema/HASensor.json");
                    } else if (uuid.startsWith("scene.")) {
                        return null;
                    }
                }
            }
            if (!json.has("schema")) {
                json.put("schema", (Object)this.getFallBackSchema().getSchema().getId());
            }
            try {
                try {
                    if (!json.has("uuid")) {
                        json.put("uuid", (Object)uuid);
                    }
                    this.parseAddDevice(from, json, source, user, false);
                    d = this.getDevice(uuid);
                    if (from instanceof KosmoSWebSocketService) {
                        ((KosmoSWebSocketService)from).addIgnoredDevice(user, d);
                    }
                    return d;
                }
                catch (ValidationException ex) {
                    logger.info("could NOT validate\nschema: {}\ndata:{}", (Object)json.getJSONObject("state"), (Object)json.getString("schema"));
                    throw ex;
                }
            }
            catch (DeviceAlreadyExistsException e) {
                e.printStackTrace();
            }
            catch (ParameterNotFoundException e) {
                e.printStackTrace();
            }
            catch (SchemaNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            logger.info("parse new JSON for device {}:{}", (Object)d.getUniqueID(), (Object)json);
            if (json.has("state") && (state = json.get("state")) instanceof JSONObject) {
                try {
                    JSONObject j = json.getJSONObject("state");
                    if (j.length() > 0) {
                        try {
                            this.parseSet(from, d, j, source, user);
                        }
                        catch (ValidationException ex) {
                            JSONObject newJSON = KosmoSController.fixValidation(j, ex);
                            while (newJSON != null) {
                                try {
                                    this.parseSet(from, d, newJSON, source, user);
                                    return d;
                                }
                                catch (ValidationException exx) {
                                    newJSON = KosmoSController.fixValidation(newJSON, exx);
                                }
                            }
                            throw ex;
                        }
                        return d;
                    }
                    json.remove("state");
                }
                catch (ValidationException ex) {
                    logger.info("could NOT validate: {} - {}", (Object)json.getJSONObject("state"), (Object)ex.toJSON());
                    throw ex;
                }
            }
            try {
                this.parseSet(from, uuid, json, source, user);
            }
            catch (ValidationException ex) {
                logger.info("could NOT validate\nschema: {}\ndata:{}", (Object)json.getJSONObject("state"), (Object)json.getString("schema"));
                throw ex;
            }
        }
        return d;
    }

    @Override
    public Device parseSet(@Nonnull CommandInterface from, @Nonnull String uuid, @Nonnull JSONObject json, @Nonnull CommandSourceName source, @Nonnull IUser user) throws DeviceNotFoundException, ValidationException, NoAccessToScope {
        Device device = this.getDevice(uuid, user, Scope.ScopeType.write);
        return this.parseSet(from, device, json, source, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Device parseSet(@Nonnull CommandInterface from, @Nonnull Device device, @Nonnull JSONObject json, @Nonnull CommandSourceName source, @Nonnull IUser user) throws DeviceNotFoundException, ValidationException, NoAccessToScope {
        json.remove("uuid");
        json.remove("id");
        try {
            device.lock();
            if (device.canWrite(user)) {
                HashSet<String> newKeys = new HashSet<String>();
                for (String key : json.keySet()) {
                    if (device.has(key)) continue;
                    newKeys.add(key);
                }
                if (!newKeys.isEmpty()) {
                    // empty if block
                }
                if (!(from instanceof IPersistence)) {
                    Iterator iter = json.keySet().iterator();
                    HashSet<String> toClean = new HashSet<String>();
                    while (iter.hasNext()) {
                        String k2 = (String)iter.next();
                        if (from != this.webServer) {
                            if (!device.canHave(k2)) {
                                toClean.add(k2);
                            }
                            if (device.canWrite(k2, user)) continue;
                            toClean.add(k2);
                            continue;
                        }
                        if (device.canWrite(k2, user)) continue;
                        throw new ValidationException("cannot change value of " + k2);
                    }
                    for (String key : toClean) {
                        json.remove(key);
                    }
                }
                device.updateFromJSON(from, json, source);
                Object object = device;
                return object;
            }
        }
        finally {
            device.unlock();
        }
        return null;
    }

    @Override
    public void publishUpdate(@CheckForNull CommandInterface from, @Nonnull Device device, String key, @Nonnull CommandSourceName source) {
        logger.info("pub update {} {} {} {}:{}", new Object[]{device.getUniqueID(), from, source.getSourceName(), key, key != null ? device.opt(key) : ""});
        for (CommandInterface t : this.commandInterfaces) {
            new Thread(() -> t.deviceUpdate(from, device, key, source)).start();
        }
    }

    @Override
    public void setDelScope(@Nonnull Device device, @Nonnull Scope scope) {
        device.setDelScope(scope);
        this.getPersistence().setDelScope(device, scope);
    }

    @Override
    public Device.Location setLocation(@Nonnull IUser user, @Nonnull JSONObject json, @Nonnull CommandSourceName source) throws DeviceNotFoundException, NoAccessToScope, ParameterNotFoundException {
        KosmoSWebSocketService wss;
        if (!json.has("uuid")) {
            throw new ParameterNotFoundException("uuid");
        }
        String uuid = json.getString("uuid");
        Device d = this.getDevice(uuid, user, Scope.ScopeType.write);
        Device.Location loc = d.getLocation();
        if (loc == null) {
            loc = new Device.Location(json);
            d.setLocation(loc);
            this.getPersistence().updateLocation(d);
        } else if (loc.updateFromJSON(json)) {
            this.getPersistence().updateLocation(d);
        }
        if (this.webServer != null && (wss = this.webServer.getWebSocketService()) != null) {
            wss.broadcastToReadUsers(d, "device/" + d.getUniqueID() + "/location:" + loc.toJSON(), source);
        }
        return loc;
    }

    @Override
    public void setName(@Nonnull Device device, @Nonnull String name) {
        this.getPersistence().setName(device, name);
    }

    @Override
    public void setReadScope(@Nonnull Device device, @Nonnull Scope scope) {
        device.setReadScope(scope);
        this.getPersistence().setReadScope(device, scope);
    }

    @Override
    public void setUserPassword(@Nonnull IUser user, @Nonnull String salt, @Nonnull String hash) {
        this.getPersistence().setPassword(user, salt, hash);
    }

    @Override
    public void setWriteScope(@Nonnull Device device, @Nonnull Scope scope) {
        device.setWriteScope(scope);
        this.getPersistence().setWriteScope(device, scope);
    }

    private void setupHA() {
        if (KosmoSHelper.getEnvBool("DONTSETUPHA")) {
            return;
        }
        try {
            if (KosmoSHelper.getEnvBool("SETUPHA")) {
                String kosmos_host;
                String ha_host = KosmoSHelper.getEnv("HA_HOST");
                if (ha_host == null) {
                    ha_host = "kha";
                }
                if ((kosmos_host = KosmoSHelper.getEnv("KOSMOS_HOST")) == null) {
                    kosmos_host = "kcontroller";
                }
                this.setupHA("http://" + ha_host + ":8123", "http://" + kosmos_host + ":" + this.webServer.getPort());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String getFileString(String name) {
        return KosmoSController.getFileString(name, this.runMode);
    }

    @Override
    public File getFile(String name) {
        return KosmoSController.getFile(name, this.runMode);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private boolean setupHA(@Nonnull String habase, @Nonnull String myhost) {
        block23: {
            try {
                String ha_pass;
                String ha_user = KosmoSHelper.getEnv("HA_USER");
                if (ha_user == null) {
                    ha_user = "kosmos";
                }
                if ((ha_pass = KosmoSHelper.getEnv("HA_PASS")) == null) {
                    ha_pass = "pass";
                }
                int tries_left = 20;
                while (tries_left > 0) {
                    try {
                        logger.info("trying to connect to: {}", (Object)habase);
                        URL url = new URL(habase);
                        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                        in.close();
                        logger.info("HA is reachable as it seems");
                        break;
                    }
                    catch (MalformedURLException e) {
                        return false;
                    }
                    catch (IOException e) {
                        if (tries_left-- <= 0) continue;
                        Thread.sleep(10000L);
                    }
                }
                IUser u = this.getUser("homeassistant");
                File f = this.getFile("config/ha_password");
                String password = StringFunctions.generateRandomKey();
                if (u == null) {
                    this.addUser("homeassistant", password, 1);
                    logger.info("created new ha user with {}", (Object)password);
                } else {
                    String USERS = KosmoSHelper.getEnv("USERS");
                    if (USERS != null) {
                        try {
                            JSONArray arr = new JSONArray(USERS);
                            for (int i = 0; i < arr.length(); ++i) {
                                JSONObject obj = arr.getJSONObject(i);
                                if (!obj.getString("username").equals("ha")) continue;
                                password = obj.getString("password");
                            }
                        }
                        catch (JSONException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (f.exists()) {
                        try {
                            password = de.kosmos_lab.utils.FileUtils.readFile((File)f);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        String salt = StringFunctions.generateRandomKey();
                        logger.info("updating ha pw to: {}", (Object)password);
                        this.setUserPassword(u, salt, this.getPasswordHash(password, salt));
                    }
                }
                de.kosmos_lab.utils.FileUtils.writeToFile((File)f, (String)password);
                String pw = password;
                HomeAssistantHTTPClient haclient = new HomeAssistantHTTPClient(habase, ha_user, ha_pass);
                JSONObject obj = new JSONObject().put("client_id", (Object)haclient.getBase()).put("name", (Object)"kosmos").put("username", (Object)haclient.getUser()).put("password", (Object)haclient.getPass()).put("language", (Object)"en");
                JSONObject result = haclient.postJSON("/api/onboarding/users", obj);
                if (!result.has("auth_code")) break block23;
                HashMap<String, Object> p = new HashMap<String, Object>();
                p.put("client_id", haclient.getBase());
                p.put("code", result.getString("auth_code"));
                p.put("grant_type", "authorization_code");
                result = new JSONObject(haclient.post("/auth/token", p));
                haclient.setToken(result.getString("access_token"));
                haclient.connect();
                var ref = new Object(){
                    ScheduledFuture<?> t = null;
                };
                ref.t = this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                    if (haclient.getWebSocket() != null && haclient.getWebSocket().isAuthed()) {
                        ref.t.cancel(false);
                    }
                }, 1000L, 100L, TimeUnit.MILLISECONDS);
                try {
                    ref.t.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
                haclient.sendCommand(new JSONObject().put("type", (Object)"config/core/update").put("location_name", (Object)"BAALL").put("latitude", 53.105944629013486).put("longitude", 8.85490268468857).put("elevation", 0).put("unit_system", (Object)"metric").put("time_zone", (Object)"Europe/Berlin"), (client, json) -> {});
                haclient.sendCommand(new JSONObject().put("type", (Object)"analytics/preferences").put("preferences", (Object)new JSONObject()), (client, json) -> {});
                haclient.sendCommand(new JSONObject().put("type", (Object)"subscribe_events").put("event_type", (Object)"state_changed"), (client, json) -> {});
                this.scheduledExecutorService.schedule(() -> {
                    JSONObject jsonResult = haclient.postJSON("/api/config/config_entries/flow", new JSONObject().put("handler", (Object)"kosmos").put("show_advanced_options", true));
                    String flow_id = jsonResult.getString("flow_id");
                    haclient.postJSON("/api/config/config_entries/flow/" + flow_id, new JSONObject().put("host", (Object)myhost).put("username", (Object)"homeassistant").put("password", (Object)pw));
                }, 10L, TimeUnit.SECONDS).get();
                if (KosmoSHelper.getEnvBool("SETUPKNX")) {
                    this.scheduledExecutorService.schedule(() -> {
                        JSONObject jsonResult = haclient.postJSON("/api/config/config_entries/flow", new JSONObject().put("handler", (Object)"knx").put("show_advanced_options", false));
                        String flow_id = jsonResult.getString("flow_id");
                        haclient.postJSON("/api/config/config_entries/flow/" + flow_id, new JSONObject().put("connection_type", (Object)"automatic"));
                    }, 10L, TimeUnit.SECONDS).get();
                }
                haclient.stop();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean shouldDeviceBeLogged(@Nonnull Device device) {
        Boolean v = this.logByDevice.get((Object)device);
        if (v != null) {
            return v;
        }
        for (String filter : this.logBlackListFilter) {
            if (!Wildcard.matches((String)filter, (String)device.getUniqueID())) continue;
            return false;
        }
        for (String filter : this.logWhiteListFilter) {
            if (!Wildcard.matches((String)filter, (String)device.getUniqueID())) continue;
            return true;
        }
        return true;
    }

    @Override
    public void stop() {
        for (CommandInterface t : this.commandInterfaces) {
            t.stop();
        }
        this.stopped = true;
    }

    @Override
    @CheckForNull
    public IUser tryLogin(@CheckForNull String user, @CheckForNull String pass) throws LoginFailedException {
        if (user == null || pass == null) {
            return null;
        }
        IUser u = this.getUser(user);
        if (u != null) {
            if (u.checkPassword(pass)) {
                return u;
            }
            logger.warn("user {} password mismatch!", (Object)user);
        } else {
            logger.warn("user {} not found!", (Object)user);
        }
        for (IAuthProvider provider : this.authProviders) {
            try {
                u = provider.tryLogin(user, pass);
                if (u == null) continue;
                return u;
            }
            catch (LoginFailedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (user.contains(":")) {
            return null;
        }
        return null;
    }

    @Override
    public void updateFromSource(@Nonnull CommandInterface from, @Nonnull CommandSourceName source, @Nonnull Device device, @Nonnull String property, Object value) throws ValidationException {
        if (device.set(property, value, true)) {
            this.publishUpdate(from, device, property, source);
        }
    }

    @Override
    public void updateFromSource(@Nonnull CommandInterface from, @Nonnull CommandSourceName source, @Nonnull String uuid, @Nonnull String property, @Nonnull Object value) throws ValidationException, DeviceNotFoundException {
        Device d = this.getDevice(uuid);
        if (d == null) {
            throw new DeviceNotFoundException(uuid);
        }
        this.updateFromSource(from, source, d, property, value);
    }

    @Override
    public void updateLastUpdate(@Nonnull Device device) {
        this.getPersistence().updateLastUpdate(device);
    }

    @Override
    @Nonnull
    public Device getDevice(@Nonnull String uuid, @Nonnull IUser user) throws DeviceNotFoundException, NoAccessToScope {
        return this.getDevice(uuid, user, Scope.ScopeType.read);
    }

    @Override
    @Nonnull
    public KosmosPluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    @Nonnull
    public Collection<ICamera> getAllCameras() {
        return this.cameras.values();
    }

    @Override
    @Nonnull
    public ICamera getCamera(@Nonnull String name) throws CameraNotFoundException {
        ICamera cam = this.cameras.get(name);
        if (cam != null) {
            return cam;
        }
        throw new CameraNotFoundException(name);
    }

    @Override
    public void startRecording(@Nonnull ICamera cam, @Nonnull IUser user) {
        if (!cam.isRecording()) {
            File f = this.getRecordingFile(cam, user);
            cam.startRecording(f);
            this.recordings.put(cam, user);
        }
    }

    @Nonnull
    @SuppressFBWarnings(value={"DM_EXIT"})
    private File getRecordingFile(@Nonnull ICamera cam, @Nonnull IUser user) {
        File f = this.getRecordingDir(user);
        if (!f.exists() && !f.mkdirs()) {
            logger.warn("could not create recording folder  \"{}\" - exiting", (Object)f);
            System.exit(1);
        }
        return new File(StringFunctions.format((String)"recordings/{user}/{cam}_{date}.mp4", Map.of("user", user.getUUID(), "cam", cam.getName(), "date", new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()))));
    }

    @Override
    public void stopRecording(@Nonnull ICamera cam, @Nonnull IUser user) throws NoAccessException {
        IUser recordingUser = this.recordings.get(cam);
        if (recordingUser != null) {
            if (!user.isAdmin() && !user.equals(recordingUser)) {
                throw new NoAccessException("you have no access here!");
            }
        } else {
            throw new NoAccessException("there is no recording running?!");
        }
        cam.stopRecording();
    }

    @Nonnull
    private String getRecordingDirString(@Nonnull IUser user) {
        return StringFunctions.format((String)"recordings/{user}", (Object[][])new Object[][]{{"user", user.getUUID()}});
    }

    @Nonnull
    private File getRecordingDir(@Nonnull IUser user) {
        return new File(this.getRecordingDirString(user));
    }

    @Override
    @Nonnull
    public Collection<File> listRecordings(@Nonnull ICamera cam, @Nonnull IUser user) {
        LinkedList<File> fileList = new LinkedList<File>();
        File dir = this.getRecordingDir(user);
        if (dir.exists()) {
            File[] files = dir.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                }
            });
            if (files != null) {
                for (File f : files) {
                    if (!f.getName().startsWith(cam.getName() + "_")) continue;
                    fileList.add(f);
                }
            }
        }
        return fileList;
    }

    @Override
    public byte[] getRecording(@Nonnull IUser user, @Nonnull String filename) throws NoAccessToRecording {
        File f = new File(this.getRecordingDirString(user) + "/" + filename);
        if (f.exists()) {
            try {
                return de.kosmos_lab.utils.FileUtils.readBinary((File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        throw new NoAccessToRecording();
    }

    @Override
    @Nonnull
    public Device getDevice(@Nonnull String uuid, @Nonnull IUser user, @Nonnull Scope.ScopeType scopeType) throws DeviceNotFoundException, NoAccessToScope {
        Device device = this.getDevice(uuid);
        switch (scopeType) {
            case read: {
                if (device.canRead(user)) {
                    return device;
                }
            }
            case write: {
                if (device.canWrite(user)) {
                    return device;
                }
            }
            case delete: {
                if (!device.canDel(user)) break;
                return device;
            }
        }
        throw new DeviceNotFoundException(uuid);
    }

    public MQTTBroker getMQTT() {
        return this.mqttBroker;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

