/*
 * Decompiled with CFR 0.152.
 */
package visualization_msgs.msg.dds;

import geometry_msgs.msg.dds.PosePubSubType;
import java.util.function.Supplier;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;
import visualization_msgs.msg.dds.InteractiveMarkerControl;
import visualization_msgs.msg.dds.InteractiveMarkerControlPubSubType;
import visualization_msgs.msg.dds.InteractiveMarkerPubSubType;
import visualization_msgs.msg.dds.MenuEntry;
import visualization_msgs.msg.dds.MenuEntryPubSubType;

public class InteractiveMarker
extends Packet<InteractiveMarker>
implements Settable<InteractiveMarker>,
EpsilonComparable<InteractiveMarker> {
    public Header header_ = new Header();
    public Pose3D pose_ = new Pose3D();
    public StringBuilder name_ = new StringBuilder(255);
    public StringBuilder description_ = new StringBuilder(255);
    public float scale_;
    public IDLSequence.Object<MenuEntry> menu_entries_ = new IDLSequence.Object(100, (TopicDataType)new MenuEntryPubSubType());
    public IDLSequence.Object<InteractiveMarkerControl> controls_ = new IDLSequence.Object(100, (TopicDataType)new InteractiveMarkerControlPubSubType());

    public InteractiveMarker() {
    }

    public InteractiveMarker(InteractiveMarker other) {
        this();
        this.set(other);
    }

    public void set(InteractiveMarker other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        PosePubSubType.staticCopy(other.pose_, this.pose_);
        this.name_.setLength(0);
        this.name_.append((CharSequence)other.name_);
        this.description_.setLength(0);
        this.description_.append((CharSequence)other.description_);
        this.scale_ = other.scale_;
        this.menu_entries_.set(other.menu_entries_);
        this.controls_.set(other.controls_);
    }

    public Header getHeader() {
        return this.header_;
    }

    public Pose3D getPose() {
        return this.pose_;
    }

    public void setName(String name) {
        this.name_.setLength(0);
        this.name_.append(name);
    }

    public String getNameAsString() {
        return this.getName().toString();
    }

    public StringBuilder getName() {
        return this.name_;
    }

    public void setDescription(String description) {
        this.description_.setLength(0);
        this.description_.append(description);
    }

    public String getDescriptionAsString() {
        return this.getDescription().toString();
    }

    public StringBuilder getDescription() {
        return this.description_;
    }

    public void setScale(float scale) {
        this.scale_ = scale;
    }

    public float getScale() {
        return this.scale_;
    }

    public IDLSequence.Object<MenuEntry> getMenuEntries() {
        return this.menu_entries_;
    }

    public IDLSequence.Object<InteractiveMarkerControl> getControls() {
        return this.controls_;
    }

    public static Supplier<InteractiveMarkerPubSubType> getPubSubType() {
        return InteractiveMarkerPubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return InteractiveMarkerPubSubType::new;
    }

    public boolean epsilonEquals(InteractiveMarker other, double epsilon) {
        int i;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!this.pose_.epsilonEquals(other.pose_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.name_, (StringBuilder)other.name_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.description_, (StringBuilder)other.description_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.scale_, (double)other.scale_, (double)epsilon)) {
            return false;
        }
        if (this.menu_entries_.size() != other.menu_entries_.size()) {
            return false;
        }
        for (i = 0; i < this.menu_entries_.size(); ++i) {
            if (((MenuEntry)((Object)this.menu_entries_.get(i))).epsilonEquals((MenuEntry)((Object)other.menu_entries_.get(i)), epsilon)) continue;
            return false;
        }
        if (this.controls_.size() != other.controls_.size()) {
            return false;
        }
        for (i = 0; i < this.controls_.size(); ++i) {
            if (((InteractiveMarkerControl)((Object)this.controls_.get(i))).epsilonEquals((InteractiveMarkerControl)((Object)other.controls_.get(i)), epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof InteractiveMarker)) {
            return false;
        }
        InteractiveMarker otherMyClass = (InteractiveMarker)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (!this.pose_.equals((Pose3DReadOnly)otherMyClass.pose_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.name_, (StringBuilder)otherMyClass.name_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.description_, (StringBuilder)otherMyClass.description_)) {
            return false;
        }
        if (this.scale_ != otherMyClass.scale_) {
            return false;
        }
        if (!this.menu_entries_.equals(otherMyClass.menu_entries_)) {
            return false;
        }
        return this.controls_.equals(otherMyClass.controls_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InteractiveMarker {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("pose=");
        builder.append(this.pose_);
        builder.append(", ");
        builder.append("name=");
        builder.append((CharSequence)this.name_);
        builder.append(", ");
        builder.append("description=");
        builder.append((CharSequence)this.description_);
        builder.append(", ");
        builder.append("scale=");
        builder.append(this.scale_);
        builder.append(", ");
        builder.append("menu_entries=");
        builder.append(this.menu_entries_);
        builder.append(", ");
        builder.append("controls=");
        builder.append(this.controls_);
        builder.append("}");
        return builder.toString();
    }
}

