/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;

public final class ByteBufDataType
implements DataType {
    public int compare(Object a, Object b) {
        return 0;
    }

    public int getMemory(Object obj) {
        if (!(obj instanceof ByteBuf)) {
            throw new IllegalArgumentException("Expected instance of ByteBuf but found " + obj.getClass());
        }
        int payloadSize = ((ByteBuf)obj).readableBytes();
        return 4 + payloadSize;
    }

    public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            obj[i] = this.read(buff);
        }
    }

    public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            this.write(buff, obj[i]);
        }
    }

    public ByteBuf read(ByteBuffer buff) {
        int payloadSize = buff.getInt();
        byte[] payload = new byte[payloadSize];
        buff.get(payload);
        return Unpooled.wrappedBuffer((byte[])payload);
    }

    public void write(WriteBuffer buff, Object obj) {
        ByteBuf casted = (ByteBuf)obj;
        int payloadSize = casted.readableBytes();
        byte[] rawBytes = new byte[payloadSize];
        casted.copy().readBytes(rawBytes).release();
        buff.putInt(payloadSize);
        buff.put(rawBytes);
    }
}

