/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import us.ihmc.commons.lists.RecyclingIterator;
import us.ihmc.commons.lists.SupplierBuilder;

public class RecyclingLinkedList<T> {
    public static final int defaultNumberOfElements = 16;
    private final Supplier<T> typeBuilder;
    private final List<Element> unusedElements = new ArrayList<Element>();
    private final BiConsumer<T, T> copier;
    private final List<RecyclingLinkedListIterator> iterators = new ArrayList<RecyclingLinkedListIterator>();
    private Element first;
    private Element last;
    private int size;

    public RecyclingLinkedList(Supplier<T> typeBuilder, BiConsumer<T, T> copier) {
        this(16, typeBuilder, copier);
    }

    public RecyclingLinkedList(Class<T> objectClass, BiConsumer<T, T> copier) {
        this(16, SupplierBuilder.createFromEmptyConstructor(objectClass), copier);
    }

    public RecyclingLinkedList(int numElements, Class<T> objectClass, BiConsumer<T, T> copier) {
        this(numElements, SupplierBuilder.createFromEmptyConstructor(objectClass), copier);
    }

    public RecyclingLinkedList(int numElements, Supplier<T> typeBuilder, BiConsumer<T, T> copier) {
        this.typeBuilder = typeBuilder;
        this.copier = copier;
        for (int i = 0; i < numElements; ++i) {
            this.unusedElements.add(new Element());
        }
    }

    public void addFirst(T object) {
        this.disableIterators();
        Element newFirst = this.get();
        this.copier.accept(newFirst.element, object);
        newFirst.next = this.first;
        this.first = newFirst;
        if (newFirst.next == null) {
            this.last = newFirst;
        } else {
            this.first.next.previous = this.first;
        }
        ++this.size;
    }

    public void addLast(T object) {
        this.disableIterators();
        Element newLast = this.get();
        this.copier.accept(newLast.element, object);
        newLast.previous = this.last;
        this.last = newLast;
        if (newLast.previous == null) {
            this.first = newLast;
        } else {
            this.last.previous.next = this.last;
        }
        ++this.size;
    }

    public void removeFirst() {
        this.removeFirst(null);
    }

    public void removeFirst(T objectToPack) {
        this.disableIterators();
        if (objectToPack != null) {
            this.peekFirst(objectToPack);
        }
        Element newFirst = this.first.next;
        this.release(this.first);
        this.first = newFirst;
        if (this.first == null) {
            this.last = null;
        }
        --this.size;
    }

    public void removeLast() {
        this.removeLast(null);
    }

    public void removeLast(T objectToPack) {
        this.disableIterators();
        if (objectToPack != null) {
            this.peekLast(objectToPack);
        }
        Element newLast = this.last.previous;
        this.release(this.last);
        this.last = newLast;
        if (this.last == null) {
            this.first = null;
        }
        --this.size;
    }

    public void peekFirst(T objectToPack) {
        if (this.first == null) {
            throw new NoSuchElementException();
        }
        this.copier.accept(objectToPack, this.first.element);
    }

    public void peekLast(T objectToPack) {
        if (this.last == null) {
            throw new NoSuchElementException();
        }
        this.copier.accept(objectToPack, this.last.element);
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.size;
    }

    public RecyclingIterator<T> createForwardIterator() {
        RecyclingLinkedListIterator ret = new RecyclingLinkedListIterator(false);
        this.iterators.add(ret);
        return ret;
    }

    public RecyclingIterator<T> createBackwardIterator() {
        RecyclingLinkedListIterator ret = new RecyclingLinkedListIterator(true);
        this.iterators.add(ret);
        return ret;
    }

    private void disableIterators() {
        for (int i = 0; i < this.iterators.size(); ++i) {
            this.iterators.get(i).informOfModification();
        }
    }

    private void release(Element element) {
        if (element.previous != null) {
            element.previous.next = null;
            element.previous = null;
        }
        if (element.next != null) {
            element.next.previous = null;
            element.next = null;
        }
        this.unusedElements.add(element);
    }

    private Element get() {
        if (this.unusedElements.isEmpty()) {
            return new Element();
        }
        return this.unusedElements.remove(this.unusedElements.size() - 1);
    }

    private class RecyclingLinkedListIterator
    implements RecyclingIterator<T> {
        private Element nextCursor;
        private boolean canIterate;
        private final boolean reverse;

        public RecyclingLinkedListIterator(boolean reverse) {
            this.nextCursor = RecyclingLinkedList.this.first;
            this.canIterate = true;
            this.reverse = reverse;
        }

        void informOfModification() {
            this.canIterate = false;
        }

        @Override
        public void reset() {
            this.nextCursor = this.reverse ? RecyclingLinkedList.this.last : RecyclingLinkedList.this.first;
            this.canIterate = true;
        }

        @Override
        public boolean hasNext() {
            if (!this.canIterate) {
                throw new ConcurrentModificationException();
            }
            return this.nextCursor != null;
        }

        @Override
        public void next(T objectToPack) {
            if (!this.canIterate) {
                throw new ConcurrentModificationException();
            }
            if (this.nextCursor == null) {
                throw new NoSuchElementException();
            }
            if (objectToPack != null) {
                RecyclingLinkedList.this.copier.accept(objectToPack, this.nextCursor.element);
            }
            this.nextCursor = this.reverse ? this.nextCursor.previous : this.nextCursor.next;
        }
    }

    private class Element {
        final T element;
        Element previous;
        Element next;

        private Element() {
            this.element = RecyclingLinkedList.this.typeBuilder.get();
            this.previous = null;
            this.next = null;
        }

        public String toString() {
            return "Value: " + this.element.toString() + (this.previous == null ? " (First)" : "") + (this.next == null ? " (Last)" : "");
        }
    }
}

