/*
 * Decompiled with CFR 0.152.
 */
package visualization_msgs.msg.dds;

import geometry_msgs.msg.dds.PointPubSubType;
import geometry_msgs.msg.dds.PosePubSubType;
import java.io.IOException;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import visualization_msgs.msg.dds.InteractiveMarkerFeedback;

public class InteractiveMarkerFeedbackPubSubType
implements TopicDataType<InteractiveMarkerFeedback> {
    public static final String name = "visualization_msgs::msg::dds_::InteractiveMarkerFeedback_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(InteractiveMarkerFeedback data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        InteractiveMarkerFeedbackPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, InteractiveMarkerFeedback data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        InteractiveMarkerFeedbackPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return InteractiveMarkerFeedbackPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += PosePubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += PointPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(InteractiveMarkerFeedback data) {
        return InteractiveMarkerFeedbackPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(InteractiveMarkerFeedback data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getClientId().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getMarkerName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getControlName().length() + 1;
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += PosePubSubType.getCdrSerializedSize(data.getPose(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += PointPubSubType.getCdrSerializedSize(data.getMousePoint(), current_alignment);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(InteractiveMarkerFeedback data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        if (data.getClientId().length() > 255) {
            throw new RuntimeException("client_id field exceeds the maximum length");
        }
        cdr.write_type_d(data.getClientId());
        if (data.getMarkerName().length() > 255) {
            throw new RuntimeException("marker_name field exceeds the maximum length");
        }
        cdr.write_type_d(data.getMarkerName());
        if (data.getControlName().length() > 255) {
            throw new RuntimeException("control_name field exceeds the maximum length");
        }
        cdr.write_type_d(data.getControlName());
        cdr.write_type_9(data.getEventType());
        PosePubSubType.write(data.getPose(), cdr);
        cdr.write_type_4(data.getMenuEntryId());
        PointPubSubType.write(data.getMousePoint(), cdr);
        cdr.write_type_7(data.getMousePointValid());
    }

    public static void read(InteractiveMarkerFeedback data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        cdr.read_type_d(data.getClientId());
        cdr.read_type_d(data.getMarkerName());
        cdr.read_type_d(data.getControlName());
        data.setEventType(cdr.read_type_9());
        PosePubSubType.read(data.getPose(), cdr);
        data.setMenuEntryId(cdr.read_type_4());
        PointPubSubType.read(data.getMousePoint(), cdr);
        data.setMousePointValid(cdr.read_type_7());
    }

    public final void serialize(InteractiveMarkerFeedback data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_d("client_id", data.getClientId());
        ser.write_type_d("marker_name", data.getMarkerName());
        ser.write_type_d("control_name", data.getControlName());
        ser.write_type_9("event_type", data.getEventType());
        ser.write_type_a("pose", (TopicDataType)new PosePubSubType(), (Object)data.getPose());
        ser.write_type_4("menu_entry_id", data.getMenuEntryId());
        ser.write_type_a("mouse_point", (TopicDataType)new PointPubSubType(), (Object)data.getMousePoint());
        ser.write_type_7("mouse_point_valid", data.getMousePointValid());
    }

    public final void deserialize(InterchangeSerializer ser, InteractiveMarkerFeedback data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_d("client_id", data.getClientId());
        ser.read_type_d("marker_name", data.getMarkerName());
        ser.read_type_d("control_name", data.getControlName());
        data.setEventType(ser.read_type_9("event_type"));
        ser.read_type_a("pose", (TopicDataType)new PosePubSubType(), (Object)data.getPose());
        data.setMenuEntryId(ser.read_type_4("menu_entry_id"));
        ser.read_type_a("mouse_point", (TopicDataType)new PointPubSubType(), (Object)data.getMousePoint());
        data.setMousePointValid(ser.read_type_7("mouse_point_valid"));
    }

    public static void staticCopy(InteractiveMarkerFeedback src, InteractiveMarkerFeedback dest) {
        dest.set(src);
    }

    public InteractiveMarkerFeedback createData() {
        return new InteractiveMarkerFeedback();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)InteractiveMarkerFeedbackPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(InteractiveMarkerFeedback data, CDR cdr) {
        InteractiveMarkerFeedbackPubSubType.write(data, cdr);
    }

    public void deserialize(InteractiveMarkerFeedback data, CDR cdr) {
        InteractiveMarkerFeedbackPubSubType.read(data, cdr);
    }

    public void copy(InteractiveMarkerFeedback src, InteractiveMarkerFeedback dest) {
        InteractiveMarkerFeedbackPubSubType.staticCopy(src, dest);
    }

    public InteractiveMarkerFeedbackPubSubType newInstance() {
        return new InteractiveMarkerFeedbackPubSubType();
    }
}

