/*
 * Decompiled with CFR 0.152.
 */
package sensor_msgs.msg.dds;

import java.util.function.Supplier;
import sensor_msgs.msg.dds.BatteryStatePubSubType;
import std_msgs.msg.dds.Header;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class BatteryState
extends Packet<BatteryState>
implements Settable<BatteryState>,
EpsilonComparable<BatteryState> {
    public static final byte POWER_SUPPLY_STATUS_UNKNOWN = 0;
    public static final byte POWER_SUPPLY_STATUS_CHARGING = 1;
    public static final byte POWER_SUPPLY_STATUS_DISCHARGING = 2;
    public static final byte POWER_SUPPLY_STATUS_NOT_CHARGING = 3;
    public static final byte POWER_SUPPLY_STATUS_FULL = 4;
    public static final byte POWER_SUPPLY_HEALTH_UNKNOWN = 0;
    public static final byte POWER_SUPPLY_HEALTH_GOOD = 1;
    public static final byte POWER_SUPPLY_HEALTH_OVERHEAT = 2;
    public static final byte POWER_SUPPLY_HEALTH_DEAD = 3;
    public static final byte POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4;
    public static final byte POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 5;
    public static final byte POWER_SUPPLY_HEALTH_COLD = 6;
    public static final byte POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 7;
    public static final byte POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 8;
    public static final byte POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0;
    public static final byte POWER_SUPPLY_TECHNOLOGY_NIMH = 1;
    public static final byte POWER_SUPPLY_TECHNOLOGY_LION = 2;
    public static final byte POWER_SUPPLY_TECHNOLOGY_LIPO = 3;
    public static final byte POWER_SUPPLY_TECHNOLOGY_LIFE = 4;
    public static final byte POWER_SUPPLY_TECHNOLOGY_NICD = 5;
    public static final byte POWER_SUPPLY_TECHNOLOGY_LIMN = 6;
    public Header header_ = new Header();
    public float voltage_;
    public float temperature_;
    public float current_;
    public float charge_;
    public float capacity_;
    public float design_capacity_;
    public float percentage_;
    public byte power_supply_status_;
    public byte power_supply_health_;
    public byte power_supply_technology_;
    public boolean present_;
    public IDLSequence.Float cell_voltage_ = new IDLSequence.Float(100, "type_5");
    public IDLSequence.Float cell_temperature_ = new IDLSequence.Float(100, "type_5");
    public StringBuilder location_ = new StringBuilder(255);
    public StringBuilder serial_number_ = new StringBuilder(255);

    public BatteryState() {
    }

    public BatteryState(BatteryState other) {
        this();
        this.set(other);
    }

    public void set(BatteryState other) {
        HeaderPubSubType.staticCopy(other.header_, this.header_);
        this.voltage_ = other.voltage_;
        this.temperature_ = other.temperature_;
        this.current_ = other.current_;
        this.charge_ = other.charge_;
        this.capacity_ = other.capacity_;
        this.design_capacity_ = other.design_capacity_;
        this.percentage_ = other.percentage_;
        this.power_supply_status_ = other.power_supply_status_;
        this.power_supply_health_ = other.power_supply_health_;
        this.power_supply_technology_ = other.power_supply_technology_;
        this.present_ = other.present_;
        this.cell_voltage_.set(other.cell_voltage_);
        this.cell_temperature_.set(other.cell_temperature_);
        this.location_.setLength(0);
        this.location_.append((CharSequence)other.location_);
        this.serial_number_.setLength(0);
        this.serial_number_.append((CharSequence)other.serial_number_);
    }

    public Header getHeader() {
        return this.header_;
    }

    public void setVoltage(float voltage) {
        this.voltage_ = voltage;
    }

    public float getVoltage() {
        return this.voltage_;
    }

    public void setTemperature(float temperature) {
        this.temperature_ = temperature;
    }

    public float getTemperature() {
        return this.temperature_;
    }

    public void setCurrent(float current) {
        this.current_ = current;
    }

    public float getCurrent() {
        return this.current_;
    }

    public void setCharge(float charge) {
        this.charge_ = charge;
    }

    public float getCharge() {
        return this.charge_;
    }

    public void setCapacity(float capacity) {
        this.capacity_ = capacity;
    }

    public float getCapacity() {
        return this.capacity_;
    }

    public void setDesignCapacity(float design_capacity) {
        this.design_capacity_ = design_capacity;
    }

    public float getDesignCapacity() {
        return this.design_capacity_;
    }

    public void setPercentage(float percentage) {
        this.percentage_ = percentage;
    }

    public float getPercentage() {
        return this.percentage_;
    }

    public void setPowerSupplyStatus(byte power_supply_status) {
        this.power_supply_status_ = power_supply_status;
    }

    public byte getPowerSupplyStatus() {
        return this.power_supply_status_;
    }

    public void setPowerSupplyHealth(byte power_supply_health) {
        this.power_supply_health_ = power_supply_health;
    }

    public byte getPowerSupplyHealth() {
        return this.power_supply_health_;
    }

    public void setPowerSupplyTechnology(byte power_supply_technology) {
        this.power_supply_technology_ = power_supply_technology;
    }

    public byte getPowerSupplyTechnology() {
        return this.power_supply_technology_;
    }

    public void setPresent(boolean present) {
        this.present_ = present;
    }

    public boolean getPresent() {
        return this.present_;
    }

    public IDLSequence.Float getCellVoltage() {
        return this.cell_voltage_;
    }

    public IDLSequence.Float getCellTemperature() {
        return this.cell_temperature_;
    }

    public void setLocation(String location) {
        this.location_.setLength(0);
        this.location_.append(location);
    }

    public String getLocationAsString() {
        return this.getLocation().toString();
    }

    public StringBuilder getLocation() {
        return this.location_;
    }

    public void setSerialNumber(String serial_number) {
        this.serial_number_.setLength(0);
        this.serial_number_.append(serial_number);
    }

    public String getSerialNumberAsString() {
        return this.getSerialNumber().toString();
    }

    public StringBuilder getSerialNumber() {
        return this.serial_number_;
    }

    public static Supplier<BatteryStatePubSubType> getPubSubType() {
        return BatteryStatePubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return BatteryStatePubSubType::new;
    }

    public boolean epsilonEquals(BatteryState other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.header_.epsilonEquals(other.header_, epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.voltage_, (double)other.voltage_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.temperature_, (double)other.temperature_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.current_, (double)other.current_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.charge_, (double)other.charge_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.capacity_, (double)other.capacity_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.design_capacity_, (double)other.design_capacity_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.percentage_, (double)other.percentage_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.power_supply_status_, (double)other.power_supply_status_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.power_supply_health_, (double)other.power_supply_health_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.power_supply_technology_, (double)other.power_supply_technology_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsBoolean((boolean)this.present_, (boolean)other.present_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsFloatSequence((IDLSequence.Float)this.cell_voltage_, (IDLSequence.Float)other.cell_voltage_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsFloatSequence((IDLSequence.Float)this.cell_temperature_, (IDLSequence.Float)other.cell_temperature_, (double)epsilon)) {
            return false;
        }
        if (!IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.location_, (StringBuilder)other.location_, (double)epsilon)) {
            return false;
        }
        return IDLTools.epsilonEqualsStringBuilder((StringBuilder)this.serial_number_, (StringBuilder)other.serial_number_, (double)epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof BatteryState)) {
            return false;
        }
        BatteryState otherMyClass = (BatteryState)((Object)other);
        if (!this.header_.equals((Object)otherMyClass.header_)) {
            return false;
        }
        if (this.voltage_ != otherMyClass.voltage_) {
            return false;
        }
        if (this.temperature_ != otherMyClass.temperature_) {
            return false;
        }
        if (this.current_ != otherMyClass.current_) {
            return false;
        }
        if (this.charge_ != otherMyClass.charge_) {
            return false;
        }
        if (this.capacity_ != otherMyClass.capacity_) {
            return false;
        }
        if (this.design_capacity_ != otherMyClass.design_capacity_) {
            return false;
        }
        if (this.percentage_ != otherMyClass.percentage_) {
            return false;
        }
        if (this.power_supply_status_ != otherMyClass.power_supply_status_) {
            return false;
        }
        if (this.power_supply_health_ != otherMyClass.power_supply_health_) {
            return false;
        }
        if (this.power_supply_technology_ != otherMyClass.power_supply_technology_) {
            return false;
        }
        if (this.present_ != otherMyClass.present_) {
            return false;
        }
        if (!this.cell_voltage_.equals((Object)otherMyClass.cell_voltage_)) {
            return false;
        }
        if (!this.cell_temperature_.equals((Object)otherMyClass.cell_temperature_)) {
            return false;
        }
        if (!IDLTools.equals((StringBuilder)this.location_, (StringBuilder)otherMyClass.location_)) {
            return false;
        }
        return IDLTools.equals((StringBuilder)this.serial_number_, (StringBuilder)otherMyClass.serial_number_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BatteryState {");
        builder.append("header=");
        builder.append((Object)this.header_);
        builder.append(", ");
        builder.append("voltage=");
        builder.append(this.voltage_);
        builder.append(", ");
        builder.append("temperature=");
        builder.append(this.temperature_);
        builder.append(", ");
        builder.append("current=");
        builder.append(this.current_);
        builder.append(", ");
        builder.append("charge=");
        builder.append(this.charge_);
        builder.append(", ");
        builder.append("capacity=");
        builder.append(this.capacity_);
        builder.append(", ");
        builder.append("design_capacity=");
        builder.append(this.design_capacity_);
        builder.append(", ");
        builder.append("percentage=");
        builder.append(this.percentage_);
        builder.append(", ");
        builder.append("power_supply_status=");
        builder.append(this.power_supply_status_);
        builder.append(", ");
        builder.append("power_supply_health=");
        builder.append(this.power_supply_health_);
        builder.append(", ");
        builder.append("power_supply_technology=");
        builder.append(this.power_supply_technology_);
        builder.append(", ");
        builder.append("present=");
        builder.append(this.present_);
        builder.append(", ");
        builder.append("cell_voltage=");
        builder.append(this.cell_voltage_);
        builder.append(", ");
        builder.append("cell_temperature=");
        builder.append(this.cell_temperature_);
        builder.append(", ");
        builder.append("location=");
        builder.append((CharSequence)this.location_);
        builder.append(", ");
        builder.append("serial_number=");
        builder.append((CharSequence)this.serial_number_);
        builder.append("}");
        return builder.toString();
    }
}

