/*
 * Decompiled with CFR 0.152.
 */
package nav_msgs.msg.dds;

import geometry_msgs.msg.dds.PoseStamped;
import geometry_msgs.msg.dds.PoseStampedPubSubType;
import java.io.IOException;
import nav_msgs.msg.dds.Path;
import std_msgs.msg.dds.HeaderPubSubType;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;

public class PathPubSubType
implements TopicDataType<Path> {
    public static final String name = "nav_msgs::msg::dds_::Path_";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public void serialize(Path data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        PathPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Path data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        PathPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return PathPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getMaxCdrSerializedSize(current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < 100; ++i0) {
            current_alignment += PoseStampedPubSubType.getMaxCdrSerializedSize(current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Path data) {
        return PathPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Path data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += HeaderPubSubType.getCdrSerializedSize(data.getHeader(), current_alignment);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        for (int i0 = 0; i0 < data.getPoses().size(); ++i0) {
            current_alignment += PoseStampedPubSubType.getCdrSerializedSize((PoseStamped)((Object)data.getPoses().get(i0)), current_alignment);
        }
        return current_alignment - initial_alignment;
    }

    public static void write(Path data, CDR cdr) {
        HeaderPubSubType.write(data.getHeader(), cdr);
        if (data.getPoses().size() > 100) {
            throw new RuntimeException("poses field exceeds the maximum length");
        }
        cdr.write_type_e(data.getPoses());
    }

    public static void read(Path data, CDR cdr) {
        HeaderPubSubType.read(data.getHeader(), cdr);
        cdr.read_type_e(data.getPoses());
    }

    public final void serialize(Path data, InterchangeSerializer ser) {
        ser.write_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.write_type_e("poses", data.getPoses());
    }

    public final void deserialize(InterchangeSerializer ser, Path data) {
        ser.read_type_a("header", (TopicDataType)new HeaderPubSubType(), (Object)data.getHeader());
        ser.read_type_e("poses", data.getPoses());
    }

    public static void staticCopy(Path src, Path dest) {
        dest.set(src);
    }

    public Path createData() {
        return new Path();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)PathPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Path data, CDR cdr) {
        PathPubSubType.write(data, cdr);
    }

    public void deserialize(Path data, CDR cdr) {
        PathPubSubType.read(data, cdr);
    }

    public void copy(Path src, Path dest) {
        PathPubSubType.staticCopy(src, dest);
    }

    public PathPubSubType newInstance() {
        return new PathPubSubType();
    }
}

