/*
 * Decompiled with CFR 0.152.
 */
package geometry_msgs.msg.dds;

import geometry_msgs.msg.dds.PosePubSubType;
import geometry_msgs.msg.dds.PoseWithCovariancePubSubType;
import java.util.Arrays;
import java.util.function.Supplier;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public class PoseWithCovariance
extends Packet<PoseWithCovariance>
implements Settable<PoseWithCovariance>,
EpsilonComparable<PoseWithCovariance> {
    public Pose3D pose_ = new Pose3D();
    public double[] covariance_ = new double[36];

    public PoseWithCovariance() {
    }

    public PoseWithCovariance(PoseWithCovariance other) {
        this();
        this.set(other);
    }

    public void set(PoseWithCovariance other) {
        PosePubSubType.staticCopy(other.pose_, this.pose_);
        for (int i1 = 0; i1 < this.covariance_.length; ++i1) {
            this.covariance_[i1] = other.covariance_[i1];
        }
    }

    public Pose3D getPose() {
        return this.pose_;
    }

    public double[] getCovariance() {
        return this.covariance_;
    }

    public static Supplier<PoseWithCovariancePubSubType> getPubSubType() {
        return PoseWithCovariancePubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return PoseWithCovariancePubSubType::new;
    }

    public boolean epsilonEquals(PoseWithCovariance other, double epsilon) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.pose_.epsilonEquals(other.pose_, epsilon)) {
            return false;
        }
        for (int i3 = 0; i3 < this.covariance_.length; ++i3) {
            if (IDLTools.epsilonEqualsPrimitive((double)this.covariance_[i3], (double)other.covariance_[i3], (double)epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof PoseWithCovariance)) {
            return false;
        }
        PoseWithCovariance otherMyClass = (PoseWithCovariance)((Object)other);
        if (!this.pose_.equals((Pose3DReadOnly)otherMyClass.pose_)) {
            return false;
        }
        for (int i5 = 0; i5 < this.covariance_.length; ++i5) {
            if (this.covariance_[i5] == otherMyClass.covariance_[i5]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PoseWithCovariance {");
        builder.append("pose=");
        builder.append(this.pose_);
        builder.append(", ");
        builder.append("covariance=");
        builder.append(Arrays.toString(this.covariance_));
        builder.append("}");
        return builder.toString();
    }
}

