/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server.servlets.openapi;

import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.server.WebServer;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import de.kosmos_lab.web.server.servlets.openapi.AsyncApiYamlServlet;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/doc/asyncapi.json", userLevel=-1)
public class AsyncApiJSONServlet
extends AsyncApiYamlServlet {
    public AsyncApiJSONServlet(WebServer webServer) {
        super(webServer);
    }

    @Override
    @Operation(tags={"asyncApi"}, summary="asyncapi.json", description="The generated asyncApi specification for this service in JSONObject format", responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="The generated asyncApi specification for this service")})
    public void get(BaseServletRequest request, HttpServletResponse response) throws IOException {
        String host = null;
        boolean export = request.getBoolean("export", false);
        try {
            host = request.getParameter("host", false);
        }
        catch (ParameterNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (host == null) {
            try {
                host = request.getRequest().getHeader("host");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (host != null) {
            AsyncApiJSONServlet.sendJSON(request, response, this.server.replaceHostName(this.server.getAsyncApiParser().getCachedJSON(), host));
        } else {
            AsyncApiJSONServlet.sendJSON(request, response, this.server.getAsyncApiParser().getCachedJSON());
        }
    }
}

