/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.web.server;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import de.kosmos_lab.utils.KosmosFileUtils;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.info.AsyncInfo;
import de.kosmos_lab.web.annotations.media.ArraySchema;
import de.kosmos_lab.web.annotations.media.ObjectSchema;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.servers.AsyncServer;
import de.kosmos_lab.web.annotations.tags.Tag;
import de.kosmos_lab.web.doc.openapi.Channel;
import de.kosmos_lab.web.doc.openapi.Message;
import de.kosmos_lab.web.doc.openapi.WebSocketEndpoint;
import de.kosmos_lab.web.server.Example;
import de.kosmos_lab.web.server.OpenApiParser;
import de.kosmos_lab.web.server.WebServer;
import de.kosmos_lab.web.server.WebSocketService;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.json.JSONArray;
import org.json.JSONObject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.LoggerFactory;

public class AsyncApiParser
extends OpenApiParser {
    private JSONObject json = null;
    private HashSet<Schema> schemas = new HashSet();
    private HashSet<ObjectSchema> oschemas = new HashSet();
    private HashSet<ArraySchema> aschemas = new HashSet();
    private HashSet<Parameter> parameters = new HashSet();
    private HashSet<Tag> tags = new HashSet();
    private ResourceBundle labels = null;
    private HashMap<String, JSONObject> mResponses = new HashMap();
    private JSONObject components;
    private LinkedList<Example> examples = new LinkedList();
    private JSONObject responses = new JSONObject();

    public AsyncApiParser(WebServer server) {
        super(server);
        File exampleFile = new File("config/examples-asyncapi.json");
        this.injectedExamples = null;
        if (exampleFile.exists()) {
            try {
                this.injectedExamples = new JSONObject(KosmosFileUtils.readFile((File)exampleFile));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public synchronized JSONObject getJSON() {
        if (this.json != null) {
            return this.json;
        }
        this.json = new JSONObject();
        ((Logger)LoggerFactory.getLogger((String)"org.reflections")).setLevel(Level.OFF);
        Reflections r = new Reflections("", new Scanner[0]);
        this.add("asyncapi", "2.4.0", this.json);
        JSONObject info = new JSONObject();
        AsyncInfo infoAnnotation = this.server.getClass().getAnnotation(AsyncInfo.class);
        if (infoAnnotation != null) {
            info = this.toJSON(infoAnnotation);
        }
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)new FileReader("pom.xml"));
            info.put("version", (Object)model.getVersion());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.add("info", info, this.json);
        this.components = new JSONObject();
        JSONObject securitySchemes = new JSONObject();
        this.add("securitySchemes", securitySchemes, this.components);
        JSONObject servers = new JSONObject();
        HashSet<Annotation> serverSet = new HashSet<Annotation>();
        JSONObject paths = new JSONObject();
        for (Class<? extends WebSocketService> c : this.server.getWebSocketServices()) {
            this.add("paths", paths, this.json);
            for (ObjectSchema objectSchema : (ObjectSchema[])c.getAnnotationsByType(ObjectSchema.class)) {
                this.oschemas.add(objectSchema);
            }
            for (Annotation annotation : (ArraySchema[])c.getAnnotationsByType(ArraySchema.class)) {
                this.aschemas.add((ArraySchema)annotation);
            }
            for (Annotation annotation : (Schema[])c.getAnnotationsByType(Schema.class)) {
                this.schemas.add((Schema)annotation);
            }
            for (Annotation annotation : (Parameter[])c.getAnnotationsByType(Parameter.class)) {
                this.parameters.add((Parameter)annotation);
            }
            for (Annotation annotation : (Tag[])c.getAnnotationsByType(Tag.class)) {
                this.tags.add((Tag)annotation);
            }
            Annotation[] annotationArray = (AsyncServer[])c.getAnnotationsByType(AsyncServer.class);
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation annotation = annotationArray[i];
                this.logger.info("found server {}", (Object)annotation);
                serverSet.add(annotation);
            }
        }
        for (AsyncServer s : (AsyncServer[])this.server.getClass().getAnnotationsByType(AsyncServer.class)) {
            this.logger.info("found server {}", (Object)s);
            serverSet.add(s);
        }
        for (Class c : r.getTypesAnnotatedWith(AsyncServer.class)) {
            for (AsyncServer asyncServer : (AsyncServer[])c.getAnnotationsByType(AsyncServer.class)) {
                serverSet.add(asyncServer);
            }
        }
        for (AsyncServer s : serverSet) {
            JSONObject j = new JSONObject();
            this.add("description", s.description(), j);
            this.add("url", s.url(), j);
            this.add("protocol", s.protocol(), j);
            servers.put(s.name(), (Object)j);
        }
        if (servers.length() == 0) {
            servers.put("default", (Object)new JSONObject().put("protocol", (Object)"wss").put("url", (Object)"wss://${host}").put("description", (Object)"current host"));
        }
        this.add("servers", servers, this.json);
        JSONObject schemajson = new JSONObject();
        JSONObject parametersjson = new JSONObject();
        JSONObject messages = new JSONObject();
        JSONObject channels = new JSONObject();
        for (Message message : (Message[])this.server.getClass().getAnnotationsByType(Message.class)) {
            this.logger.info("found {}", (Object)message);
            messages.put(message.name(), (Object)this.toJSON(message));
        }
        for (Class clazz : this.server.getWebSocketServices()) {
            WebSocketEndpoint a = clazz.getAnnotation(WebSocketEndpoint.class);
            if (a == null || a.hidden()) continue;
            this.logger.info("found {}", (Object)a);
            try {
                this.add(a, channels);
                for (Message message : (Message[])clazz.getAnnotationsByType(Message.class)) {
                    messages.put(message.name(), (Object)this.toJSON(message));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.add("channels", channels, this.json);
        for (ArraySchema arraySchema : this.aschemas) {
            this.add(arraySchema.name(), this.toJSON(arraySchema), schemajson);
        }
        for (ObjectSchema objectSchema : this.oschemas) {
            this.add(objectSchema.componentName(), this.toJSON(objectSchema), schemajson);
        }
        for (Schema schema : this.schemas) {
            this.add(schema.name(), schema, schemajson);
        }
        for (Parameter parameter : this.parameters) {
            String name = parameter.componentName();
            if (name.length() == 0) {
                name = parameter.name();
            }
            if (name.length() <= 0) continue;
            this.add(name, this.toJSON(parameter), parametersjson);
        }
        JSONArray tagarray = new JSONArray();
        for (Tag t : this.tags) {
            this.add(t, tagarray);
        }
        this.add("tags", tagarray, this.json);
        this.add("schemas", schemajson, this.components);
        this.add("parameters", parametersjson, this.components);
        this.add("messages", messages, this.components);
        this.add("components", this.components, this.json);
        this.checkExamples();
        return this.json;
    }

    private JSONObject toJSON(Message message) {
        JSONObject j;
        JSONObject j2;
        JSONObject json = new JSONObject();
        this.add("summary", message.summary(), json);
        this.add("description", message.description(), json);
        this.add("name", message.name(), json);
        this.add("title", message.title(), json);
        this.add("tags", message.tags(), json);
        JSONArray payloads = new JSONArray();
        JSONArray responses = new JSONArray();
        JSONArray examplesArray = this.getExamplesArray(message.examples());
        if (message.payload().properties().length > 0) {
            j2 = this.toJSON(message.payload());
            this.add("examples", this.getExamplesArray(message.payload().examples()), j2);
            payloads.put((Object)j2);
        }
        if (message.xResponse().properties().length > 0) {
            j2 = this.toJSON(message.xResponse());
            this.add("examples", this.getExamplesArray(message.xResponse().examples()), j2);
            responses.put((Object)j2);
        }
        for (Schema s : message.payloadSchema()) {
            if (s.ref().length() > 0) {
                payloads.put((Object)new JSONObject().put("$ref", (Object)s.ref()));
                continue;
            }
            if (s.type() == SchemaType.DEFAULT) continue;
            j = this.toJSON(s);
            this.add("examples", this.getExamplesArray(s.examples()), j);
            payloads.put((Object)j);
        }
        for (Schema s : message.xResponseSchema()) {
            if (s.ref().length() > 0) {
                responses.put((Object)new JSONObject().put("$ref", (Object)s.ref()));
                continue;
            }
            if (s.type() == SchemaType.DEFAULT) continue;
            j = this.toJSON(s);
            this.add("examples", this.getExamplesArray(s.examples()), j);
            responses.put((Object)j);
        }
        if (payloads.length() == 1) {
            json.put("payload", payloads.get(0));
        }
        if (payloads.length() > 1) {
            json.put("payload", (Object)new JSONObject().put("oneOf", (Object)payloads));
        }
        if (responses.length() == 1) {
            json.put("x-response", responses.get(0));
        }
        if (responses.length() > 1) {
            json.put("x-response", (Object)new JSONObject().put("oneOf", (Object)responses));
        }
        return json;
    }

    private void add(Channel channel, WebSocketEndpoint endpoint, JSONObject channels) {
        String path;
        JSONObject json = new JSONObject();
        JSONArray subscriptions = new JSONArray();
        JSONArray tagarray = new JSONArray();
        for (Tag t : channel.tags()) {
            this.add(t, tagarray);
        }
        for (String r : channel.subscribeRefs()) {
            subscriptions.put((Object)new JSONObject().put("$ref", (Object)r));
        }
        for (Message message : channel.subscribeMessages()) {
            subscriptions.put((Object)this.toJSON(message));
        }
        if (subscriptions.length() > 0) {
            JSONObject j = new JSONObject().put("message", (Object)new JSONObject().put("oneOf", (Object)subscriptions));
            if (tagarray.length() > 0) {
                j.put("tags", (Object)tagarray);
            }
            json.put("subscribe", (Object)j);
        }
        JSONArray publishes = new JSONArray();
        for (String r : channel.publishRefs()) {
            publishes.put((Object)new JSONObject().put("$ref", (Object)r));
        }
        for (Message message : channel.publishMessages()) {
            publishes.put((Object)this.toJSON(message));
        }
        if (publishes.length() > 0) {
            JSONObject j = new JSONObject().put("message", (Object)new JSONObject().put("oneOf", (Object)publishes));
            if (tagarray.length() > 0) {
                j.put("tags", (Object)tagarray);
            }
            json.put("publish", (Object)j);
        }
        if ((path = channel.path()).length() == 0) {
            path = endpoint.path();
        }
        if (channel.path().length() > 0) {
            JSONObject bindings = new JSONObject();
            if (endpoint.enableWS()) {
                JSONObject j = new JSONObject().put("path", (Object)endpoint.path());
                if (channel.needsMessage()) {
                    j.put("message", (Object)String.format("%s:{message}", channel.path()));
                }
                if (channel.userLevel() > -1) {
                    j.put("userLevel", channel.userLevel());
                    j.put("authRequired", true);
                }
                bindings.put("ws", (Object)j);
            }
            if (endpoint.enableMQTT()) {
                JSONObject j = new JSONObject().put("topic", (Object)channel.path());
                if (channel.needsMessage()) {
                    j.put("message", (Object)"{message}");
                }
                if (channel.userLevel() > -1) {
                    j.put("userLevel", channel.userLevel());
                    j.put("authRequired", true);
                }
                bindings.put("mqtt", (Object)j);
            }
            json.put("bindings", (Object)bindings);
        } else if (endpoint.path().length() > 0) {
            JSONObject bindings = new JSONObject();
            if (endpoint.enableWS()) {
                JSONObject j = new JSONObject().put("path", (Object)endpoint.path());
                if (channel.needsMessage()) {
                    j.put("message", (Object)"{message}");
                }
                bindings.put("ws", (Object)j);
            }
            if (endpoint.enableMQTT()) {
                JSONObject j = new JSONObject().put("topic", (Object)endpoint.path());
                if (channel.needsMessage()) {
                    j.put("message", (Object)"{message}");
                }
                bindings.put("mqtt", (Object)j);
            }
            json.put("bindings", (Object)bindings);
        }
        if (channel.parameters().length > 0) {
            JSONObject parametersjson = new JSONObject();
            for (Parameter p : channel.parameters()) {
                String name = p.componentName();
                if (name.length() == 0) {
                    name = p.name();
                }
                if (name.length() <= 0) continue;
                JSONObject j = this.toJSON(p);
                j.remove("in");
                j.remove("name");
                j.remove("required");
                this.add(name, j, parametersjson);
            }
            json.put("parameters", (Object)parametersjson);
        }
        this.add("description", channel.description(), json);
        channels.put(path, (Object)json);
    }

    private void add(WebSocketEndpoint endpoint, JSONObject channels) {
        for (Channel channel : endpoint.channels()) {
            this.add(channel, endpoint, channels);
        }
    }
}

