/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.yawPitchRoll.interfaces;

import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.YawPitchRollTools;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;

public interface YawPitchRollBasics
extends YawPitchRollReadOnly,
Orientation3DBasics {
    public void setYaw(double var1);

    public void setPitch(double var1);

    public void setRoll(double var1);

    default public void trimYaw() {
        this.setYaw(EuclidCoreTools.trimAngleMinusPiToPi(this.getYaw()));
    }

    default public void trimPitch() {
        this.setPitch(EuclidCoreTools.trimAngleMinusPiToPi(this.getPitch()));
    }

    default public void trimRoll() {
        this.setRoll(EuclidCoreTools.trimAngleMinusPiToPi(this.getRoll()));
    }

    @Override
    default public void setToZero() {
        this.set(0.0, 0.0, 0.0);
    }

    @Override
    default public void setToNaN() {
        this.set(Double.NaN, Double.NaN, Double.NaN);
    }

    @Override
    default public boolean containsNaN() {
        return YawPitchRollReadOnly.super.containsNaN();
    }

    default public void negate() {
        this.set(-this.getYaw(), -this.getPitch(), -this.getRoll());
    }

    default public void absolute() {
        this.set(Math.abs(this.getYaw()), Math.abs(this.getPitch()), Math.abs(this.getRoll()));
    }

    @Override
    default public void invert() {
        YawPitchRollTools.invert(this.getYaw(), this.getPitch(), this.getRoll(), this);
    }

    @Override
    default public void normalize() {
    }

    default public void set(double yaw, double pitch, double roll) {
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setRoll(roll);
    }

    @Override
    default public void set(Orientation3DReadOnly orientation3dReadOnly) {
        orientation3dReadOnly.get(this);
    }

    default public void set(YawPitchRollReadOnly other) {
        this.set(other.getYaw(), other.getPitch(), other.getRoll());
    }

    default public void setAndNegate(YawPitchRollReadOnly other) {
        this.set(other);
        this.negate();
    }

    default public void set(double[] yawPitchRollArray) {
        this.set(0, yawPitchRollArray);
    }

    default public void set(int startIndex, double[] yawPitchRollArray) {
        this.setYaw(yawPitchRollArray[startIndex++]);
        this.setPitch(yawPitchRollArray[startIndex++]);
        this.setRoll(yawPitchRollArray[startIndex]);
    }

    default public void set(float[] yawPitchRollArray) {
        this.set(0, yawPitchRollArray);
    }

    default public void set(int startIndex, float[] yawPitchRollArray) {
        this.setYaw(yawPitchRollArray[startIndex++]);
        this.setPitch(yawPitchRollArray[startIndex++]);
        this.setRoll(yawPitchRollArray[startIndex]);
    }

    @Override
    default public void setAxisAngle(double x, double y, double z, double angle) {
        YawPitchRollConversion.convertAxisAngleToYawPitchRoll(x, y, z, angle, this);
    }

    @Override
    default public void setQuaternion(double x, double y, double z, double s) {
        YawPitchRollConversion.convertQuaternionToYawPitchRoll(x, y, z, s, this);
    }

    @Override
    default public void setRotationVector(double x, double y, double z) {
        YawPitchRollConversion.convertRotationVectorToYawPitchRoll(x, y, z, this);
    }

    @Override
    default public void setYawPitchRoll(double yaw, double pitch, double roll) {
        this.set(yaw, pitch, roll);
    }

    @Override
    default public void setToYawOrientation(double yaw) {
        this.set(yaw, 0.0, 0.0);
    }

    @Override
    default public void setToPitchOrientation(double pitch) {
        this.set(0.0, pitch, 0.0);
    }

    @Override
    default public void setToRollOrientation(double roll) {
        this.set(0.0, 0.0, roll);
    }

    @Override
    default public void setRotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        YawPitchRollConversion.convertMatrixToYawPitchRoll(m00, m01, m02, m10, m11, m12, m20, m21, m22, this);
    }

    default public void setElement(int index, double value) {
        switch (index) {
            case 0: {
                this.setYaw(value);
                break;
            }
            case 1: {
                this.setPitch(value);
                break;
            }
            case 2: {
                this.setRoll(value);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
        }
    }

    default public void add(double yaw, double pitch, double roll) {
        this.set(yaw + this.getYaw(), pitch + this.getPitch(), roll + this.getRoll());
    }

    default public void addYaw(double yaw) {
        this.setYaw(yaw + this.getYaw());
    }

    default public void addPitch(double pitch) {
        this.setPitch(pitch + this.getPitch());
    }

    default public void addRoll(double roll) {
        this.setRoll(roll + this.getRoll());
    }

    @Override
    default public void append(Orientation3DReadOnly other) {
        YawPitchRollTools.multiply(this, false, other, false, this);
    }

    @Override
    default public void appendInvertOther(Orientation3DReadOnly orientation) {
        YawPitchRollTools.multiply(this, false, orientation, true, this);
    }

    @Override
    default public void appendYawRotation(double yaw) {
        YawPitchRollTools.appendYawRotation(this, yaw, this);
    }

    @Override
    default public void appendPitchRotation(double pitch) {
        YawPitchRollTools.appendPitchRotation(this, pitch, this);
    }

    @Override
    default public void appendRollRotation(double roll) {
        YawPitchRollTools.appendRollRotation(this, roll, this);
    }

    @Override
    default public void prepend(Orientation3DReadOnly orientation) {
        YawPitchRollTools.multiply(orientation, false, this, false, this);
    }

    @Override
    default public void prependInvertOther(Orientation3DReadOnly orientation) {
        YawPitchRollTools.multiply(orientation, true, this, false, this);
    }

    @Override
    default public void prependYawRotation(double yaw) {
        YawPitchRollTools.prependYawRotation(this, yaw, this);
    }

    @Override
    default public void prependPitchRotation(double pitch) {
        YawPitchRollTools.prependPitchRotation(this, pitch, this);
    }

    @Override
    default public void prependRollRotation(double roll) {
        YawPitchRollTools.prependRollRotation(this, roll, this);
    }
}

