/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;

public interface Tuple4DReadOnly {
    public double getX();

    public double getY();

    public double getZ();

    public double getS();

    default public float getX32() {
        return (float)this.getX();
    }

    default public float getY32() {
        return (float)this.getY();
    }

    default public float getZ32() {
        return (float)this.getZ();
    }

    default public float getS32() {
        return (float)this.getS();
    }

    default public boolean containsNaN() {
        return EuclidCoreTools.containsNaN(this.getX(), this.getY(), this.getZ(), this.getS());
    }

    default public double getElement(int index) {
        switch (index) {
            case 0: {
                return this.getX();
            }
            case 1: {
                return this.getY();
            }
            case 2: {
                return this.getZ();
            }
            case 3: {
                return this.getS();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    default public float getElement32(int index) {
        switch (index) {
            case 0: {
                return this.getX32();
            }
            case 1: {
                return this.getY32();
            }
            case 2: {
                return this.getZ32();
            }
            case 3: {
                return this.getS32();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    default public void get(double[] tupleArrayToPack) {
        this.get(0, tupleArrayToPack);
    }

    default public void get(int startIndex, double[] tupleArrayToPack) {
        tupleArrayToPack[startIndex++] = this.getX();
        tupleArrayToPack[startIndex++] = this.getY();
        tupleArrayToPack[startIndex++] = this.getZ();
        tupleArrayToPack[startIndex] = this.getS();
    }

    default public void get(float[] tupleArrayToPack) {
        this.get(0, tupleArrayToPack);
    }

    default public void get(int startIndex, float[] tupleArrayToPack) {
        tupleArrayToPack[startIndex++] = this.getX32();
        tupleArrayToPack[startIndex++] = this.getY32();
        tupleArrayToPack[startIndex++] = this.getZ32();
        tupleArrayToPack[startIndex] = this.getS32();
    }

    default public void get(DMatrix tupleMatrixToPack) {
        this.get(0, 0, tupleMatrixToPack);
    }

    default public void get(int startRow, DMatrix tupleMatrixToPack) {
        this.get(startRow, 0, tupleMatrixToPack);
    }

    default public void get(int startRow, int column, DMatrix tupleMatrixToPack) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 4, column + 1, (Matrix)tupleMatrixToPack);
        tupleMatrixToPack.unsafe_set(startRow++, column, this.getX());
        tupleMatrixToPack.unsafe_set(startRow++, column, this.getY());
        tupleMatrixToPack.unsafe_set(startRow++, column, this.getZ());
        tupleMatrixToPack.unsafe_set(startRow, column, this.getS());
    }

    default public double norm() {
        return EuclidCoreTools.squareRoot(this.normSquared());
    }

    default public double normSquared() {
        return this.dot(this);
    }

    default public double dot(Tuple4DReadOnly other) {
        return this.getX() * other.getX() + this.getY() * other.getY() + this.getZ() * other.getZ() + this.getS() * other.getS();
    }

    default public boolean epsilonEquals(Tuple4DReadOnly other, double epsilon) {
        return TupleTools.epsilonEquals(this, other, epsilon);
    }

    default public boolean equals(Tuple4DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ() && this.getS() == other.getS();
    }
}

