/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple3D;

import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;

public class UnitVector3D32
implements UnitVector3DBasics,
GeometryObject<UnitVector3D32> {
    private boolean dirty = true;
    private float x;
    private float y;
    private float z;

    public UnitVector3D32() {
        this.setToZero();
    }

    public UnitVector3D32(float x, float y, float z) {
        this.set(x, y, z);
    }

    public UnitVector3D32(float[] vectorArray) {
        this.set(vectorArray);
    }

    public UnitVector3D32(Tuple2DReadOnly tuple2DReadOnly) {
        this.set(tuple2DReadOnly);
    }

    public UnitVector3D32(Tuple3DReadOnly other) {
        this.set(other);
    }

    @Override
    public void absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
    }

    @Override
    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    @Override
    public void normalize() {
        if (this.dirty) {
            if (EuclidCoreTools.areAllZero(this.x, this.y, this.z, 1.0E-16)) {
                this.setToZero();
            } else {
                float lengthInverse = (float)(1.0 / EuclidCoreTools.fastNorm(this.x, this.y, this.z));
                this.x *= lengthInverse;
                this.y *= lengthInverse;
                this.z *= lengthInverse;
            }
            this.dirty = false;
        }
    }

    @Override
    public void markAsDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void set(UnitVector3D32 other) {
        this.set((UnitVector3DReadOnly)other);
    }

    @Override
    public void set(UnitVector3DReadOnly other) {
        this.x = (float)other.getRawX();
        this.y = (float)other.getRawY();
        this.z = (float)other.getRawZ();
        this.dirty = other.isDirty();
    }

    @Override
    public void setX(double x) {
        if ((double)this.x != x) {
            this.x = (float)x;
            this.markAsDirty();
        }
    }

    @Override
    public void setY(double y) {
        if ((double)this.y != y) {
            this.y = (float)y;
            this.markAsDirty();
        }
    }

    @Override
    public void setZ(double z) {
        if ((double)this.z != z) {
            this.z = (float)z;
            this.markAsDirty();
        }
    }

    @Override
    public double getRawX() {
        return this.x;
    }

    @Override
    public double getRawY() {
        return this.y;
    }

    @Override
    public double getRawZ() {
        return this.z;
    }

    @Override
    public boolean epsilonEquals(UnitVector3D32 other, double epsilon) {
        return UnitVector3DBasics.super.epsilonEquals(other, epsilon);
    }

    @Override
    public boolean geometricallyEquals(UnitVector3D32 other, double epsilon) {
        return UnitVector3DBasics.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof Tuple3DReadOnly) {
            return UnitVector3DBasics.super.equals((Tuple3DReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return EuclidCoreIOTools.getTuple3DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode(this.x, this.y, this.z);
    }
}

