/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D.interfaces;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public interface Vector2DBasics
extends Tuple2DBasics,
Vector2DReadOnly {
    default public void normalize() {
        if (this.containsNaN()) {
            return;
        }
        this.scale(1.0 / this.length());
    }

    default public void setAndNormalize(Vector2DReadOnly other) {
        this.set(other);
        this.normalize();
    }

    default public boolean clipToMaxLength(double maxLength) {
        if (maxLength < 1.0E-7) {
            this.setToZero();
            return true;
        }
        double lengthSquared = this.lengthSquared();
        if (lengthSquared < maxLength * maxLength) {
            return false;
        }
        this.scale(maxLength / EuclidCoreTools.squareRoot(lengthSquared));
        return true;
    }

    @Override
    default public void applyTransform(Transform transform) {
        transform.transform(this);
    }

    @Override
    default public void applyTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        transform.transform(this, checkIfTransformInXYPlane);
    }

    @Override
    default public void applyInverseTransform(Transform transform) {
        transform.inverseTransform(this);
    }

    @Override
    default public void applyInverseTransform(Transform transform, boolean checkIfTransformInXYplane) {
        transform.inverseTransform(this, checkIfTransformInXYplane);
    }
}

