/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D.interfaces;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public interface Point2DReadOnly
extends Tuple2DReadOnly {
    default public double distance(Point2DReadOnly other) {
        return EuclidCoreTools.squareRoot(this.distanceSquared(other));
    }

    default public double distanceSquared(Point2DReadOnly other) {
        double dx = this.getX() - other.getX();
        double dy = this.getY() - other.getY();
        return dx * dx + dy * dy;
    }

    default public double distanceXY(Point3DReadOnly point3DReadOnly) {
        return EuclidCoreTools.squareRoot(this.distanceXYSquared(point3DReadOnly));
    }

    default public double distanceXYSquared(Point3DReadOnly point3DReadOnly) {
        double dx = this.getX() - point3DReadOnly.getX();
        double dy = this.getY() - point3DReadOnly.getY();
        return EuclidCoreTools.normSquared(dx, dy);
    }

    default public double distanceFromOrigin() {
        return EuclidCoreTools.squareRoot(this.distanceFromOriginSquared());
    }

    default public double distanceFromOriginSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    default public boolean geometricallyEquals(Point2DReadOnly other, double epsilon) {
        return this.distance(other) <= epsilon;
    }
}

