/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform.interfaces;

import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface RigidBodyTransformBasics
extends RigidBodyTransformReadOnly,
Clearable {
    @Override
    public Orientation3DBasics getRotation();

    @Override
    public Tuple3DBasics getTranslation();

    @Override
    default public boolean containsNaN() {
        return RigidBodyTransformReadOnly.super.containsNaN();
    }

    @Override
    default public void setToZero() {
        this.getRotation().setToZero();
        this.getTranslation().setToZero();
    }

    default public void setRotationToZero() {
        this.getRotation().setToZero();
    }

    default public void setTranslationToZero() {
        this.getTranslation().setToZero();
    }

    @Override
    default public void setToNaN() {
        this.getRotation().setToNaN();
        this.getTranslation().setToNaN();
    }

    default public void setRotationToNaN() {
        this.getRotation().setToNaN();
    }

    default public void setTranslationToNaN() {
        this.getTranslation().setToNaN();
    }

    default public void invert() {
        this.getRotation().invert();
        if (this.hasTranslation()) {
            this.getRotation().transform(this.getTranslation());
        }
        this.getTranslation().negate();
    }

    default public void invertRotation() {
        this.getRotation().invert();
    }

    default public void normalizeRotationPart() {
        this.getRotation().normalize();
    }

    default public void set(RigidBodyTransformReadOnly other) {
        this.getRotation().set(other.getRotation());
        this.getTranslation().set(other.getTranslation());
    }

    default public void set(AffineTransformReadOnly affineTransform) {
        this.getRotation().set(affineTransform.getLinearTransform().getAsQuaternion());
        this.getTranslation().set(affineTransform.getTranslation());
    }

    default public void setAndInvert(RigidBodyTransformReadOnly other) {
        this.set(other);
        this.invert();
    }

    default public void set(RotationMatrixReadOnly rotationMatrix, Tuple3DReadOnly translation) {
        this.getRotation().set(rotationMatrix);
        this.getTranslation().set(translation);
    }

    default public void set(Orientation3DReadOnly orientation, Tuple3DReadOnly translation) {
        this.getRotation().set(orientation);
        this.getTranslation().set(translation);
    }

    @Deprecated
    default public void setRotation(Orientation3DReadOnly orientation) {
        this.getRotation().set(orientation);
    }

    @Deprecated
    default public void setRotation(Vector3DReadOnly rotationVector) {
        this.getRotation().setRotationVector(rotationVector);
    }

    @Deprecated
    default public void setRotation(RotationMatrixReadOnly rotationMatrix) {
        this.getRotation().set(rotationMatrix);
    }

    @Deprecated
    default public void setRotationYaw(double yaw) {
        this.getRotation().setToYawOrientation(yaw);
    }

    @Deprecated
    default public void setRotationPitch(double pitch) {
        this.getRotation().setToPitchOrientation(pitch);
    }

    @Deprecated
    default public void setRotationRoll(double roll) {
        this.getRotation().setToRollOrientation(roll);
    }

    @Deprecated
    default public void setRotationYawPitchRoll(double yaw, double pitch, double roll) {
        this.getRotation().setYawPitchRoll(yaw, pitch, roll);
    }

    @Deprecated
    default public void setRotationEuler(Vector3DReadOnly eulerAngles) {
        this.getRotation().setEuler(eulerAngles);
    }

    @Deprecated
    default public void setRotationEuler(double rotX, double rotY, double rotZ) {
        this.getRotation().setEuler(rotX, rotY, rotZ);
    }

    default public void setRotationAndZeroTranslation(Orientation3DReadOnly orientation) {
        this.getRotation().set(orientation);
        this.setTranslationToZero();
    }

    default public void setRotationAndZeroTranslation(RotationMatrixReadOnly rotationMatrix) {
        this.getRotation().set(rotationMatrix);
        this.setTranslationToZero();
    }

    default public void setRotationAndZeroTranslation(Vector3DReadOnly rotationVector) {
        this.getRotation().setRotationVector(rotationVector);
        this.setTranslationToZero();
    }

    default public void setRotationYawAndZeroTranslation(double yaw) {
        this.getRotation().setToYawOrientation(yaw);
        this.setTranslationToZero();
    }

    default public void setRotationPitchAndZeroTranslation(double pitch) {
        this.getRotation().setToPitchOrientation(pitch);
        this.setTranslationToZero();
    }

    default public void setRotationRollAndZeroTranslation(double roll) {
        this.getRotation().setToRollOrientation(roll);
        this.setTranslationToZero();
    }

    default public void setRotationYawPitchRollAndZeroTranslation(double yaw, double pitch, double roll) {
        this.getRotation().setYawPitchRoll(yaw, pitch, roll);
        this.setTranslationToZero();
    }

    default public void setRotationEulerAndZeroTranslation(Vector3DReadOnly eulerAngles) {
        this.getRotation().setEuler(eulerAngles);
        this.setTranslationToZero();
    }

    default public void setRotationEulerAndZeroTranslation(double rotX, double rotY, double rotZ) {
        this.getRotation().setEuler(rotX, rotY, rotZ);
        this.setTranslationToZero();
    }

    @Deprecated
    default public void setTranslationX(double x) {
        this.getTranslation().setX(x);
    }

    @Deprecated
    default public void setTranslationY(double y) {
        this.getTranslation().setY(y);
    }

    @Deprecated
    default public void setTranslationZ(double z) {
        this.getTranslation().setZ(z);
    }

    @Deprecated
    default public void setTranslation(double x, double y, double z) {
        this.getTranslation().set(x, y, z);
    }

    @Deprecated
    default public void setTranslation(Tuple3DReadOnly translation) {
        this.getTranslation().set(translation);
    }

    default public void setTranslationAndIdentityRotation(double x, double y, double z) {
        this.getTranslation().set(x, y, z);
        this.setRotationToZero();
    }

    default public void setTranslationAndIdentityRotation(Tuple3DReadOnly translation) {
        this.getTranslation().set(translation);
        this.setRotationToZero();
    }

    default public void multiply(RigidBodyTransformReadOnly other) {
        if (other.hasTranslation()) {
            this.getRotation().addTransform(other.getTranslation(), this.getTranslation());
        }
        this.getRotation().append(other.getRotation());
    }

    default public void multiply(AffineTransformReadOnly affineTransform) {
        if (affineTransform.hasTranslation()) {
            this.getRotation().addTransform(affineTransform.getTranslation(), this.getTranslation());
        }
        this.getRotation().append(affineTransform.getLinearTransform().getAsQuaternion());
    }

    default public void multiplyInvertThis(RigidBodyTransformReadOnly other) {
        this.invert();
        this.multiply(other);
    }

    default public void multiplyInvertOther(RigidBodyTransformReadOnly other) {
        this.getRotation().appendInvertOther(other.getRotation());
        if (other.hasTranslation()) {
            this.getRotation().subTransform(other.getTranslation(), this.getTranslation());
        }
    }

    default public void multiplyInvertThis(AffineTransformReadOnly affineTransform) {
        this.invert();
        this.multiply(affineTransform);
    }

    default public void multiplyInvertOther(AffineTransformReadOnly affineTransform) {
        this.getRotation().appendInvertOther(affineTransform.getLinearTransform().getAsQuaternion());
        this.getRotation().subTransform(affineTransform.getTranslation(), this.getTranslation());
    }

    default public void appendTranslation(Tuple3DReadOnly translation) {
        this.getRotation().addTransform(translation, this.getTranslation());
    }

    default public void appendTranslation(double x, double y, double z) {
        double thisX = this.getTranslation().getX();
        double thisY = this.getTranslation().getY();
        double thisZ = this.getTranslation().getZ();
        this.getTranslation().set(x, y, z);
        this.getRotation().transform(this.getTranslation());
        this.getTranslation().add(thisX, thisY, thisZ);
    }

    default public void appendOrientation(Orientation3DReadOnly orientation) {
        this.getRotation().append(orientation);
    }

    default public void appendYawRotation(double yaw) {
        this.getRotation().appendYawRotation(yaw);
    }

    default public void appendPitchRotation(double pitch) {
        this.getRotation().appendPitchRotation(pitch);
    }

    default public void appendRollRotation(double roll) {
        this.getRotation().appendRollRotation(roll);
    }

    default public void preMultiply(RigidBodyTransformReadOnly other) {
        if (this.hasTranslation()) {
            other.getRotation().transform(this.getTranslation());
            this.getTranslation().add(other.getTranslation());
        } else {
            this.getTranslation().set(other.getTranslation());
        }
        this.getRotation().prepend(other.getRotation());
    }

    default public void preMultiply(AffineTransformReadOnly affineTransform) {
        affineTransform.getLinearTransform().getAsQuaternion().transform(this.getTranslation());
        this.getTranslation().add(affineTransform.getTranslation());
        this.getRotation().prepend(affineTransform.getLinearTransform().getAsQuaternion());
    }

    default public void preMultiplyInvertThis(RigidBodyTransformReadOnly other) {
        this.invert();
        this.preMultiply(other);
    }

    default public void preMultiplyInvertOther(RigidBodyTransformReadOnly other) {
        this.getTranslation().sub(other.getTranslation());
        if (this.hasTranslation()) {
            other.getRotation().inverseTransform(this.getTranslation());
        }
        this.getRotation().prependInvertOther(other.getRotation());
    }

    default public void preMultiplyInvertThis(AffineTransformReadOnly affineTransform) {
        this.invert();
        this.preMultiply(affineTransform);
    }

    default public void preMultiplyInvertOther(AffineTransformReadOnly affineTransform) {
        this.getTranslation().sub(affineTransform.getTranslation());
        affineTransform.getLinearTransform().getAsQuaternion().inverseTransform(this.getTranslation());
        this.getRotation().prependInvertOther(affineTransform.getLinearTransform().getAsQuaternion());
    }

    default public void prependTranslation(Tuple3DReadOnly translation) {
        this.getTranslation().add(translation);
    }

    default public void prependTranslation(double x, double y, double z) {
        this.getTranslation().add(x, y, z);
    }

    default public void prependOrientation(Orientation3DReadOnly orientation) {
        orientation.transform(this.getTranslation());
        this.getRotation().prepend(orientation);
    }

    default public void prependYawRotation(double yaw) {
        RotationMatrixTools.applyYawRotation(yaw, this.getTranslation(), this.getTranslation());
        this.getRotation().prependYawRotation(yaw);
    }

    default public void prependPitchRotation(double pitch) {
        RotationMatrixTools.applyPitchRotation(pitch, this.getTranslation(), this.getTranslation());
        this.getRotation().prependPitchRotation(pitch);
    }

    default public void prependRollRotation(double roll) {
        RotationMatrixTools.applyRollRotation(roll, this.getTranslation(), this.getTranslation());
        this.getRotation().prependRollRotation(roll);
    }
}

