/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import us.ihmc.euclid.exceptions.SingularMatrixException;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;

public class SingularValueDecomposition3D {
    static final double gamma = 3.0 + 2.0 * EuclidCoreTools.squareRoot(2.0);
    static final double cosPiOverEight = EuclidCoreTools.cos(0.39269908169872414);
    static final double sinPiOverEight = EuclidCoreTools.sin(0.39269908169872414);
    static final double sqrtTwoOverTwo = EuclidCoreTools.squareRoot(2.0) / 2.0;
    private final Matrix3D temp = new Matrix3D();
    private final SVD3DOutput output = new SVD3DOutput();
    private int maxIterations = 25;
    private double tolerance = 1.0E-13;
    private boolean sortDescendingOrder = true;
    private int iterations = -1;

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public void setSortDescendingOrder(boolean sortDescendingOrder) {
        this.sortDescendingOrder = sortDescendingOrder;
    }

    public boolean decompose(Matrix3DReadOnly A) {
        double a22;
        double a21;
        double a20;
        double a12;
        double a11;
        double a10;
        double a02;
        double a01;
        double scale = A.maxAbsElement();
        double a00 = A.getM00() / scale;
        if (!this.computeV(a00, a01 = A.getM01() / scale, a02 = A.getM02() / scale, a10 = A.getM10() / scale, a11 = A.getM11() / scale, a12 = A.getM12() / scale, a20 = A.getM20() / scale, a21 = A.getM21() / scale, a22 = A.getM22() / scale)) {
            return false;
        }
        this.computeUW(a00, a01, a02, a10, a11, a12, a20, a21, a22);
        this.output.W.scale(scale);
        return true;
    }

    private boolean computeV(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22) {
        Matrix3D S = this.temp;
        S.set(a00, a01, a02, a10, a11, a12, a20, a21, a22);
        S.multiplyInner();
        this.iterations = SingularValueDecomposition3D.computeV(S, this.output.V, this.maxIterations, this.tolerance);
        return this.iterations < this.maxIterations;
    }

    static int computeV(Matrix3DBasics S, QuaternionBasics V, int maxIterations, double tolerance) {
        int iteration;
        V.setToZero();
        for (iteration = 0; iteration < maxIterations; ++iteration) {
            double a_01_abs = Math.abs(S.getM01());
            double a_02_abs = Math.abs(S.getM02());
            double a_12_abs = Math.abs(S.getM12());
            if (a_01_abs > a_02_abs) {
                if (a_01_abs > a_12_abs) {
                    if (a_01_abs <= tolerance * Math.abs(S.getM00()) * Math.abs(S.getM11())) break;
                    SingularValueDecomposition3D.approxGivensQuaternion(0, 1, S, V);
                    continue;
                }
                if (a_12_abs <= tolerance * Math.abs(S.getM11()) * Math.abs(S.getM22())) break;
                SingularValueDecomposition3D.approxGivensQuaternion(1, 2, S, V);
                continue;
            }
            if (a_02_abs > a_12_abs) {
                if (a_02_abs <= tolerance * Math.abs(S.getM00()) * Math.abs(S.getM22())) break;
                SingularValueDecomposition3D.approxGivensQuaternion(0, 2, S, V);
                continue;
            }
            if (a_12_abs <= tolerance * Math.abs(S.getM11()) * Math.abs(S.getM22())) break;
            SingularValueDecomposition3D.approxGivensQuaternion(1, 2, S, V);
        }
        if (iteration > 0) {
            V.normalize();
        }
        return iteration;
    }

    static void approxGivensQuaternion(int p, int q, Matrix3DBasics SToUpdate, QuaternionBasics QToUpdate) {
        double s_qq;
        double s_pq;
        double s_pp;
        if (p == 0) {
            if (q == 1) {
                s_pp = SToUpdate.getM00();
                s_pq = SToUpdate.getM01();
                s_qq = SToUpdate.getM11();
            } else {
                s_pp = SToUpdate.getM00();
                s_pq = SToUpdate.getM02();
                s_qq = SToUpdate.getM22();
            }
        } else {
            s_pp = SToUpdate.getM11();
            s_pq = SToUpdate.getM12();
            s_qq = SToUpdate.getM22();
        }
        double ch = 2.0 * (s_pp - s_qq);
        double sh = s_pq;
        if (gamma * sh * sh < ch * ch) {
            double omega = 1.0 / EuclidCoreTools.squareRoot(ch * ch + sh * sh);
            ch *= omega;
            sh *= omega;
        } else {
            ch = cosPiOverEight;
            sh = sinPiOverEight;
        }
        if (p == 0) {
            if (q == 1) {
                SingularValueDecomposition3D.prependGivensQuaternionZ(ch, sh, QToUpdate);
                SingularValueDecomposition3D.applyJacobiGivensRotationZ(ch, sh, SToUpdate);
            } else {
                SingularValueDecomposition3D.prependGivensQuaternionY(ch, sh, QToUpdate);
                SingularValueDecomposition3D.applyJacobiGivensRotationY(ch, sh, SToUpdate);
            }
        } else {
            SingularValueDecomposition3D.prependGivensQuaternionX(ch, sh, QToUpdate);
            SingularValueDecomposition3D.applyJacobiGivensRotationX(ch, sh, SToUpdate);
        }
    }

    private void computeUW(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22) {
        Matrix3D B = this.temp;
        this.computeB(a00, a01, a02, a10, a11, a12, a20, a21, a22, this.output.V, B);
        if (this.sortDescendingOrder) {
            SingularValueDecomposition3D.sortBColumns(B, this.output.V);
        }
        this.output.U.setToZero();
        boolean isUquatInitialized = false;
        if (!EuclidCoreTools.isZero(B.getM10(), this.tolerance * Math.abs(B.getM00()) * Math.abs(B.getM11())) || B.getM00() < 0.0) {
            SingularValueDecomposition3D.qrGivensQuaternion(1, 0, B, this.output.U, this.tolerance);
            isUquatInitialized = true;
        }
        if (!EuclidCoreTools.isZero(B.getM20(), this.tolerance * Math.abs(B.getM22()) * Math.abs(B.getM00())) || B.getM11() < 0.0) {
            SingularValueDecomposition3D.qrGivensQuaternion(2, 0, B, this.output.U, this.tolerance);
            isUquatInitialized = true;
        }
        if (!EuclidCoreTools.isZero(B.getM21(), this.tolerance * Math.abs(B.getM22()) * Math.abs(B.getM11())) || B.getM11() < 0.0) {
            SingularValueDecomposition3D.qrGivensQuaternion(2, 1, B, this.output.U, this.tolerance);
            isUquatInitialized = true;
        }
        this.output.W.set(B.getM00(), B.getM11(), B.getM22());
        if (isUquatInitialized) {
            this.output.U.normalize();
        }
    }

    private void computeB(double a00, double a01, double a02, double a10, double a11, double a12, double a20, double a21, double a22, Quaternion V, Matrix3D BToPack) {
        double qx = V.getX();
        double qy = V.getY();
        double qz = V.getZ();
        double qs = V.getS();
        double yy2 = 2.0 * qy * qy;
        double zz2 = 2.0 * qz * qz;
        double xx2 = 2.0 * qx * qx;
        double xy2 = 2.0 * qx * qy;
        double sz2 = 2.0 * qs * qz;
        double xz2 = 2.0 * qx * qz;
        double sy2 = 2.0 * qs * qy;
        double yz2 = 2.0 * qy * qz;
        double sx2 = 2.0 * qs * qx;
        double m00 = 1.0 - yy2 - zz2;
        double m01 = xy2 - sz2;
        double m02 = xz2 + sy2;
        double m10 = xy2 + sz2;
        double m11 = 1.0 - xx2 - zz2;
        double m12 = yz2 - sx2;
        double m20 = xz2 - sy2;
        double m21 = yz2 + sx2;
        double m22 = 1.0 - xx2 - yy2;
        double b00 = a00 * m00 + a01 * m10 + a02 * m20;
        double b01 = a00 * m01 + a01 * m11 + a02 * m21;
        double b02 = a00 * m02 + a01 * m12 + a02 * m22;
        double b10 = a10 * m00 + a11 * m10 + a12 * m20;
        double b11 = a10 * m01 + a11 * m11 + a12 * m21;
        double b12 = a10 * m02 + a11 * m12 + a12 * m22;
        double b20 = a20 * m00 + a21 * m10 + a22 * m20;
        double b21 = a20 * m01 + a21 * m11 + a22 * m21;
        double b22 = a20 * m02 + a21 * m12 + a22 * m22;
        BToPack.set(b00, b01, b02, b10, b11, b12, b20, b21, b22);
    }

    private static void qrGivensQuaternion(int p, int q, Matrix3DBasics B, QuaternionBasics UToUpdate, double epsilon) {
        double sh;
        double ch;
        double a1 = B.getElement(q, q);
        double a2 = B.getElement(p, q);
        double rho = EuclidCoreTools.squareRoot(a1 * a1 + a2 * a2);
        if (a1 < 0.0) {
            ch = rho > epsilon ? a2 : 0.0;
            sh = -a1 + Math.max(rho, epsilon);
        } else {
            ch = a1 + Math.max(rho, epsilon);
            sh = rho > epsilon ? a2 : 0.0;
        }
        double omega = 1.0 / EuclidCoreTools.squareRoot(ch * ch + sh * sh);
        ch *= omega;
        sh *= omega;
        if (q == 0) {
            if (p == 1) {
                SingularValueDecomposition3D.appendGivensQuaternionZ(ch, sh, UToUpdate);
                SingularValueDecomposition3D.applyQRGivensRotationZ(ch, sh, B);
            } else {
                SingularValueDecomposition3D.appendGivensQuaternionY(ch, sh, UToUpdate);
                SingularValueDecomposition3D.applyQRGivensRotationY(ch, sh, B);
            }
        } else {
            SingularValueDecomposition3D.appendGivensQuaternionX(ch, sh, UToUpdate);
            SingularValueDecomposition3D.applyQRGivensRotationX(ch, sh, B);
        }
    }

    static void applyJacobiGivensRotationX(double ch, double sh, Matrix3DBasics S) {
        double ch2 = ch * ch;
        double sh2 = sh * sh;
        double diag_a = ch2 + sh2;
        double diag_b = (ch2 - sh2) / diag_a;
        double off_diag = 2.0 * ch * sh / diag_a;
        double s00 = S.getM00();
        double s11 = S.getM11();
        double s22 = S.getM22();
        double s01 = S.getM01();
        double s02 = S.getM02();
        double s12 = S.getM12();
        double qTs11 = diag_b * s11 + off_diag * s12;
        double qTs22 = diag_b * s22 - off_diag * s12;
        double qTs12 = diag_b * s12 + off_diag * s22;
        double qTs21 = diag_b * s12 - off_diag * s11;
        double qTsq11 = qTs11 * diag_b + qTs12 * off_diag;
        double qTsq22 = qTs22 * diag_b - qTs21 * off_diag;
        double qTsq01 = s01 * diag_b + s02 * off_diag;
        double qTsq02 = s02 * diag_b - s01 * off_diag;
        double qTsq12 = qTs12 * diag_b - qTs11 * off_diag;
        S.set(s00, qTsq01, qTsq02, qTsq01, qTsq11, qTsq12, qTsq02, qTsq12, qTsq22);
    }

    static void applyJacobiGivensRotationY(double ch, double sh, Matrix3DBasics S) {
        double ch2 = ch * ch;
        double sh2 = sh * sh;
        double diag_a = ch2 + sh2;
        double diag_b = (ch2 - sh2) / diag_a;
        double off_diag = 2.0 * ch * sh / diag_a;
        double s00 = S.getM00();
        double s11 = S.getM11();
        double s22 = S.getM22();
        double s01 = S.getM01();
        double s02 = S.getM02();
        double s12 = S.getM12();
        double qTs00 = diag_b * s00 + off_diag * s02;
        double qTs01 = diag_b * s01 + off_diag * s12;
        double qTs02 = diag_b * s02 + off_diag * s22;
        double qTs20 = diag_b * s02 - off_diag * s00;
        double qTs22 = diag_b * s22 - off_diag * s02;
        double qTsq00 = diag_b * qTs00 + off_diag * qTs02;
        double qTsq02 = diag_b * qTs02 - off_diag * qTs00;
        double qTsq12 = diag_b * s12 - off_diag * s01;
        double qTsq22 = diag_b * qTs22 - off_diag * qTs20;
        S.set(qTsq00, qTs01, qTsq02, qTs01, s11, qTsq12, qTsq02, qTsq12, qTsq22);
    }

    static void applyJacobiGivensRotationZ(double ch, double sh, Matrix3DBasics S) {
        double ch2 = ch * ch;
        double sh2 = sh * sh;
        double diag_a = ch2 + sh2;
        double diag_b = (ch2 - sh2) / diag_a;
        double off_diag = 2.0 * ch * sh / diag_a;
        double s00 = S.getM00();
        double s11 = S.getM11();
        double s22 = S.getM22();
        double s01 = S.getM01();
        double s02 = S.getM02();
        double s12 = S.getM12();
        double qTs00 = diag_b * s00 + off_diag * s01;
        double qTs01 = diag_b * s01 + off_diag * s11;
        double qTs02 = diag_b * s02 + off_diag * s12;
        double qTs10 = diag_b * s01 - off_diag * s00;
        double qTs11 = diag_b * s11 - off_diag * s01;
        double qTs12 = diag_b * s12 - off_diag * s02;
        double qTsq00 = diag_b * qTs00 + off_diag * qTs01;
        double qTsq01 = diag_b * qTs01 - off_diag * qTs00;
        double qTsq11 = diag_b * qTs11 - off_diag * qTs10;
        S.set(qTsq00, qTsq01, qTs02, qTsq01, qTsq11, qTs12, qTs02, qTs12, s22);
    }

    private static void applyQRGivensRotationX(double ch, double sh, Matrix3DBasics BToUpdate) {
        double ch2 = ch * ch;
        double sh2 = sh * sh;
        double diag_a = ch2 + sh2;
        double diag_b = (ch2 - sh2) / diag_a;
        double off_diag = 2.0 * ch * sh / diag_a;
        double b10 = diag_b * BToUpdate.getM10() + off_diag * BToUpdate.getM20();
        double b11 = diag_b * BToUpdate.getM11() + off_diag * BToUpdate.getM21();
        double b12 = diag_b * BToUpdate.getM12() + off_diag * BToUpdate.getM22();
        double b20 = diag_b * BToUpdate.getM20() - off_diag * BToUpdate.getM10();
        double b21 = diag_b * BToUpdate.getM21() - off_diag * BToUpdate.getM11();
        double b22 = diag_b * BToUpdate.getM22() - off_diag * BToUpdate.getM12();
        BToUpdate.set(BToUpdate.getM00(), BToUpdate.getM01(), BToUpdate.getM02(), b10, b11, b12, b20, b21, b22);
    }

    private static void applyQRGivensRotationY(double ch, double sh, Matrix3DBasics BToUpdate) {
        double ch2 = ch * ch;
        double sh2 = sh * sh;
        double diag_a = ch2 + sh2;
        double diag_b = (ch2 - sh2) / diag_a;
        double off_diag = 2.0 * ch * sh / diag_a;
        double b00 = diag_b * BToUpdate.getM00() + off_diag * BToUpdate.getM20();
        double b01 = diag_b * BToUpdate.getM01() + off_diag * BToUpdate.getM21();
        double b02 = diag_b * BToUpdate.getM02() + off_diag * BToUpdate.getM22();
        double b20 = diag_b * BToUpdate.getM20() - off_diag * BToUpdate.getM00();
        double b21 = diag_b * BToUpdate.getM21() - off_diag * BToUpdate.getM01();
        double b22 = diag_b * BToUpdate.getM22() - off_diag * BToUpdate.getM02();
        BToUpdate.set(b00, b01, b02, BToUpdate.getM10(), BToUpdate.getM11(), BToUpdate.getM12(), b20, b21, b22);
    }

    private static void applyQRGivensRotationZ(double ch, double sh, Matrix3DBasics BToUpdate) {
        double ch2 = ch * ch;
        double sh2 = sh * sh;
        double diag_a = ch2 + sh2;
        double diag_b = (ch2 - sh2) / diag_a;
        double off_diag = 2.0 * ch * sh / diag_a;
        double b00 = diag_b * BToUpdate.getM00() + off_diag * BToUpdate.getM10();
        double b01 = diag_b * BToUpdate.getM01() + off_diag * BToUpdate.getM11();
        double b02 = diag_b * BToUpdate.getM02() + off_diag * BToUpdate.getM12();
        double b10 = diag_b * BToUpdate.getM10() - off_diag * BToUpdate.getM00();
        double b11 = diag_b * BToUpdate.getM11() - off_diag * BToUpdate.getM01();
        double b12 = diag_b * BToUpdate.getM12() - off_diag * BToUpdate.getM02();
        BToUpdate.set(b00, b01, b02, b10, b11, b12, BToUpdate.getM20(), BToUpdate.getM21(), BToUpdate.getM22());
    }

    private static void prependGivensQuaternionX(double ch, double sh, QuaternionBasics V) {
        double vx = V.getX();
        double vy = V.getY();
        double vz = V.getZ();
        double vs = V.getS();
        V.setUnsafe(vx * ch + vs * sh, vy * ch + vz * sh, vz * ch - vy * sh, vs * ch - vx * sh);
    }

    private static void prependGivensQuaternionY(double ch, double sh, QuaternionBasics V) {
        double vx = V.getX();
        double vy = V.getY();
        double vz = V.getZ();
        double vs = V.getS();
        V.setUnsafe(vz * sh + vx * ch, vy * ch - vs * sh, vz * ch - vx * sh, vs * ch + vy * sh);
    }

    private static void prependGivensQuaternionZ(double ch, double sh, QuaternionBasics V) {
        double vx = V.getX();
        double vy = V.getY();
        double vz = V.getZ();
        double vs = V.getS();
        V.setUnsafe(vx * ch + vy * sh, vy * ch - vx * sh, vz * ch + vs * sh, vs * ch - vz * sh);
    }

    private static void appendGivensQuaternionX(double ch, double sh, QuaternionBasics U) {
        double ux = U.getX();
        double uy = U.getY();
        double uz = U.getZ();
        double us = U.getS();
        U.setUnsafe(us * sh + ux * ch, uy * ch + uz * sh, uz * ch - uy * sh, us * ch - ux * sh);
    }

    private static void appendGivensQuaternionY(double ch, double sh, QuaternionBasics U) {
        double ux = U.getX();
        double uy = U.getY();
        double uz = U.getZ();
        double us = U.getS();
        U.setUnsafe(ux * ch + uz * sh, uy * ch - us * sh, uz * ch - ux * sh, us * ch + uy * sh);
    }

    private static void appendGivensQuaternionZ(double ch, double sh, QuaternionBasics U) {
        double ux = U.getX();
        double uy = U.getY();
        double uz = U.getZ();
        double us = U.getS();
        U.setUnsafe(ux * ch + uy * sh, uy * ch - ux * sh, us * sh + uz * ch, us * ch - uz * sh);
    }

    static void sortBColumns(Matrix3DBasics B, QuaternionBasics V) {
        double rho0 = EuclidCoreTools.normSquared(B.getM00(), B.getM10(), B.getM20());
        double rho1 = EuclidCoreTools.normSquared(B.getM01(), B.getM11(), B.getM21());
        double rho2 = EuclidCoreTools.normSquared(B.getM02(), B.getM12(), B.getM22());
        double qx = V.getX();
        double qy = V.getY();
        double qz = V.getZ();
        double qs = V.getS();
        if (rho0 >= rho1) {
            if (rho0 >= rho2) {
                if (!(rho1 >= rho2)) {
                    B.set(B.getM00(), B.getM02(), -B.getM01(), B.getM10(), B.getM12(), -B.getM11(), B.getM20(), B.getM22(), -B.getM21());
                    V.setUnsafe(sqrtTwoOverTwo * (qs + qx), sqrtTwoOverTwo * (qy + qz), sqrtTwoOverTwo * (qz - qy), sqrtTwoOverTwo * (qs - qx));
                }
            } else {
                B.set(B.getM02(), B.getM00(), B.getM01(), B.getM12(), B.getM10(), B.getM11(), B.getM22(), B.getM20(), B.getM21());
                V.setUnsafe(0.5 * (-qs + qx - qy + qz), 0.5 * (-qs + qx + qy - qz), 0.5 * (-qs - qx + qy + qz), 0.5 * (qs + qx + qy + qz));
            }
        } else if (rho1 >= rho2) {
            if (rho0 >= rho2) {
                B.set(B.getM01(), -B.getM00(), B.getM02(), B.getM11(), -B.getM10(), B.getM12(), B.getM21(), -B.getM20(), B.getM22());
                V.setUnsafe(sqrtTwoOverTwo * (qx + qy), sqrtTwoOverTwo * (qy - qx), sqrtTwoOverTwo * (qs + qz), sqrtTwoOverTwo * (qs - qz));
            } else {
                B.set(B.getM01(), B.getM02(), B.getM00(), B.getM11(), B.getM12(), B.getM10(), B.getM21(), B.getM22(), B.getM20());
                V.setUnsafe(0.5 * (qs + qx + qy - qz), 0.5 * (qs - qx + qy + qz), 0.5 * (qs + qx - qy + qz), 0.5 * (qs - qx - qy - qz));
            }
        } else {
            B.set(B.getM02(), B.getM01(), -B.getM00(), B.getM12(), B.getM11(), -B.getM10(), B.getM22(), B.getM21(), -B.getM20());
            V.setUnsafe(sqrtTwoOverTwo * (qx + qz), sqrtTwoOverTwo * (qy - qs), sqrtTwoOverTwo * (qz - qx), sqrtTwoOverTwo * (qs + qy));
        }
    }

    public SVD3DOutput getOutput() {
        return this.output;
    }

    public Quaternion getU() {
        return this.output.getU();
    }

    public Vector3D getW() {
        return this.output.getW();
    }

    public Matrix3DBasics getW(Matrix3DBasics W) {
        return this.output.getW(W);
    }

    public Quaternion getV() {
        return this.output.getV();
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getIterations() {
        return this.iterations;
    }

    public boolean getSortDescendingOrder() {
        return this.sortDescendingOrder;
    }

    public static class SVD3DOutput {
        private final Quaternion U = new Quaternion();
        private final Vector3D W = new Vector3D();
        private final Quaternion V = new Quaternion();

        public void set(SVD3DOutput other) {
            this.U.set(other.U);
            this.W.set(other.W);
            this.V.set(other.V);
        }

        public void setIdentity() {
            this.U.setToZero();
            this.W.set(1.0, 1.0, 1.0);
            this.V.setToZero();
        }

        public void setToZero() {
            this.U.setToZero();
            this.W.setToZero();
            this.V.setToZero();
        }

        public void setToNaN() {
            this.U.setToNaN();
            this.W.setToNaN();
            this.V.setToNaN();
        }

        public void transpose() {
            double vx = this.V.getX();
            double vy = this.V.getY();
            double vz = this.V.getZ();
            double vs = this.V.getS();
            this.V.set(this.U);
            this.U.setUnsafe(vx, vy, vz, vs);
        }

        public void invert() {
            if (this.W.getX() < 1.0E-16 || this.W.getY() < 1.0E-16 || Math.abs(this.W.getZ()) < 1.0E-16) {
                throw new SingularMatrixException(this.W.getX(), 0.0, 0.0, 0.0, this.W.getY(), 0.0, 0.0, 0.0, this.W.getZ());
            }
            this.transpose();
            this.W.setX(1.0 / this.W.getX());
            this.W.setY(1.0 / this.W.getY());
            this.W.setZ(1.0 / this.W.getZ());
        }

        public Quaternion getU() {
            return this.U;
        }

        public Vector3D getW() {
            return this.W;
        }

        public Matrix3DBasics getW(Matrix3DBasics W) {
            if (W == null) {
                W = new Matrix3D();
            }
            W.setToDiagonal(this.W);
            return W;
        }

        public Quaternion getV() {
            return this.V;
        }

        public String toString() {
            return "U = " + this.U + ", W = " + this.W + ", V = " + this.V;
        }
    }
}

