/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;

public class AxisAngleTools {
    public static final double EPS = 1.0E-12;

    private AxisAngleTools() {
    }

    public static void transform(AxisAngleReadOnly axisAngle, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        AxisAngleTools.transformImpl(axisAngle, false, tupleOriginal, tupleTransformed);
    }

    public static void inverseTransform(AxisAngleReadOnly axisAngle, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        AxisAngleTools.transformImpl(axisAngle, true, tupleOriginal, tupleTransformed);
    }

    private static void transformImpl(AxisAngleReadOnly axisAngle, boolean negateAngle, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double angle = axisAngle.getAngle();
        if (negateAngle) {
            angle = -angle;
        }
        double cos = EuclidCoreTools.cos(angle);
        double oneMinusCos = 1.0 - cos;
        double sin = EuclidCoreTools.sin(angle);
        double ux = axisAngle.getX();
        double uy = axisAngle.getY();
        double uz = axisAngle.getZ();
        double crossX = uy * tupleOriginal.getZ() - uz * tupleOriginal.getY();
        double crossY = uz * tupleOriginal.getX() - ux * tupleOriginal.getZ();
        double crossZ = ux * tupleOriginal.getY() - uy * tupleOriginal.getX();
        double crossCrossX = uy * crossZ - uz * crossY;
        double crossCrossY = uz * crossX - ux * crossZ;
        double crossCrossZ = ux * crossY - uy * crossX;
        double x = tupleOriginal.getX() + sin * crossX + oneMinusCos * crossCrossX;
        double y = tupleOriginal.getY() + sin * crossY + oneMinusCos * crossCrossY;
        double z = tupleOriginal.getZ() + sin * crossZ + oneMinusCos * crossCrossZ;
        tupleTransformed.set(x, y, z);
    }

    public static void addTransform(AxisAngleReadOnly axisAngle, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        double x = tupleTransformed.getX();
        double y = tupleTransformed.getY();
        double z = tupleTransformed.getZ();
        AxisAngleTools.transform(axisAngle, tupleOriginal, tupleTransformed);
        tupleTransformed.add(x, y, z);
    }

    public static void transform(AxisAngleReadOnly axisAngle, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        AxisAngleTools.transformImpl(axisAngle, false, tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    public static void inverseTransform(AxisAngleReadOnly axisAngle, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        AxisAngleTools.transformImpl(axisAngle, true, tupleOriginal, tupleTransformed, checkIfTransformInXYPlane);
    }

    private static void transformImpl(AxisAngleReadOnly axisAngle, boolean negateAngle, Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfTransformInXYPlane) {
        if (checkIfTransformInXYPlane) {
            axisAngle.checkIfOrientation2D(1.0E-12);
        }
        double angle = axisAngle.getAngle();
        if (negateAngle) {
            angle = -angle;
        }
        double cos = EuclidCoreTools.cos(angle);
        double oneMinusCos = 1.0 - cos;
        double sin = EuclidCoreTools.sin(angle);
        double uz = axisAngle.getZ();
        double crossX = -uz * tupleOriginal.getY();
        double crossY = uz * tupleOriginal.getX();
        double crossCrossX = -uz * crossY;
        double crossCrossY = uz * crossX;
        double x = tupleOriginal.getX() + sin * crossX + oneMinusCos * crossCrossX;
        double y = tupleOriginal.getY() + sin * crossY + oneMinusCos * crossCrossY;
        tupleTransformed.set(x, y);
    }

    public static void transform(AxisAngleReadOnly axisAngle, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        AxisAngleTools.transformImpl(axisAngle, false, matrixOriginal, matrixTransformed);
    }

    public static void inverseTransform(AxisAngleReadOnly axisAngle, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        AxisAngleTools.transformImpl(axisAngle, true, matrixOriginal, matrixTransformed);
    }

    private static void transformImpl(AxisAngleReadOnly axisAngle, boolean negateAngle, Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        double cos = EuclidCoreTools.cos(0.5 * axisAngle.getAngle());
        double sin = EuclidCoreTools.sin(0.5 * axisAngle.getAngle());
        double qx = axisAngle.getX() * sin;
        double qy = axisAngle.getY() * sin;
        double qz = axisAngle.getZ() * sin;
        double qs = cos;
        QuaternionTools.transformImpl(qx, qy, qz, qs, negateAngle, matrixOriginal, matrixTransformed);
    }

    public static void transform(AxisAngleReadOnly axisAngle, QuaternionReadOnly quaternionOriginal, QuaternionBasics quaternionTransformed) {
        QuaternionTools.multiply((Orientation3DReadOnly)axisAngle, false, quaternionOriginal, false, quaternionTransformed);
    }

    public static void inverseTransform(AxisAngleReadOnly axisAngle, QuaternionReadOnly quaternionOriginal, QuaternionBasics quaternionTransformed) {
        quaternionTransformed.set(quaternionOriginal);
        quaternionTransformed.prependInvertOther(axisAngle);
    }

    public static void transform(AxisAngleReadOnly axisAngle, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        AxisAngleTools.transformImpl(axisAngle, false, vectorOriginal, vectorTransformed);
    }

    public static void inverseTransform(AxisAngleReadOnly axisAngle, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        AxisAngleTools.transformImpl(axisAngle, true, vectorOriginal, vectorTransformed);
    }

    private static void transformImpl(AxisAngleReadOnly axisAngle, boolean negateAngle, Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        double angle = axisAngle.getAngle();
        if (negateAngle) {
            angle = -angle;
        }
        double cos = EuclidCoreTools.cos(angle);
        double oneMinusCos = 1.0 - cos;
        double sin = EuclidCoreTools.sin(angle);
        double ux = axisAngle.getX();
        double uy = axisAngle.getY();
        double uz = axisAngle.getZ();
        double crossX = uy * vectorOriginal.getZ() - uz * vectorOriginal.getY();
        double crossY = uz * vectorOriginal.getX() - ux * vectorOriginal.getZ();
        double crossZ = ux * vectorOriginal.getY() - uy * vectorOriginal.getX();
        double crossCrossX = uy * crossZ - uz * crossY;
        double crossCrossY = uz * crossX - ux * crossZ;
        double crossCrossZ = ux * crossY - uy * crossX;
        double x = vectorOriginal.getX() + sin * crossX + oneMinusCos * crossCrossX;
        double y = vectorOriginal.getY() + sin * crossY + oneMinusCos * crossCrossY;
        double z = vectorOriginal.getZ() + sin * crossZ + oneMinusCos * crossCrossZ;
        vectorTransformed.set(x, y, z, vectorOriginal.getS());
    }

    public static void transform(AxisAngleReadOnly axisAngle, RotationMatrixReadOnly rotationMatrixOriginal, RotationMatrixBasics rotationMatrixTransformed) {
        RotationMatrixTools.multiply((Orientation3DReadOnly)axisAngle, false, rotationMatrixOriginal, false, (CommonMatrix3DBasics)rotationMatrixTransformed);
    }

    public static void inverseTransform(AxisAngleReadOnly axisAngle, RotationMatrixReadOnly rotationMatrixOriginal, RotationMatrixBasics rotationMatrixTransformed) {
        RotationMatrixTools.multiply((Orientation3DReadOnly)axisAngle, true, rotationMatrixOriginal, false, (CommonMatrix3DBasics)rotationMatrixTransformed);
    }

    public static void multiply(AxisAngleReadOnly aa1, AxisAngleReadOnly aa2, AxisAngleBasics axisAngleToPack) {
        AxisAngleTools.multiplyImpl(aa1, false, aa2, false, axisAngleToPack);
    }

    public static void multiply(Orientation3DReadOnly orientation1, boolean inverse1, Orientation3DReadOnly orientation2, boolean inverse2, AxisAngleBasics axisAngleToPack) {
        double u2z;
        double u2y;
        double u2x;
        double beta;
        if (orientation1 instanceof AxisAngleReadOnly) {
            AxisAngleTools.multiply((AxisAngleReadOnly)orientation1, inverse1, orientation2, inverse2, axisAngleToPack);
            return;
        }
        if (orientation2 instanceof AxisAngleReadOnly) {
            AxisAngleReadOnly aa2 = (AxisAngleReadOnly)orientation2;
            beta = aa2.getAngle();
            u2x = aa2.getX();
            u2y = aa2.getY();
            u2z = aa2.getZ();
        } else {
            axisAngleToPack.set(orientation2);
            beta = axisAngleToPack.getAngle();
            u2x = axisAngleToPack.getX();
            u2y = axisAngleToPack.getY();
            u2z = axisAngleToPack.getZ();
        }
        axisAngleToPack.set(orientation1);
        double alpha = axisAngleToPack.getAngle();
        double u1x = axisAngleToPack.getX();
        double u1y = axisAngleToPack.getY();
        double u1z = axisAngleToPack.getZ();
        AxisAngleTools.multiplyImpl(alpha, u1x, u1y, u1z, inverse1, beta, u2x, u2y, u2z, inverse2, axisAngleToPack);
    }

    public static void multiply(Orientation3DReadOnly orientation1, boolean inverse1, AxisAngleReadOnly orientation2, boolean inverse2, AxisAngleBasics axisAngleToPack) {
        if (orientation1 instanceof AxisAngleReadOnly) {
            AxisAngleTools.multiplyImpl((AxisAngleReadOnly)orientation1, inverse1, orientation2, inverse2, axisAngleToPack);
            return;
        }
        double beta = orientation2.getAngle();
        double u2x = orientation2.getX();
        double u2y = orientation2.getY();
        double u2z = orientation2.getZ();
        axisAngleToPack.set(orientation1);
        double alpha = axisAngleToPack.getAngle();
        double u1x = axisAngleToPack.getX();
        double u1y = axisAngleToPack.getY();
        double u1z = axisAngleToPack.getZ();
        AxisAngleTools.multiplyImpl(alpha, u1x, u1y, u1z, inverse1, beta, u2x, u2y, u2z, inverse2, axisAngleToPack);
    }

    public static void multiply(AxisAngleReadOnly orientation1, boolean inverse1, Orientation3DReadOnly orientation2, boolean inverse2, AxisAngleBasics axisAngleToPack) {
        if (orientation2 instanceof AxisAngleReadOnly) {
            AxisAngleTools.multiplyImpl(orientation1, inverse1, (AxisAngleReadOnly)orientation2, inverse2, axisAngleToPack);
            return;
        }
        double alpha = orientation1.getAngle();
        double u1x = orientation1.getX();
        double u1y = orientation1.getY();
        double u1z = orientation1.getZ();
        axisAngleToPack.set(orientation2);
        double beta = axisAngleToPack.getAngle();
        double u2x = axisAngleToPack.getX();
        double u2y = axisAngleToPack.getY();
        double u2z = axisAngleToPack.getZ();
        AxisAngleTools.multiplyImpl(alpha, u1x, u1y, u1z, inverse1, beta, u2x, u2y, u2z, inverse2, axisAngleToPack);
    }

    public static void multiplyInvertLeft(AxisAngleReadOnly aa1, AxisAngleReadOnly aa2, AxisAngleBasics axisAngleToPack) {
        AxisAngleTools.multiplyImpl(aa1, true, aa2, false, axisAngleToPack);
    }

    public static void multiplyInvertRight(AxisAngleReadOnly aa1, AxisAngleReadOnly aa2, AxisAngleBasics axisAngleToPack) {
        AxisAngleTools.multiplyImpl(aa1, false, aa2, true, axisAngleToPack);
    }

    public static void multiplyInvertBoth(AxisAngleReadOnly aa1, AxisAngleReadOnly aa2, AxisAngleBasics axisAngleToPack) {
        AxisAngleTools.multiplyImpl(aa1, true, aa2, true, axisAngleToPack);
    }

    private static void multiplyImpl(AxisAngleReadOnly aa1, boolean inverse1, AxisAngleReadOnly aa2, boolean inverse2, AxisAngleBasics axisAngleToPack) {
        double alpha = aa1.getAngle();
        double u1x = aa1.getX();
        double u1y = aa1.getY();
        double u1z = aa1.getZ();
        double beta = aa2.getAngle();
        double u2x = aa2.getX();
        double u2y = aa2.getY();
        double u2z = aa2.getZ();
        AxisAngleTools.multiplyImpl(alpha, u1x, u1y, u1z, inverse1, beta, u2x, u2y, u2z, inverse2, axisAngleToPack);
    }

    private static void multiplyImpl(double alpha, double u1x, double u1y, double u1z, boolean inverse1, double beta, double u2x, double u2y, double u2z, boolean inverse2, AxisAngleBasics axisAngleToPack) {
        double axisNorm1 = EuclidCoreTools.fastNorm(u1x, u1y, u1z);
        if (axisNorm1 < 1.0E-12) {
            return;
        }
        double axisNorm2 = EuclidCoreTools.fastNorm(u2x, u2y, u2z);
        if (axisNorm2 < 1.0E-12) {
            return;
        }
        axisNorm1 = 1.0 / axisNorm1;
        if (inverse1) {
            alpha = -alpha;
        }
        u1x *= axisNorm1;
        u1y *= axisNorm1;
        u1z *= axisNorm1;
        axisNorm2 = 1.0 / axisNorm2;
        if (inverse2) {
            beta = -beta;
        }
        u2x *= axisNorm2;
        double cosHalfAlpha = EuclidCoreTools.cos(0.5 * alpha);
        double sinHalfAlpha = EuclidCoreTools.sin(0.5 * alpha);
        double cosHalfBeta = EuclidCoreTools.cos(0.5 * beta);
        double sinHalfBeta = EuclidCoreTools.sin(0.5 * beta);
        double dot = u1x * u2x + u1y * (u2y *= axisNorm2) + u1z * (u2z *= axisNorm2);
        double crossX = u1y * u2z - u1z * u2y;
        double crossY = u1z * u2x - u1x * u2z;
        double crossZ = u1x * u2y - u1y * u2x;
        double sinCos = sinHalfAlpha * cosHalfBeta;
        double cosSin = cosHalfAlpha * sinHalfBeta;
        double cosCos = cosHalfAlpha * cosHalfBeta;
        double sinSin = sinHalfAlpha * sinHalfBeta;
        double cosHalfGamma = cosCos - sinSin * dot;
        double sinHalfGammaUx = sinCos * u1x + cosSin * u2x + sinSin * crossX;
        double sinHalfGammaUy = sinCos * u1y + cosSin * u2y + sinSin * crossY;
        double sinHalfGammaUz = sinCos * u1z + cosSin * u2z + sinSin * crossZ;
        double sinHalfGammaSquared = EuclidCoreTools.normSquared(sinHalfGammaUx, sinHalfGammaUy, sinHalfGammaUz);
        if (sinHalfGammaSquared < 1.0E-12) {
            axisAngleToPack.set(1.0, 0.0, 0.0, 0.0);
        } else {
            double sinHalfGamma = EuclidCoreTools.squareRoot(sinHalfGammaSquared);
            double gamma = 2.0 * EuclidCoreTools.atan2(sinHalfGamma, cosHalfGamma);
            double sinHalfGammaInv = 1.0 / sinHalfGamma;
            double ux = sinHalfGammaUx * sinHalfGammaInv;
            double uy = sinHalfGammaUy * sinHalfGammaInv;
            double uz = sinHalfGammaUz * sinHalfGammaInv;
            axisAngleToPack.set(ux, uy, uz, gamma);
        }
    }

    public static void prependYawRotation(double yaw, AxisAngleReadOnly axisAngleOriginal, AxisAngleBasics axisAngleToPack) {
        double beta = axisAngleOriginal.getAngle();
        double ux = axisAngleOriginal.getX();
        double uy = axisAngleOriginal.getY();
        double uz = axisAngleOriginal.getZ();
        double cosHalfAlpha = EuclidCoreTools.cos(0.5 * yaw);
        double sinHalfAlpha = EuclidCoreTools.sin(0.5 * yaw);
        double cosHalfBeta = EuclidCoreTools.cos(0.5 * beta);
        double sinHalfBeta = EuclidCoreTools.sin(0.5 * beta);
        double sinCos = sinHalfAlpha * cosHalfBeta;
        double cosSin = cosHalfAlpha * sinHalfBeta;
        double cosCos = cosHalfAlpha * cosHalfBeta;
        double sinSin = sinHalfAlpha * sinHalfBeta;
        double cosHalfGamma = cosCos - sinSin * uz;
        double sinHalfGammaUx = cosSin * ux - sinSin * uy;
        double sinHalfGammaUy = cosSin * uy + sinSin * ux;
        double sinHalfGammaUz = sinCos + cosSin * uz;
        double sinHalfGamma = EuclidCoreTools.norm(sinHalfGammaUx, sinHalfGammaUy, sinHalfGammaUz);
        double gamma = 2.0 * EuclidCoreTools.atan2(sinHalfGamma, cosHalfGamma);
        double sinHalfGammaInv = 1.0 / sinHalfGamma;
        axisAngleToPack.set(sinHalfGammaUx * sinHalfGammaInv, sinHalfGammaUy * sinHalfGammaInv, sinHalfGammaUz * sinHalfGammaInv, gamma);
    }

    public static void appendYawRotation(AxisAngleReadOnly axisAngleOriginal, double yaw, AxisAngleBasics axisAngleToPack) {
        double alpha = axisAngleOriginal.getAngle();
        double ux = axisAngleOriginal.getX();
        double uy = axisAngleOriginal.getY();
        double uz = axisAngleOriginal.getZ();
        double cosHalfAlpha = EuclidCoreTools.cos(0.5 * alpha);
        double sinHalfAlpha = EuclidCoreTools.sin(0.5 * alpha);
        double cosHalfBeta = EuclidCoreTools.cos(0.5 * yaw);
        double sinHalfBeta = EuclidCoreTools.sin(0.5 * yaw);
        double sinCos = sinHalfAlpha * cosHalfBeta;
        double cosSin = cosHalfAlpha * sinHalfBeta;
        double cosCos = cosHalfAlpha * cosHalfBeta;
        double sinSin = sinHalfAlpha * sinHalfBeta;
        double cosHalfGamma = cosCos - sinSin * uz;
        double sinHalfGammaUx = sinCos * ux + sinSin * uy;
        double sinHalfGammaUy = sinCos * uy - sinSin * ux;
        double sinHalfGammaUz = sinCos * uz + cosSin;
        double sinHalfGamma = EuclidCoreTools.norm(sinHalfGammaUx, sinHalfGammaUy, sinHalfGammaUz);
        double gamma = 2.0 * EuclidCoreTools.atan2(sinHalfGamma, cosHalfGamma);
        double sinHalfGammaInv = 1.0 / sinHalfGamma;
        axisAngleToPack.set(sinHalfGammaUx * sinHalfGammaInv, sinHalfGammaUy * sinHalfGammaInv, sinHalfGammaUz * sinHalfGammaInv, gamma);
    }

    public static void prependPitchRotation(double pitch, AxisAngleReadOnly axisAngleOriginal, AxisAngleBasics axisAngleToPack) {
        double beta = axisAngleOriginal.getAngle();
        double ux = axisAngleOriginal.getX();
        double uy = axisAngleOriginal.getY();
        double uz = axisAngleOriginal.getZ();
        double cosHalfAlpha = EuclidCoreTools.cos(0.5 * pitch);
        double sinHalfAlpha = EuclidCoreTools.sin(0.5 * pitch);
        double cosHalfBeta = EuclidCoreTools.cos(0.5 * beta);
        double sinHalfBeta = EuclidCoreTools.sin(0.5 * beta);
        double sinCos = sinHalfAlpha * cosHalfBeta;
        double cosSin = cosHalfAlpha * sinHalfBeta;
        double cosCos = cosHalfAlpha * cosHalfBeta;
        double sinSin = sinHalfAlpha * sinHalfBeta;
        double cosHalfGamma = cosCos - sinSin * uy;
        double sinHalfGammaUx = cosSin * ux + sinSin * uz;
        double sinHalfGammaUy = sinCos + cosSin * uy;
        double sinHalfGammaUz = cosSin * uz - sinSin * ux;
        double sinHalfGamma = EuclidCoreTools.norm(sinHalfGammaUx, sinHalfGammaUy, sinHalfGammaUz);
        double gamma = 2.0 * EuclidCoreTools.atan2(sinHalfGamma, cosHalfGamma);
        double sinHalfGammaInv = 1.0 / sinHalfGamma;
        axisAngleToPack.set(sinHalfGammaUx * sinHalfGammaInv, sinHalfGammaUy * sinHalfGammaInv, sinHalfGammaUz * sinHalfGammaInv, gamma);
    }

    public static void appendPitchRotation(AxisAngleReadOnly axisAngleOriginal, double pitch, AxisAngleBasics axisAngleToPack) {
        double alpha = axisAngleOriginal.getAngle();
        double ux = axisAngleOriginal.getX();
        double uy = axisAngleOriginal.getY();
        double uz = axisAngleOriginal.getZ();
        double cosHalfAlpha = EuclidCoreTools.cos(0.5 * alpha);
        double sinHalfAlpha = EuclidCoreTools.sin(0.5 * alpha);
        double cosHalfBeta = EuclidCoreTools.cos(0.5 * pitch);
        double sinHalfBeta = EuclidCoreTools.sin(0.5 * pitch);
        double sinCos = sinHalfAlpha * cosHalfBeta;
        double cosSin = cosHalfAlpha * sinHalfBeta;
        double cosCos = cosHalfAlpha * cosHalfBeta;
        double sinSin = sinHalfAlpha * sinHalfBeta;
        double cosHalfGamma = cosCos - sinSin * uy;
        double sinHalfGammaUx = sinCos * ux - sinSin * uz;
        double sinHalfGammaUy = sinCos * uy + cosSin;
        double sinHalfGammaUz = sinCos * uz + sinSin * ux;
        double sinHalfGamma = EuclidCoreTools.norm(sinHalfGammaUx, sinHalfGammaUy, sinHalfGammaUz);
        double gamma = 2.0 * EuclidCoreTools.atan2(sinHalfGamma, cosHalfGamma);
        double sinHalfGammaInv = 1.0 / sinHalfGamma;
        axisAngleToPack.set(sinHalfGammaUx * sinHalfGammaInv, sinHalfGammaUy * sinHalfGammaInv, sinHalfGammaUz * sinHalfGammaInv, gamma);
    }

    public static void prependRollRotation(double roll, AxisAngleReadOnly axisAngleOriginal, AxisAngleBasics axisAngleToPack) {
        double beta = axisAngleOriginal.getAngle();
        double ux = axisAngleOriginal.getX();
        double uy = axisAngleOriginal.getY();
        double uz = axisAngleOriginal.getZ();
        double cosHalfAlpha = EuclidCoreTools.cos(0.5 * roll);
        double sinHalfAlpha = EuclidCoreTools.sin(0.5 * roll);
        double cosHalfBeta = EuclidCoreTools.cos(0.5 * beta);
        double sinHalfBeta = EuclidCoreTools.sin(0.5 * beta);
        double sinCos = sinHalfAlpha * cosHalfBeta;
        double cosSin = cosHalfAlpha * sinHalfBeta;
        double cosCos = cosHalfAlpha * cosHalfBeta;
        double sinSin = sinHalfAlpha * sinHalfBeta;
        double cosHalfGamma = cosCos - sinSin * ux;
        double sinHalfGammaUx = sinCos + cosSin * ux;
        double sinHalfGammaUy = cosSin * uy - sinSin * uz;
        double sinHalfGammaUz = cosSin * uz + sinSin * uy;
        double sinHalfGamma = EuclidCoreTools.norm(sinHalfGammaUx, sinHalfGammaUy, sinHalfGammaUz);
        double gamma = 2.0 * EuclidCoreTools.atan2(sinHalfGamma, cosHalfGamma);
        double sinHalfGammaInv = 1.0 / sinHalfGamma;
        axisAngleToPack.set(sinHalfGammaUx * sinHalfGammaInv, sinHalfGammaUy * sinHalfGammaInv, sinHalfGammaUz * sinHalfGammaInv, gamma);
    }

    public static void appendRollRotation(AxisAngleReadOnly axisAngleOriginal, double roll, AxisAngleBasics axisAngleToPack) {
        double alpha = axisAngleOriginal.getAngle();
        double ux = axisAngleOriginal.getX();
        double uy = axisAngleOriginal.getY();
        double uz = axisAngleOriginal.getZ();
        double cosHalfAlpha = EuclidCoreTools.cos(0.5 * alpha);
        double sinHalfAlpha = EuclidCoreTools.sin(0.5 * alpha);
        double cosHalfBeta = EuclidCoreTools.cos(0.5 * roll);
        double sinHalfBeta = EuclidCoreTools.sin(0.5 * roll);
        double sinCos = sinHalfAlpha * cosHalfBeta;
        double cosSin = cosHalfAlpha * sinHalfBeta;
        double cosCos = cosHalfAlpha * cosHalfBeta;
        double sinSin = sinHalfAlpha * sinHalfBeta;
        double cosHalfGamma = cosCos - sinSin * ux;
        double sinHalfGammaUx = sinCos * ux + cosSin;
        double sinHalfGammaUy = sinCos * uy + sinSin * uz;
        double sinHalfGammaUz = sinCos * uz + -sinSin * uy;
        double sinHalfGamma = EuclidCoreTools.norm(sinHalfGammaUx, sinHalfGammaUy, sinHalfGammaUz);
        double gamma = 2.0 * EuclidCoreTools.atan2(sinHalfGamma, cosHalfGamma);
        double sinHalfGammaInv = 1.0 / sinHalfGamma;
        axisAngleToPack.set(sinHalfGammaUx * sinHalfGammaInv, sinHalfGammaUy * sinHalfGammaInv, sinHalfGammaUz * sinHalfGammaInv, gamma);
    }

    public static double distance(AxisAngleReadOnly aa1, AxisAngleReadOnly aa2) {
        double alpha = aa1.getAngle();
        double u1x = aa1.getX();
        double u1y = aa1.getY();
        double u1z = aa1.getZ();
        double beta = -aa2.getAngle();
        double u2x = aa2.getX();
        double u2y = aa2.getY();
        double u2z = aa2.getZ();
        double cosHalfAlpha = EuclidCoreTools.cos(0.5 * alpha);
        double sinHalfAlpha = EuclidCoreTools.sin(0.5 * alpha);
        double cosHalfBeta = EuclidCoreTools.cos(0.5 * beta);
        double sinHalfBeta = EuclidCoreTools.sin(0.5 * beta);
        double dot = u1x * u2x + u1y * u2y + u1z * u2z;
        double crossX = u1y * u2z - u1z * u2y;
        double crossY = u1z * u2x - u1x * u2z;
        double crossZ = u1x * u2y - u1y * u2x;
        double sinCos = sinHalfAlpha * cosHalfBeta;
        double cosSin = cosHalfAlpha * sinHalfBeta;
        double cosCos = cosHalfAlpha * cosHalfBeta;
        double sinSin = sinHalfAlpha * sinHalfBeta;
        double cosHalfGamma = cosCos - sinSin * dot;
        double sinHalfGammaUx = sinCos * u1x + cosSin * u2x + sinSin * crossX;
        double sinHalfGammaUy = sinCos * u1y + cosSin * u2y + sinSin * crossY;
        double sinHalfGammaUz = sinCos * u1z + cosSin * u2z + sinSin * crossZ;
        double sinHalfGamma = EuclidCoreTools.norm(sinHalfGammaUx, sinHalfGammaUy, sinHalfGammaUz);
        double gamma = 2.0 * EuclidCoreTools.atan2(sinHalfGamma, cosHalfGamma);
        return Math.abs(gamma);
    }
}

