/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public enum Axis2D implements UnitVector2DReadOnly
{
    X(1.0, 0.0){

        @Override
        public double extract(Tuple2DReadOnly tuple) {
            return tuple.getX();
        }

        @Override
        public void insert(Tuple2DBasics tupleToUpdate, double value) {
            tupleToUpdate.setX(value);
        }

        @Override
        public Axis2D other() {
            return Y;
        }

        @Override
        public Axis3D asAxis3D() {
            return Axis3D.X;
        }
    }
    ,
    Y(0.0, 1.0){

        @Override
        public double extract(Tuple2DReadOnly tuple) {
            return tuple.getY();
        }

        @Override
        public void insert(Tuple2DBasics tupleToUpdate, double value) {
            tupleToUpdate.setY(value);
        }

        @Override
        public Axis2D other() {
            return X;
        }

        @Override
        public Axis3D asAxis3D() {
            return Axis3D.Y;
        }
    };

    public static final Axis2D[] values;
    private final double x;
    private final double y;
    private final UnitVector2DReadOnly negated = EuclidCoreFactories.newNegativeLinkedUnitVector2D(this);

    private Axis2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public UnitVector2DReadOnly negated() {
        return this.negated;
    }

    @Override
    public double dot(Vector2DReadOnly other) {
        return this.extract(other);
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getRawX() {
        return this.x;
    }

    @Override
    public double getRawY() {
        return this.y;
    }

    public abstract void insert(Tuple2DBasics var1, double var2);

    public void insert(Tuple3DBasics tupleToUpdate, double value) {
        this.asAxis3D().insert(tupleToUpdate, value);
    }

    public abstract double extract(Tuple2DReadOnly var1);

    public double extract(Tuple3DReadOnly tuple) {
        return this.asAxis3D().extract(tuple);
    }

    public abstract Axis2D other();

    public abstract Axis3D asAxis3D();

    @Deprecated
    public static double get(Tuple2DReadOnly tuple, Axis2D axis) {
        return axis.extract(tuple);
    }

    @Deprecated
    public static void set(Tuple2DBasics tupleToModify, Axis2D axis, double value) {
        axis.insert(tupleToModify, value);
    }

    @Deprecated
    public static double get(Tuple3DReadOnly tuple, Axis2D axis) {
        return axis.extract(tuple);
    }

    @Deprecated
    public static void set(Tuple3DBasics tupleToModify, Axis2D axis, double value) {
        axis.insert(tupleToModify, value);
    }

    @Deprecated
    public Axis2D getNextClockwiseAxis() {
        return this.other();
    }

    @Deprecated
    public Axis2D getNextCounterClockwiseAxis() {
        return this.other();
    }

    static {
        values = Axis2D.values();
    }
}

