/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import us.ihmc.util.PeriodicThreadScheduler;

public class PeriodicNonRealtimeThreadScheduler
implements PeriodicThreadScheduler {
    private final ScheduledExecutorService executorService;
    private boolean running = false;

    public PeriodicNonRealtimeThreadScheduler(String name) {
        this.executorService = Executors.newSingleThreadScheduledExecutor(this.getNamedThreadFactory(name));
    }

    @Override
    public void schedule(Runnable runnable, long period, TimeUnit timeunit) {
        if (this.running) {
            throw new RuntimeException("Thread has already been scheduled");
        }
        this.executorService.scheduleAtFixedRate(runnable, 0L, period, timeunit);
        this.running = true;
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    private ThreadFactory getNamedThreadFactory(final String name) {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, name + "-thread-" + this.threadNumber.getAndIncrement());
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.executorService.awaitTermination(timeout, timeUnit);
    }
}

