/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.concurrent.runtime.barrierScheduler.implicitContext;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.BarrierScheduler;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.Task;

public class SchedulerDemo {
    public static void main(String[] args) throws InterruptedException {
        int SCHEDULER_FREQ = 100;
        boolean PUBLISHER_DIVISOR = true;
        int SUBSCRIBER_DIVISOR = 10;
        Publisher publisher = new Publisher(1L);
        Subscriber subscriber = new Subscriber(10L);
        Thread publisherThread = new Thread((Runnable)publisher, "publisher");
        Thread subscriberThread = new Thread((Runnable)subscriber, "subscriber");
        publisherThread.start();
        subscriberThread.start();
        List<Task> tasks = Arrays.asList(publisher, subscriber);
        Context context = new Context();
        BarrierScheduler<Context> barrierScheduler = new BarrierScheduler<Context>(tasks, context, BarrierScheduler.TaskOverrunBehavior.SKIP_TICK);
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(barrierScheduler, 0L, 10L, TimeUnit.MILLISECONDS);
        executor.awaitTermination(0L, TimeUnit.SECONDS);
    }

    public static class Subscriber
    extends Task<Context> {
        private long counter = 0L;

        public Subscriber(long divisor) {
            super(divisor);
        }

        @Override
        protected boolean initialize() {
            return true;
        }

        @Override
        protected void execute() {
            System.out.println("[subscriber] counter: " + this.counter);
        }

        @Override
        protected void cleanup() {
        }

        @Override
        protected void updateMasterContext(Context masterContext) {
        }

        @Override
        protected void updateLocalContext(Context masterContext) {
            this.counter = masterContext.counter;
        }
    }

    public static class Publisher
    extends Task<Context> {
        private long counter = 0L;

        public Publisher(long divisor) {
            super(divisor);
        }

        @Override
        protected boolean initialize() {
            return true;
        }

        @Override
        protected void execute() {
            System.out.println("[publisher] counter: " + this.counter);
            ++this.counter;
        }

        @Override
        protected void cleanup() {
        }

        @Override
        protected void updateMasterContext(Context masterContext) {
            masterContext.counter = this.counter;
        }

        @Override
        protected void updateLocalContext(Context masterContext) {
        }
    }

    public static class Context {
        public long counter = 0L;
    }
}

