/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg.modelmapper;

import net.bramp.ffmpeg.builder.AbstractFFmpegStreamBuilder;
import net.bramp.ffmpeg.builder.FFmpegOutputBuilder;
import net.bramp.ffmpeg.modelmapper.NotDefaultCondition;
import net.bramp.ffmpeg.options.AudioEncodingOptions;
import net.bramp.ffmpeg.options.EncodingOptions;
import net.bramp.ffmpeg.options.MainEncodingOptions;
import net.bramp.ffmpeg.options.VideoEncodingOptions;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;
import org.modelmapper.config.Configuration;
import org.modelmapper.convention.NameTokenizers;

public class Mapper {
    private static final ModelMapper mapper = Mapper.newModelMapper();

    private Mapper() {
        throw new InstantiationError("Must not instantiate this class");
    }

    private static <S, D> TypeMap<S, D> createTypeMap(ModelMapper mapper, Class<S> sourceType, Class<D> destinationType, Configuration config) {
        return mapper.createTypeMap(sourceType, destinationType, config).setPropertyCondition(config.getPropertyCondition());
    }

    private static ModelMapper newModelMapper() {
        ModelMapper mapper = new ModelMapper();
        Configuration config = mapper.getConfiguration().copy().setFieldMatchingEnabled(true).setPropertyCondition(NotDefaultCondition.notDefault).setSourceNameTokenizer(NameTokenizers.UNDERSCORE);
        Mapper.createTypeMap(mapper, MainEncodingOptions.class, FFmpegOutputBuilder.class, config);
        Mapper.createTypeMap(mapper, AudioWrapper.class, FFmpegOutputBuilder.class, config);
        Mapper.createTypeMap(mapper, VideoWrapper.class, FFmpegOutputBuilder.class, config);
        return mapper;
    }

    public static <T extends AbstractFFmpegStreamBuilder<T>> void map(MainEncodingOptions opts, AbstractFFmpegStreamBuilder<T> dest) {
        mapper.map((Object)opts, dest);
    }

    public static <T extends AbstractFFmpegStreamBuilder<T>> void map(AudioEncodingOptions opts, AbstractFFmpegStreamBuilder<T> dest) {
        mapper.map((Object)new AudioWrapper(opts), dest);
    }

    public static <T extends AbstractFFmpegStreamBuilder<T>> void map(VideoEncodingOptions opts, AbstractFFmpegStreamBuilder<T> dest) {
        mapper.map((Object)new VideoWrapper(opts), dest);
    }

    public static <T extends AbstractFFmpegStreamBuilder<T>> void map(EncodingOptions opts, AbstractFFmpegStreamBuilder<T> dest) {
        Mapper.map(opts.getMain(), dest);
        if (opts.getAudio().enabled) {
            Mapper.map(opts.getAudio(), dest);
        }
        if (opts.getVideo().enabled) {
            Mapper.map(opts.getVideo(), dest);
        }
    }

    static class VideoWrapper {
        public final VideoEncodingOptions video;

        VideoWrapper(VideoEncodingOptions video) {
            this.video = video;
        }
    }

    static class AudioWrapper {
        public final AudioEncodingOptions audio;

        AudioWrapper(AudioEncodingOptions audio) {
            this.audio = audio;
        }
    }
}

