/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.LineSegment1D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.Pose2D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.Triangle3D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.interfaces.Vertex3DSupplier;
import us.ihmc.euclid.orientation.Orientation2D;
import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidGeometryRandomTools {
    private EuclidGeometryRandomTools() {
    }

    public static Line2D nextLine2D(Random random) {
        return new Line2D((Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random), (Vector2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
    }

    public static Line2D nextLine2D(Random random, double pointMinMax) {
        return new Line2D((Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)pointMinMax), (Vector2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random));
    }

    public static Line3D nextLine3D(Random random) {
        return new Line3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
    }

    public static Line3D nextLine3D(Random random, double pointMinMax) {
        return new Line3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)pointMinMax), (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
    }

    public static LineSegment1D nextLineSegment1D(Random random) {
        return new LineSegment1D(EuclidCoreRandomTools.nextDouble((Random)random), EuclidCoreRandomTools.nextDouble((Random)random));
    }

    public static LineSegment1D nextLineSegment1D(Random random, double minMax) {
        return new LineSegment1D(EuclidCoreRandomTools.nextDouble((Random)random, (double)minMax), EuclidCoreRandomTools.nextDouble((Random)random, (double)minMax));
    }

    public static LineSegment2D nextLineSegment2D(Random random) {
        return new LineSegment2D((Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random), (Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
    }

    public static LineSegment2D nextLineSegment2D(Random random, double minMax) {
        return new LineSegment2D((Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)minMax), (Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)minMax));
    }

    public static LineSegment3D nextLineSegment3D(Random random) {
        return new LineSegment3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random), (Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
    }

    public static LineSegment3D nextLineSegment3D(Random random, double minMax) {
        return new LineSegment3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)minMax), (Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)minMax));
    }

    public static BoundingBox2D nextBoundingBox2D(Random random) {
        return EuclidGeometryRandomTools.nextBoundingBox2D(random, 1.0, 1.0);
    }

    public static BoundingBox2D nextBoundingBox2D(Random random, double centerMinMax, double sizeMax) {
        Point2D center = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)centerMinMax);
        Vector2D halfSize = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)(sizeMax / 2.0));
        return BoundingBox2D.createUsingCenterAndPlusMinusVector((Point2DReadOnly)center, (Tuple2DReadOnly)halfSize);
    }

    public static BoundingBox3D nextBoundingBox3D(Random random) {
        return EuclidGeometryRandomTools.nextBoundingBox3D(random, 1.0, 1.0);
    }

    public static BoundingBox3D nextBoundingBox3D(Random random, double centerMinMax, double sizeMax) {
        Point3D center = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)centerMinMax);
        Vector3D halfSize = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.0, (double)(sizeMax / 2.0));
        return BoundingBox3D.createUsingCenterAndPlusMinusVector((Point3DReadOnly)center, (Tuple3DReadOnly)halfSize);
    }

    @Deprecated
    public static Orientation2D nextOrientation2D(Random random) {
        return EuclidCoreRandomTools.nextOrientation2D((Random)random);
    }

    @Deprecated
    public static Orientation2D nextOrientation2D(Random random, double minMax) {
        return EuclidCoreRandomTools.nextOrientation2D((Random)random, (double)minMax);
    }

    public static Plane3D nextPlane3D(Random random) {
        return EuclidGeometryRandomTools.nextPlane3D(random, 1.0);
    }

    public static Plane3D nextPlane3D(Random random, double pointMinMax) {
        Point3D pointOnPlane = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)pointMinMax);
        Vector3D planeNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        return new Plane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
    }

    public static Pose2D nextPose2D(Random random) {
        return new Pose2D((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random), (Orientation2DReadOnly)EuclidCoreRandomTools.nextOrientation2D((Random)random));
    }

    public static Pose2D nextPose2D(Random random, double positionMinMax, double orientationMinMax) {
        return new Pose2D((Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)positionMinMax), (Orientation2DReadOnly)EuclidCoreRandomTools.nextOrientation2D((Random)random, (double)orientationMinMax));
    }

    public static Pose3D nextPose3D(Random random) {
        return new Pose3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random), (Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
    }

    public static Pose3D nextPose3D(Random random, double maxAbsoluteX, double maxAbsoluteY, double maxAbsoluteZ) {
        return new Pose3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)maxAbsoluteX, (double)maxAbsoluteY, (double)maxAbsoluteZ), (Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
    }

    public static Pose3D nextPose3D(Random random, double positionMinMax, double orientationMinMax) {
        return new Pose3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)positionMinMax), (Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random, (double)orientationMinMax));
    }

    public static ConvexPolygon2D nextConvexPolygon2D(Random random) {
        return EuclidGeometryRandomTools.nextConvexPolygon2D(random, 1.0, 10);
    }

    public static ConvexPolygon2D nextConvexPolygon2D(Random random, double maxAbsoluteXY, int numberOfPossiblePoints) {
        List<Point2D> vertices = EuclidGeometryRandomTools.nextPointCloud2D(random, 0.0, maxAbsoluteXY, numberOfPossiblePoints);
        return new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(vertices));
    }

    public static List<Point2D> nextPointCloud2D(Random random, double centerMinMax, double minMax, int numberOfPoints) {
        ArrayList<Point2D> pointCloud2D = new ArrayList<Point2D>();
        Point2D center = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)centerMinMax);
        for (int i = 0; i < numberOfPoints; ++i) {
            Point2D point = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)minMax);
            point.add((Tuple2DReadOnly)center);
            pointCloud2D.add(point);
        }
        return pointCloud2D;
    }

    public static List<Point3D> nextPointCloud3D(Random random, double centerMinMax, double minMax, int numberOfPoints) {
        ArrayList<Point3D> pointCloud3D = new ArrayList<Point3D>();
        Point3D center = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)centerMinMax);
        for (int i = 0; i < numberOfPoints; ++i) {
            Point3D point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)minMax);
            point.add((Tuple3DReadOnly)center);
            pointCloud3D.add(point);
        }
        return pointCloud3D;
    }

    public static List<Point2D> nextCircleBasedConvexPolygon2D(Random random, double centerMinMax, double maxEdgeLength, int numberOfVertices) {
        return EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D(random, (Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)centerMinMax), maxEdgeLength, numberOfVertices);
    }

    public static List<Point2D> nextCircleBasedConvexPolygon2D(Random random, Point2DReadOnly center, double maxEdgeLength, int numberOfVertices) {
        int i;
        if (numberOfVertices == 0) {
            return Collections.emptyList();
        }
        if (numberOfVertices == 1) {
            return Collections.singletonList(new Point2D((Tuple2DReadOnly)center));
        }
        if (numberOfVertices == 2) {
            Vector2D halfEdgeLentgh = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)(0.5 * maxEdgeLength * random.nextDouble()));
            Point2D a = new Point2D();
            Point2D b = new Point2D();
            a.add((Tuple2DReadOnly)center, (Tuple2DReadOnly)halfEdgeLentgh);
            b.sub((Tuple2DReadOnly)center, (Tuple2DReadOnly)halfEdgeLentgh);
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            points.add(a);
            points.add(b);
            return points;
        }
        double[] dTheta = new double[numberOfVertices];
        double sum = 0.0;
        for (int i2 = 0; i2 < numberOfVertices; ++i2) {
            dTheta[i2] = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.001, (double)1.0);
            sum += dTheta[i2];
        }
        double scale = Math.PI * 2 / (sum += random.nextDouble());
        int i3 = 0;
        while (i3 < numberOfVertices) {
            int n = i3++;
            dTheta[n] = dTheta[n] * scale;
        }
        ArrayList<Point2D> clockwiseVertices = new ArrayList<Point2D>();
        double theta = 0.0;
        double yaw = EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI);
        clockwiseVertices.add(new Point2D(EuclidCoreTools.cos((double)yaw), EuclidCoreTools.sin((double)yaw)));
        for (int i4 = 1; i4 < numberOfVertices; ++i4) {
            double x = EuclidCoreTools.cos((double)((theta -= dTheta[i4]) + yaw));
            double y = EuclidCoreTools.sin((double)(theta + yaw));
            clockwiseVertices.add(new Point2D(x, y));
        }
        double currentMaxEdgeLength = 0.0;
        for (i = 0; i < numberOfVertices; ++i) {
            Point2D vertex = (Point2D)clockwiseVertices.get(i);
            Point2D nextVertex = (Point2D)clockwiseVertices.get((i + 1) % numberOfVertices);
            currentMaxEdgeLength = Math.max(currentMaxEdgeLength, vertex.distance((Point2DReadOnly)nextVertex));
        }
        scale = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.5, (double)1.0) * maxEdgeLength / currentMaxEdgeLength;
        for (i = 0; i < numberOfVertices; ++i) {
            ((Point2D)clockwiseVertices.get(i)).scale(scale);
        }
        int indexOfFirstVertex = 0;
        Point2D firstVertex = (Point2D)clockwiseVertices.get(0);
        for (int i5 = 0; i5 < numberOfVertices; ++i5) {
            Point2D currentVertex = (Point2D)clockwiseVertices.get(i5);
            if (firstVertex.getX() > currentVertex.getX()) {
                firstVertex = currentVertex;
                indexOfFirstVertex = i5;
                continue;
            }
            if (firstVertex.getX() != currentVertex.getX() || !(firstVertex.getY() < currentVertex.getY())) continue;
            firstVertex = currentVertex;
            indexOfFirstVertex = i5;
        }
        ArrayList<Point2D> convexPolygon2D = new ArrayList<Point2D>();
        for (int i6 = 0; i6 < numberOfVertices; ++i6) {
            int indexInOtherList = (i6 + indexOfFirstVertex) % numberOfVertices;
            Point2D vertex = (Point2D)clockwiseVertices.get(indexInOtherList);
            vertex.add((Tuple2DReadOnly)center);
            convexPolygon2D.add(vertex);
        }
        return convexPolygon2D;
    }

    public static Triangle3D nextTriangle3D(Random random) {
        return EuclidGeometryRandomTools.nextTriangle3D(random, 1.0);
    }

    public static Triangle3D nextTriangle3D(Random random, double minMax) {
        return new Triangle3D((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)minMax), (Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)minMax), (Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)minMax));
    }

    public static Vertex2DSupplier nextVertex2DSupplier(Random random) {
        return EuclidGeometryRandomTools.nextVertex2DSupplier(random, 20);
    }

    public static Vertex2DSupplier nextVertex2DSupplier(Random random, int numberOfVertices) {
        List vertices = IntStream.range(0, numberOfVertices).mapToObj(i -> EuclidCoreRandomTools.nextPoint2D((Random)random)).collect(Collectors.toList());
        return Vertex2DSupplier.asVertex2DSupplier(vertices);
    }

    public static Vertex3DSupplier nextVertex3DSupplier(Random random) {
        return EuclidGeometryRandomTools.nextVertex3DSupplier(random, 20);
    }

    public static Vertex3DSupplier nextVertex3DSupplier(Random random, int numberOfVertices) {
        List vertices = IntStream.range(0, numberOfVertices).mapToObj(i -> EuclidCoreRandomTools.nextPoint3D((Random)random)).collect(Collectors.toList());
        return Vertex3DSupplier.asVertex3DSupplier(vertices);
    }

    public static Point2D nextPoint2DInTriangle(Random random, Point2DReadOnly a, Point2DReadOnly b, Point2DReadOnly c) {
        return new Point2D((Tuple3DReadOnly)EuclidGeometryRandomTools.nextPoint3DInTriangle(random, (Point3DReadOnly)new Point3D((Tuple2DReadOnly)a), (Point3DReadOnly)new Point3D((Tuple2DReadOnly)b), (Point3DReadOnly)new Point3D((Tuple2DReadOnly)c)));
    }

    public static Point3D nextPoint3DInTriangle(Random random, Point3DReadOnly a, Point3DReadOnly b, Point3DReadOnly c) {
        double alpha1;
        double alpha0 = random.nextDouble();
        if (alpha0 + (alpha1 = random.nextDouble()) > 1.0) {
            alpha0 = 1.0 - alpha0;
            alpha1 = 1.0 - alpha1;
        }
        Vector3D v0 = new Vector3D();
        Vector3D v1 = new Vector3D();
        v0.sub((Tuple3DReadOnly)b, (Tuple3DReadOnly)a);
        v1.sub((Tuple3DReadOnly)c, (Tuple3DReadOnly)a);
        Point3D next = new Point3D((Tuple3DReadOnly)a);
        next.scaleAdd(alpha0, (Tuple3DReadOnly)v0, (Tuple3DReadOnly)next);
        next.scaleAdd(alpha1, (Tuple3DReadOnly)v1, (Tuple3DReadOnly)next);
        return next;
    }

    public static Point3D nextPoint3DInTetrahedron(Random random, Point3DReadOnly a, Point3DReadOnly b, Point3DReadOnly c, Point3DReadOnly d) {
        double s = random.nextDouble();
        double t = random.nextDouble();
        double u = random.nextDouble();
        if (s + t > 1.0) {
            s = 1.0 - s;
            t = 1.0 - t;
        }
        if (s + t + u > 1.0) {
            if (t + u > 1.0) {
                double tOld = t;
                t = 1.0 - u;
                u = 1.0 - s - tOld;
            } else {
                double sOld = s;
                s = 1.0 - t - u;
                u = sOld + t + u - 1.0;
            }
        }
        Vector3D v0 = new Vector3D();
        Vector3D v1 = new Vector3D();
        Vector3D v2 = new Vector3D();
        v0.sub((Tuple3DReadOnly)b, (Tuple3DReadOnly)a);
        v1.sub((Tuple3DReadOnly)c, (Tuple3DReadOnly)a);
        v2.sub((Tuple3DReadOnly)d, (Tuple3DReadOnly)a);
        Point3D next = new Point3D((Tuple3DReadOnly)a);
        next.scaleAdd(s, (Tuple3DReadOnly)v0, (Tuple3DReadOnly)next);
        next.scaleAdd(t, (Tuple3DReadOnly)v1, (Tuple3DReadOnly)next);
        next.scaleAdd(u, (Tuple3DReadOnly)v2, (Tuple3DReadOnly)next);
        return next;
    }

    public static Point3D nextWeightedAverage(Random random, Collection<? extends Point3DReadOnly> points) {
        return EuclidGeometryRandomTools.nextWeightedAverage(random, points.toArray(new Point3DReadOnly[points.size()]));
    }

    public static Point3D nextWeightedAverage(Random random, Point3DReadOnly[] points) {
        double sum = 0.0;
        Point3D next = new Point3D();
        for (int j = 0; j < points.length; ++j) {
            double weight = random.nextDouble();
            sum += weight;
            next.scaleAdd(weight, (Tuple3DReadOnly)points[j], (Tuple3DReadOnly)next);
        }
        next.scale(1.0 / sum);
        return next;
    }
}

