/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public interface Vertex2DSupplier {
    public static final Vertex2DSupplier EMPTY_SUPPLIER = new Vertex2DSupplier(){

        @Override
        public Point2DReadOnly getVertex(int index) {
            return null;
        }

        @Override
        public int getNumberOfVertices() {
            return 0;
        }
    };

    public Point2DReadOnly getVertex(int var1);

    public int getNumberOfVertices();

    default public boolean isEmpty() {
        return this.getNumberOfVertices() == 0;
    }

    default public boolean equals(Vertex2DSupplier other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (this.getVertex(i).equals((Tuple2DReadOnly)other.getVertex(i))) continue;
            return false;
        }
        return true;
    }

    default public boolean epsilonEquals(Vertex2DSupplier other, double epsilon) {
        if (this.getNumberOfVertices() != other.getNumberOfVertices()) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            if (this.getVertex(i).epsilonEquals((Tuple2DReadOnly)other.getVertex(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public static Vertex2DSupplier emptyVertex2DSupplier() {
        return EMPTY_SUPPLIER;
    }

    public static Vertex2DSupplier asVertex2DSupplier(Point2DReadOnly ... vertices) {
        return Vertex2DSupplier.asVertex2DSupplier(Arrays.asList(vertices));
    }

    public static Vertex2DSupplier asVertex2DSupplier(Point2DReadOnly[] vertices, int numberOfVertices) {
        return Vertex2DSupplier.asVertex2DSupplier(Arrays.asList(vertices), numberOfVertices);
    }

    public static Vertex2DSupplier asVertex2DSupplier(Point2DReadOnly[] vertices, int startIndex, int numberOfVertices) {
        if (numberOfVertices == 0) {
            return Vertex2DSupplier.emptyVertex2DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.length) {
            throw new IllegalArgumentException("The array is too small. Array length = " + vertices.length + ", expected minimum length = " + (startIndex + numberOfVertices));
        }
        return Vertex2DSupplier.asVertex2DSupplier(Arrays.asList(vertices), startIndex, numberOfVertices);
    }

    public static Vertex2DSupplier asVertex2DSupplier(List<? extends Point2DReadOnly> vertices) {
        return Vertex2DSupplier.asVertex2DSupplier(vertices, vertices.size());
    }

    public static Vertex2DSupplier asVertex2DSupplier(List<? extends Point2DReadOnly> vertices, int numberOfVertices) {
        return Vertex2DSupplier.asVertex2DSupplier(vertices, 0, numberOfVertices);
    }

    public static Vertex2DSupplier asVertex2DSupplier(final List<? extends Point2DReadOnly> vertices, final int startIndex, final int numberOfVertices) {
        if (numberOfVertices == 0) {
            return Vertex2DSupplier.emptyVertex2DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.size()) {
            throw new IllegalArgumentException("The list is too small. List size = " + vertices.size() + ", expected minimum size = " + (startIndex + numberOfVertices));
        }
        return new Vertex2DSupplier(){

            @Override
            public Point2DReadOnly getVertex(int index) {
                return (Point2DReadOnly)vertices.get(index + startIndex);
            }

            @Override
            public int getNumberOfVertices() {
                return numberOfVertices;
            }

            public String toString() {
                return "Vertex 2D Supplier: " + vertices.subList(startIndex, startIndex + numberOfVertices).toString();
            }
        };
    }

    public static Vertex2DSupplier asVertex2DSupplier(double[][] vertices) {
        return Vertex2DSupplier.asVertex2DSupplier(vertices, vertices.length);
    }

    public static Vertex2DSupplier asVertex2DSupplier(double[][] vertices, int numberOfVertices) {
        return Vertex2DSupplier.asVertex2DSupplier(vertices, 0, numberOfVertices);
    }

    public static Vertex2DSupplier asVertex2DSupplier(final double[][] vertices, final int startIndex, final int numberOfVertices) {
        if (numberOfVertices == 0) {
            return Vertex2DSupplier.emptyVertex2DSupplier();
        }
        if (startIndex + numberOfVertices > vertices.length) {
            throw new IllegalArgumentException("The array is too small. Array length = " + vertices.length + ", expected minimum length = " + (startIndex + numberOfVertices));
        }
        return new Vertex2DSupplier(){

            @Override
            public Point2DReadOnly getVertex(final int index) {
                return new Point2DReadOnly(){

                    public double getX() {
                        return vertices[startIndex + index][0];
                    }

                    public double getY() {
                        return vertices[startIndex + index][1];
                    }

                    public String toString() {
                        return EuclidCoreIOTools.getTuple2DString((Tuple2DReadOnly)this);
                    }
                };
            }

            @Override
            public int getNumberOfVertices() {
                return numberOfVertices;
            }

            public String toString() {
                StringJoiner joiner = new StringJoiner("[", ", ", "]");
                Arrays.stream(vertices).forEach(v -> joiner.add(EuclidCoreIOTools.getStringOf((String)"(", (String)")", (String)", ", (double[])new double[]{v[0], v[1]})));
                return "Vertex 2D Supplier: " + joiner;
            }
        };
    }
}

