/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.orientation.interfaces.Orientation2DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public interface Pose2DReadOnly {
    default public double getX() {
        return this.getPosition().getX();
    }

    default public double getY() {
        return this.getPosition().getY();
    }

    default public double getYaw() {
        return this.getOrientation().getYaw();
    }

    default public boolean containsNaN() {
        return this.getPosition().containsNaN() || this.getOrientation().containsNaN();
    }

    public Point2DReadOnly getPosition();

    public Orientation2DReadOnly getOrientation();

    default public void get(RigidBodyTransformBasics transformToPack) {
        transformToPack.getTranslation().set(this.getX(), this.getY(), 0.0);
        transformToPack.getRotation().setToYawOrientation(this.getYaw());
    }

    @Deprecated
    default public double getPositionDistance(Point2DReadOnly point) {
        return this.getPosition().distance(point);
    }

    @Deprecated
    default public double getPositionDistance(Pose2DReadOnly other) {
        return this.getPosition().distance(other.getPosition());
    }

    @Deprecated
    default public double getOrientationDistance(Orientation2DReadOnly other) {
        return this.getOrientation().distance(other);
    }

    @Deprecated
    default public double getOrientationDistance(Pose2DReadOnly other) {
        return this.getOrientation().distance(other.getOrientation());
    }

    default public boolean equals(Pose2DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getPosition().equals((Tuple2DReadOnly)other.getPosition()) && this.getOrientation().equals(other.getOrientation());
    }

    default public boolean epsilonEquals(Pose2DReadOnly other, double epsilon) {
        return this.getPosition().epsilonEquals((Tuple2DReadOnly)other.getPosition(), epsilon) && this.getOrientation().epsilonEquals(other.getOrientation(), epsilon);
    }

    default public boolean geometricallyEquals(Pose2DReadOnly other, double epsilon) {
        return this.getPosition().geometricallyEquals(other.getPosition(), epsilon) && this.getOrientation().geometricallyEquals(other.getOrientation(), epsilon);
    }
}

