/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface Plane3DReadOnly {
    public Point3DReadOnly getPoint();

    public UnitVector3DReadOnly getNormal();

    default public double getPointX() {
        return this.getPoint().getX();
    }

    default public double getPointY() {
        return this.getPoint().getY();
    }

    default public double getPointZ() {
        return this.getPoint().getZ();
    }

    default public double getNormalX() {
        return this.getNormal().getX();
    }

    default public double getNormalY() {
        return this.getNormal().getY();
    }

    default public double getNormalZ() {
        return this.getNormal().getZ();
    }

    default public boolean containsNaN() {
        return this.getPoint().containsNaN() || this.getNormal().containsNaN();
    }

    default public double distance(double pointX, double pointY, double pointZ) {
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D(pointX, pointY, pointZ, this.getPoint(), (Vector3DReadOnly)this.getNormal());
    }

    default public double distance(Point3DReadOnly point) {
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D(point, this.getPoint(), (Vector3DReadOnly)this.getNormal());
    }

    default public double signedDistance(Point3DReadOnly point) {
        return EuclidGeometryTools.signedDistanceFromPoint3DToPlane3D(point, this.getPoint(), (Vector3DReadOnly)this.getNormal());
    }

    default public double getZOnPlane(double pointX, double pointY) {
        double x0 = this.getPointX();
        double y0 = this.getPointY();
        double z0 = this.getPointZ();
        double a = this.getNormalX();
        double b = this.getNormalY();
        double c = this.getNormalZ();
        double z = a / c * (x0 - pointX) + b / c * (y0 - pointY) + z0;
        return z;
    }

    default public boolean intersectionWith(Line3DReadOnly line, Point3DBasics intersectionToPack) {
        return this.intersectionWith(intersectionToPack, line.getPoint(), (Vector3DReadOnly)line.getDirection());
    }

    default public boolean intersectionWith(Point3DBasics intersectionToPack, Point3DReadOnly pointOnLine, Vector3DReadOnly lineDirection) {
        return EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D(this.getPoint(), (Vector3DReadOnly)this.getNormal(), pointOnLine, lineDirection, intersectionToPack);
    }

    default public boolean isCoincident(Plane3DReadOnly otherPlane, double angleEpsilon, double distanceEpsilon) {
        return EuclidGeometryTools.arePlane3DsCoincident(this.getPoint(), (Vector3DReadOnly)this.getNormal(), otherPlane.getPoint(), (Vector3DReadOnly)otherPlane.getNormal(), angleEpsilon, distanceEpsilon);
    }

    default public boolean isOnOrAbove(double x, double y, double z) {
        return this.isOnOrAbove(x, y, z, 0.0);
    }

    default public boolean isOnOrAbove(double pointX, double pointY, double pointZ, double epsilon) {
        double dz;
        double dy;
        double dx = (pointX - this.getPointX()) * this.getNormalX();
        return dx + (dy = (pointY - this.getPointY()) * this.getNormalY()) + (dz = (pointZ - this.getPointZ()) * this.getNormalZ()) >= -epsilon;
    }

    default public boolean isOnOrAbove(Point3DReadOnly pointToTest) {
        return this.isOnOrAbove(pointToTest, 0.0);
    }

    default public boolean isOnOrAbove(Point3DReadOnly pointToTest, double epsilon) {
        return this.isOnOrAbove(pointToTest.getX(), pointToTest.getY(), pointToTest.getZ(), epsilon);
    }

    default public boolean isOnOrBelow(double pointX, double pointY, double pointZ) {
        return this.isOnOrBelow(pointX, pointY, pointZ, 0.0);
    }

    default public boolean isOnOrBelow(double pointX, double pointY, double pointZ, double epsilon) {
        double dz;
        double dy;
        double dx = (pointX - this.getPointX()) * this.getNormalX();
        return dx + (dy = (pointY - this.getPointY()) * this.getNormalY()) + (dz = (pointZ - this.getPointZ()) * this.getNormalZ()) <= epsilon;
    }

    default public boolean isOnOrBelow(Point3DReadOnly pointToTest) {
        return this.isOnOrBelow(pointToTest, 0.0);
    }

    default public boolean isOnOrBelow(Point3DReadOnly pointToTest, double epsilon) {
        return this.isOnOrBelow(pointToTest.getX(), pointToTest.getY(), pointToTest.getZ(), epsilon);
    }

    default public boolean isParallel(Plane3DReadOnly otherPlane, double angleEpsilon) {
        return EuclidGeometryTools.areVector3DsParallel((Vector3DReadOnly)this.getNormal(), (Vector3DReadOnly)otherPlane.getNormal(), angleEpsilon);
    }

    default public boolean orthogonalProjection(Point3DBasics pointToProject) {
        return this.orthogonalProjection((Point3DReadOnly)pointToProject, pointToProject);
    }

    default public boolean orthogonalProjection(double pointX, double pointY, double pointZ, Point3DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnPlane3D(pointX, pointY, pointZ, this.getPoint(), (Vector3DReadOnly)this.getNormal(), projectionToPack);
    }

    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnPlane3D(pointToProject, this.getPoint(), (Vector3DReadOnly)this.getNormal(), projectionToPack);
    }

    default public Point3DBasics orthogonalProjectionCopy(Point3DReadOnly pointToProject) {
        return EuclidGeometryTools.orthogonalProjectionOnPlane3D(pointToProject, this.getPoint(), (Vector3DReadOnly)this.getNormal());
    }

    default public boolean epsilonEquals(Plane3DReadOnly other, double epsilon) {
        return other.getNormal().epsilonEquals((Tuple3DReadOnly)this.getNormal(), epsilon) && other.getPoint().epsilonEquals((Tuple3DReadOnly)this.getPoint(), epsilon);
    }

    default public boolean equals(Plane3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getPoint().equals((Tuple3DReadOnly)other.getPoint()) && this.getNormal().equals((Tuple3DReadOnly)other.getNormal());
    }
}

