/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry.interfaces;

import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;

public interface LineSegment3DReadOnly {
    public Point3DReadOnly getFirstEndpoint();

    public Point3DReadOnly getSecondEndpoint();

    default public void get(Point3DBasics firstEndpointToPack, Point3DBasics secondEndpointToPack) {
        firstEndpointToPack.set((Tuple3DReadOnly)this.getFirstEndpoint());
        secondEndpointToPack.set((Tuple3DReadOnly)this.getSecondEndpoint());
    }

    default public double getFirstEndpointX() {
        return this.getFirstEndpoint().getX();
    }

    default public double getFirstEndpointY() {
        return this.getFirstEndpoint().getY();
    }

    default public double getFirstEndpointZ() {
        return this.getFirstEndpoint().getZ();
    }

    default public double getSecondEndpointX() {
        return this.getSecondEndpoint().getX();
    }

    default public double getSecondEndpointY() {
        return this.getSecondEndpoint().getY();
    }

    default public double getSecondEndpointZ() {
        return this.getSecondEndpoint().getZ();
    }

    @Deprecated
    default public boolean firstEndpointContainsNaN() {
        return this.getFirstEndpoint().containsNaN();
    }

    @Deprecated
    default public boolean secondEndpointContainsNaN() {
        return this.getSecondEndpoint().containsNaN();
    }

    default public double length() {
        return this.getFirstEndpoint().distance(this.getSecondEndpoint());
    }

    default public double lengthSquared() {
        return this.getFirstEndpoint().distanceSquared(this.getSecondEndpoint());
    }

    default public double distanceSquared(Point3DReadOnly point) {
        return EuclidGeometryTools.distanceSquaredFromPoint3DToLineSegment3D(point, this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public double distance(Point3DReadOnly point) {
        return EuclidGeometryTools.distanceFromPoint3DToLineSegment3D(point, this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public double distance(LineSegment3DReadOnly otherLineSegment) {
        return EuclidGeometryTools.distanceBetweenTwoLineSegment3Ds(this.getFirstEndpoint(), this.getSecondEndpoint(), otherLineSegment.getFirstEndpoint(), otherLineSegment.getSecondEndpoint());
    }

    default public Point3DBasics orthogonalProjectionCopy(Point3DReadOnly pointToProject) {
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment3D(pointToProject, this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public boolean orthogonalProjection(Point3DBasics pointToProject) {
        return this.orthogonalProjection((Point3DReadOnly)pointToProject, pointToProject);
    }

    default public boolean orthogonalProjection(Point3DReadOnly pointToProject, Point3DBasics projectionToPack) {
        return EuclidGeometryTools.orthogonalProjectionOnLineSegment3D(pointToProject, this.getFirstEndpoint(), this.getSecondEndpoint(), projectionToPack);
    }

    default public Point3DBasics pointBetweenEndpointsGivenPercentage(double percentage) {
        Point3D point = new Point3D();
        this.pointBetweenEndpointsGivenPercentage(percentage, (Point3DBasics)point);
        return point;
    }

    default public void pointBetweenEndpointsGivenPercentage(double percentage, Point3DBasics pointToPack) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new RuntimeException("Percentage must be between 0.0 and 1.0. Was: " + percentage);
        }
        pointToPack.interpolate((Tuple3DReadOnly)this.getFirstEndpoint(), (Tuple3DReadOnly)this.getSecondEndpoint(), percentage);
    }

    default public Point3DBasics pointOnLineGivenPercentage(double percentage) {
        Point3D point = new Point3D();
        this.pointOnLineGivenPercentage(percentage, (Point3DBasics)point);
        return point;
    }

    default public void pointOnLineGivenPercentage(double percentage, Point3DBasics pointToPack) {
        pointToPack.interpolate((Tuple3DReadOnly)this.getFirstEndpoint(), (Tuple3DReadOnly)this.getSecondEndpoint(), percentage);
    }

    default public Point3DBasics midpoint() {
        Point3D midpoint = new Point3D();
        this.midpoint((Point3DBasics)midpoint);
        return midpoint;
    }

    default public void midpoint(Point3DBasics midpointToPack) {
        midpointToPack.interpolate((Tuple3DReadOnly)this.getFirstEndpoint(), (Tuple3DReadOnly)this.getSecondEndpoint(), 0.5);
    }

    default public void getDirection(boolean normalize, Vector3DBasics directionToPack) {
        directionToPack.sub((Tuple3DReadOnly)this.getSecondEndpoint(), (Tuple3DReadOnly)this.getFirstEndpoint());
        if (normalize) {
            directionToPack.normalize();
        }
    }

    default public Vector3DBasics getDirection(boolean normalize) {
        Vector3D direction = new Vector3D();
        this.getDirection(normalize, (Vector3DBasics)direction);
        return direction;
    }

    default public boolean isBetweenEndpoints(Point3DReadOnly point) {
        return this.isBetweenEndpoints(point, 0.0);
    }

    default public boolean isBetweenEndpoints(Point3DReadOnly point, double epsilon) {
        return this.isBetweenEndpoints(point.getX(), point.getY(), point.getZ(), epsilon);
    }

    default public boolean isBetweenEndpoints(double x, double y, double z, double epsilon) {
        double alpha = this.percentageAlongLineSegment(x, y, z);
        if (alpha < epsilon) {
            return false;
        }
        return !(alpha > 1.0 - epsilon);
    }

    default public double percentageAlongLineSegment(Point3DReadOnly point) {
        return this.percentageAlongLineSegment(point.getX(), point.getY(), point.getZ());
    }

    default public double percentageAlongLineSegment(double x, double y, double z) {
        return EuclidGeometryTools.percentageAlongLineSegment3D(x, y, z, this.getFirstEndpoint(), this.getSecondEndpoint());
    }

    default public double dotProduct(LineSegment3DReadOnly other) {
        return EuclidGeometryTools.dotProduct(this.getFirstEndpoint(), this.getSecondEndpoint(), other.getFirstEndpoint(), other.getSecondEndpoint());
    }

    default public boolean epsilonEquals(LineSegment3DReadOnly other, double epsilon) {
        return this.getFirstEndpoint().epsilonEquals((Tuple3DReadOnly)other.getFirstEndpoint(), epsilon) && this.getSecondEndpoint().epsilonEquals((Tuple3DReadOnly)other.getSecondEndpoint(), epsilon);
    }

    default public boolean equals(LineSegment3DReadOnly other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getFirstEndpoint().equals((Tuple3DReadOnly)other.getFirstEndpoint()) && this.getSecondEndpoint().equals((Tuple3DReadOnly)other.getSecondEndpoint());
    }

    default public boolean geometricallyEquals(LineSegment3DReadOnly other, double epsilon) {
        if (this.getFirstEndpoint().geometricallyEquals(other.getFirstEndpoint(), epsilon) && this.getSecondEndpoint().geometricallyEquals(other.getSecondEndpoint(), epsilon)) {
            return true;
        }
        return this.getFirstEndpoint().geometricallyEquals(other.getSecondEndpoint(), epsilon) && this.getSecondEndpoint().geometricallyEquals(other.getFirstEndpoint(), epsilon);
    }
}

