/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Plane3DBasics;
import us.ihmc.euclid.geometry.interfaces.Plane3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class Plane3D
implements Plane3DBasics,
GeometryObject<Plane3D> {
    private final Point3D point = new Point3D();
    private final UnitVector3D normal = new UnitVector3D((Tuple3DReadOnly)Axis3D.Z);

    public Plane3D() {
    }

    public Plane3D(double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeNormalX, double planeNormalY, double planeNormalZ) {
        this.set(pointOnPlaneX, pointOnPlaneY, pointOnPlaneZ, planeNormalX, planeNormalY, planeNormalZ);
    }

    public Plane3D(Plane3D other) {
        this.set(other);
    }

    public Plane3D(Point3DReadOnly firstPointOnPlane, Point3DReadOnly secondPointOnPlane, Point3DReadOnly thirdPointOnPlane) {
        this.set(firstPointOnPlane, secondPointOnPlane, thirdPointOnPlane);
    }

    public Plane3D(Point3DReadOnly pointOnPlane, Vector3DReadOnly planeNormal) {
        this.set(pointOnPlane, planeNormal);
    }

    @Override
    public UnitVector3DBasics getNormal() {
        return this.normal;
    }

    @Deprecated
    public void getNormal(Vector3DBasics planeNormalToPack) {
        planeNormalToPack.set((Tuple3DReadOnly)this.normal);
    }

    @Deprecated
    public Vector3D getNormalCopy() {
        return new Vector3D((Tuple3DReadOnly)this.normal);
    }

    @Override
    public Point3DBasics getPoint() {
        return this.point;
    }

    @Deprecated
    public void getPoint(Point3DBasics pointOnPlaneToPack) {
        pointOnPlaneToPack.set((Tuple3DReadOnly)this.point);
    }

    @Deprecated
    public Point3D getPointCopy() {
        return new Point3D((Tuple3DReadOnly)this.point);
    }

    public void set(Plane3D other) {
        Plane3DBasics.super.set(other);
    }

    @Deprecated
    public void setNormal(double normalX, double normalY, double normalZ) {
        this.normal.set(normalX, normalY, normalZ);
    }

    @Deprecated
    public void setNormal(Vector3DReadOnly planeNormal) {
        this.setNormal(planeNormal.getX(), planeNormal.getY(), planeNormal.getZ());
    }

    @Deprecated
    public void setPoint(double pointX, double pointY, double pointZ) {
        this.point.set(pointX, pointY, pointZ);
    }

    @Deprecated
    public void setPoint(Point3DReadOnly pointOnPlane) {
        this.setPoint(pointOnPlane.getX(), pointOnPlane.getY(), pointOnPlane.getZ());
    }

    public boolean epsilonEquals(Plane3D other, double epsilon) {
        return Plane3DBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(Plane3D other, double epsilon) {
        return this.isCoincident(other, epsilon, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof Plane3DReadOnly) {
            return Plane3DBasics.super.equals((Plane3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.point, (Object)this.normal);
    }

    public String toString() {
        return EuclidGeometryIOTools.getPlane3DString(this);
    }
}

