/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import us.ihmc.euclid.geometry.interfaces.LineSegment3DBasics;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.interfaces.GeometryObject;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;

public class LineSegment3D
implements LineSegment3DBasics,
GeometryObject<LineSegment3D> {
    private final Point3D firstEndpoint = new Point3D();
    private final Point3D secondEndpoint = new Point3D();

    public LineSegment3D() {
    }

    public LineSegment3D(LineSegment3DReadOnly other) {
        this.set(other);
    }

    public LineSegment3D(Point3DReadOnly firstEndpoint, Point3DReadOnly secondEndpoint) {
        this.set(firstEndpoint, secondEndpoint);
    }

    public LineSegment3D(double firstEndpointX, double firstEndpointY, double firstEndpointZ, double secondEndpointX, double secondEndpointY, double secondEndpointZ) {
        this.set(firstEndpointX, firstEndpointY, firstEndpointZ, secondEndpointX, secondEndpointY, secondEndpointZ);
    }

    public void set(LineSegment3D other) {
        LineSegment3DBasics.super.set(other);
    }

    @Override
    public Point3DBasics getFirstEndpoint() {
        return this.firstEndpoint;
    }

    @Override
    public Point3DBasics getSecondEndpoint() {
        return this.secondEndpoint;
    }

    public boolean epsilonEquals(LineSegment3D other, double epsilon) {
        return LineSegment3DBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof LineSegment3DReadOnly) {
            return this.equals((LineSegment3DReadOnly)object);
        }
        return false;
    }

    public boolean geometricallyEquals(LineSegment3D other, double epsilon) {
        return LineSegment3DBasics.super.geometricallyEquals(other, epsilon);
    }

    public String toString() {
        return EuclidGeometryIOTools.getLineSegment3DString(this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.firstEndpoint, (Object)this.secondEndpoint);
    }
}

