/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.geometry;

import us.ihmc.euclid.geometry.interfaces.BoundingBox2DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.GeometricallyComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;

public class BoundingBox2D
implements BoundingBox2DBasics,
EpsilonComparable<BoundingBox2D>,
Settable<BoundingBox2D>,
GeometricallyComparable<BoundingBox2D> {
    private final Point2D minPoint = new Point2D();
    private final Point2D maxPoint = new Point2D();

    public static BoundingBox2D createUsingCenterAndPlusMinusVector(Point2DReadOnly center, Tuple2DReadOnly plusMinusTuple) {
        BoundingBox2D boundingBox2D = new BoundingBox2D();
        boundingBox2D.set(center, (Vector2DReadOnly)new Vector2D(plusMinusTuple));
        return boundingBox2D;
    }

    public static BoundingBox2D union(BoundingBox2DReadOnly boundingBoxOne, BoundingBox2DReadOnly boundingBoxTwo) {
        BoundingBox2D union = new BoundingBox2D();
        union.combine(boundingBoxOne, boundingBoxTwo);
        return union;
    }

    public BoundingBox2D() {
        this.setToNaN();
    }

    public BoundingBox2D(Point2DReadOnly min, Point2DReadOnly max) {
        this.set(min, max);
    }

    public BoundingBox2D(BoundingBox2DReadOnly other) {
        this.set(other);
    }

    public BoundingBox2D(double[] min, double[] max) {
        this.set(min, max);
    }

    public BoundingBox2D(double minX, double minY, double maxX, double maxY) {
        this.set(minX, minY, maxX, maxY);
    }

    public void set(BoundingBox2D other) {
        BoundingBox2DBasics.super.set(other);
    }

    public Point2D getMinPoint() {
        return this.minPoint;
    }

    public Point2D getMaxPoint() {
        return this.maxPoint;
    }

    public boolean epsilonEquals(BoundingBox2D other, double epsilon) {
        return BoundingBox2DBasics.super.epsilonEquals(other, epsilon);
    }

    public boolean geometricallyEquals(BoundingBox2D other, double epsilon) {
        return BoundingBox2DBasics.super.geometricallyEquals(other, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof BoundingBox2DReadOnly) {
            return BoundingBox2DBasics.super.equals((BoundingBox2DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.minPoint, (Object)this.maxPoint);
    }

    public String toString() {
        return EuclidGeometryIOTools.getBoundingBox2DString(this);
    }
}

