/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCAuthenticationError;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.UriUtils;
import org.keycloak.enums.TokenStore;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.util.TokenUtil;

public class OAuthRequestAuthenticator {
    private static final Logger log = Logger.getLogger(OAuthRequestAuthenticator.class);
    protected KeycloakDeployment deployment;
    protected RequestAuthenticator reqAuthenticator;
    protected int sslRedirectPort;
    protected AdapterSessionStore tokenStore;
    protected String tokenString;
    protected String idTokenString;
    protected IDToken idToken;
    protected AccessToken token;
    protected HttpFacade facade;
    protected AuthChallenge challenge;
    protected String refreshToken;
    protected String strippedOauthParametersRequestUri;

    public OAuthRequestAuthenticator(RequestAuthenticator requestAuthenticator, HttpFacade facade, KeycloakDeployment deployment, int sslRedirectPort, AdapterSessionStore tokenStore) {
        this.reqAuthenticator = requestAuthenticator;
        this.facade = facade;
        this.deployment = deployment;
        this.sslRedirectPort = deployment.getConfidentialPort() != -1 ? deployment.getConfidentialPort() : sslRedirectPort;
        this.tokenStore = tokenStore;
    }

    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getIdTokenString() {
        return this.idTokenString;
    }

    public void setIdTokenString(String idTokenString) {
        this.idTokenString = idTokenString;
    }

    public IDToken getIdToken() {
        return this.idToken;
    }

    public void setIdToken(IDToken idToken) {
        this.idToken = idToken;
    }

    public String getStrippedOauthParametersRequestUri() {
        return this.strippedOauthParametersRequestUri;
    }

    public void setStrippedOauthParametersRequestUri(String strippedOauthParametersRequestUri) {
        this.strippedOauthParametersRequestUri = strippedOauthParametersRequestUri;
    }

    protected String getRequestUrl() {
        return this.facade.getRequest().getURI();
    }

    protected boolean isRequestSecure() {
        return this.facade.getRequest().isSecure();
    }

    protected HttpFacade.Cookie getCookie(String cookieName) {
        return this.facade.getRequest().getCookie(cookieName);
    }

    protected String getCookieValue(String cookieName) {
        HttpFacade.Cookie cookie = this.getCookie(cookieName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    protected String getQueryParamValue(String paramName) {
        return this.facade.getRequest().getQueryParamValue(paramName);
    }

    protected String getError() {
        return this.getQueryParamValue("error");
    }

    protected String getCode() {
        return this.getQueryParamValue("code");
    }

    protected String getRedirectUri(String state) {
        String url = this.getRequestUrl();
        log.debugf("callback uri: %s", (Object)url);
        if (!this.facade.getRequest().isSecure() && this.deployment.getSslRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            int port = this.sslRedirectPort();
            if (port < 0) {
                return null;
            }
            KeycloakUriBuilder secureUrl = KeycloakUriBuilder.fromUri((String)url).scheme("https").port(-1);
            if (port != 443) {
                secureUrl.port(port);
            }
            url = secureUrl.buildAsString(new Object[0]);
        }
        String loginHint = this.getQueryParamValue("login_hint");
        url = UriUtils.stripQueryParam((String)url, (String)"login_hint");
        String idpHint = this.getQueryParamValue("kc_idp_hint");
        url = UriUtils.stripQueryParam((String)url, (String)"kc_idp_hint");
        String scope = this.getQueryParamValue("scope");
        url = UriUtils.stripQueryParam((String)url, (String)"scope");
        String prompt = this.getQueryParamValue("prompt");
        url = UriUtils.stripQueryParam((String)url, (String)"prompt");
        String maxAge = this.getQueryParamValue("max_age");
        url = UriUtils.stripQueryParam((String)url, (String)"max_age");
        String uiLocales = this.getQueryParamValue("ui_locales");
        url = UriUtils.stripQueryParam((String)url, (String)"ui_locales");
        KeycloakUriBuilder redirectUriBuilder = this.deployment.getAuthUrl().clone().queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("redirect_uri", new Object[]{this.rewrittenRedirectUri(url)}).queryParam("state", new Object[]{state}).queryParam("login", new Object[]{"true"});
        if (loginHint != null && loginHint.length() > 0) {
            redirectUriBuilder.queryParam("login_hint", new Object[]{loginHint});
        }
        if (idpHint != null && idpHint.length() > 0) {
            redirectUriBuilder.queryParam("kc_idp_hint", new Object[]{idpHint});
        }
        if (prompt != null && prompt.length() > 0) {
            redirectUriBuilder.queryParam("prompt", new Object[]{prompt});
        }
        if (maxAge != null && maxAge.length() > 0) {
            redirectUriBuilder.queryParam("max_age", new Object[]{maxAge});
        }
        if (uiLocales != null && uiLocales.length() > 0) {
            redirectUriBuilder.queryParam("ui_locales", new Object[]{uiLocales});
        }
        scope = TokenUtil.attachOIDCScope((String)scope);
        redirectUriBuilder.queryParam("scope", new Object[]{scope});
        return redirectUriBuilder.buildAsString(new Object[0]);
    }

    protected int sslRedirectPort() {
        return this.sslRedirectPort;
    }

    protected String getStateCode() {
        return AdapterUtils.generateId();
    }

    protected AuthChallenge loginRedirect() {
        final String state = this.getStateCode();
        final String redirect = this.getRedirectUri(state);
        if (redirect == null) {
            return this.challenge(403, OIDCAuthenticationError.Reason.NO_REDIRECT_URI, null);
        }
        return new AuthChallenge(){

            public int getResponseCode() {
                return 0;
            }

            public boolean challenge(HttpFacade exchange) {
                OAuthRequestAuthenticator.this.tokenStore.saveRequest();
                log.debug((Object)("Sending redirect to login page: " + redirect));
                exchange.getResponse().setStatus(302);
                exchange.getResponse().setCookie(OAuthRequestAuthenticator.this.deployment.getStateCookieName(), state, "/", null, -1, OAuthRequestAuthenticator.this.deployment.getSslRequired().isRequired(OAuthRequestAuthenticator.this.facade.getRequest().getRemoteAddr()), true);
                exchange.getResponse().setHeader("Location", redirect);
                return true;
            }
        };
    }

    protected AuthChallenge checkStateCookie() {
        HttpFacade.Cookie stateCookie = this.getCookie(this.deployment.getStateCookieName());
        if (stateCookie == null) {
            log.warn((Object)"No state cookie");
            return this.challenge(400, OIDCAuthenticationError.Reason.INVALID_STATE_COOKIE, null);
        }
        log.debug((Object)"** reseting application state cookie");
        this.facade.getResponse().resetCookie(this.deployment.getStateCookieName(), stateCookie.getPath());
        String stateCookieValue = this.getCookieValue(this.deployment.getStateCookieName());
        String state = this.getQueryParamValue("state");
        if (state == null) {
            log.warn((Object)"state parameter was null");
            return this.challenge(400, OIDCAuthenticationError.Reason.INVALID_STATE_COOKIE, null);
        }
        if (!state.equals(stateCookieValue)) {
            log.warn((Object)"state parameter invalid");
            log.warn((Object)("cookie: " + stateCookieValue));
            log.warn((Object)("queryParam: " + state));
            return this.challenge(400, OIDCAuthenticationError.Reason.INVALID_STATE_COOKIE, null);
        }
        return null;
    }

    public AuthOutcome authenticate() {
        String code = this.getCode();
        if (code == null) {
            log.debug((Object)"there was no code");
            String error = this.getError();
            if (error != null) {
                log.warn((Object)("There was an error: " + error));
                this.challenge = this.challenge(400, OIDCAuthenticationError.Reason.OAUTH_ERROR, error);
                return AuthOutcome.FAILED;
            }
            log.debug((Object)"redirecting to auth server");
            this.challenge = this.loginRedirect();
            return AuthOutcome.NOT_ATTEMPTED;
        }
        log.debug((Object)"there was a code, resolving");
        this.challenge = this.resolveCode(code);
        if (this.challenge != null) {
            return AuthOutcome.FAILED;
        }
        return AuthOutcome.AUTHENTICATED;
    }

    protected AuthChallenge challenge(final int code, final OIDCAuthenticationError.Reason reason, final String description) {
        return new AuthChallenge(){

            public int getResponseCode() {
                return code;
            }

            public boolean challenge(HttpFacade exchange) {
                OIDCAuthenticationError error = new OIDCAuthenticationError(reason, description);
                exchange.getRequest().setError((AuthenticationError)error);
                exchange.getResponse().sendError(code);
                return true;
            }
        };
    }

    protected AuthChallenge resolveCode(String code) {
        if (!this.isRequestSecure() && this.deployment.getSslRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            log.error((Object)("Adapter requires SSL. Request: " + this.facade.getRequest().getURI()));
            return this.challenge(403, OIDCAuthenticationError.Reason.SSL_REQUIRED, null);
        }
        log.debug((Object)"checking state cookie for after code");
        AuthChallenge challenge = this.checkStateCookie();
        if (challenge != null) {
            return challenge;
        }
        AccessTokenResponse tokenResponse = null;
        this.strippedOauthParametersRequestUri = this.rewrittenRedirectUri(this.stripOauthParametersFromRedirect());
        try {
            String httpSessionId = this.deployment.getTokenStore() == TokenStore.SESSION ? this.reqAuthenticator.changeHttpSessionId(true) : null;
            tokenResponse = ServerRequest.invokeAccessCodeToToken(this.deployment, code, this.strippedOauthParametersRequestUri, httpSessionId);
        }
        catch (ServerRequest.HttpFailure failure) {
            log.error((Object)"failed to turn code into token");
            log.error((Object)("status from server: " + failure.getStatus()));
            if (failure.getError() != null && !failure.getError().trim().isEmpty()) {
                log.error((Object)("   " + failure.getError()));
            }
            return this.challenge(403, OIDCAuthenticationError.Reason.CODE_TO_TOKEN_FAILURE, null);
        }
        catch (IOException e) {
            log.error((Object)"failed to turn code into token", (Throwable)e);
            return this.challenge(403, OIDCAuthenticationError.Reason.CODE_TO_TOKEN_FAILURE, null);
        }
        this.tokenString = tokenResponse.getToken();
        this.refreshToken = tokenResponse.getRefreshToken();
        this.idTokenString = tokenResponse.getIdToken();
        log.debug((Object)"Verifying tokens");
        if (log.isTraceEnabled()) {
            this.logToken("\taccess_token", this.tokenString);
            this.logToken("\tid_token", this.idTokenString);
            this.logToken("\trefresh_token", this.refreshToken);
        }
        try {
            AdapterTokenVerifier.VerifiedTokens tokens = AdapterTokenVerifier.verifyTokens(this.tokenString, this.idTokenString, this.deployment);
            this.token = tokens.getAccessToken();
            this.idToken = tokens.getIdToken();
            log.debug((Object)"Token Verification succeeded!");
        }
        catch (VerificationException e) {
            log.error((Object)("failed verification of token: " + e.getMessage()));
            return this.challenge(403, OIDCAuthenticationError.Reason.INVALID_TOKEN, null);
        }
        if (tokenResponse.getNotBeforePolicy() > this.deployment.getNotBefore()) {
            this.deployment.updateNotBefore(tokenResponse.getNotBeforePolicy());
        }
        if (this.token.getIssuedAt() < this.deployment.getNotBefore()) {
            log.error((Object)"Stale token");
            return this.challenge(403, OIDCAuthenticationError.Reason.STALE_TOKEN, null);
        }
        log.debug((Object)"successful authenticated");
        return null;
    }

    protected String stripOauthParametersFromRedirect() {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)this.facade.getRequest().getURI()).replaceQueryParam("code", null).replaceQueryParam("state", null).replaceQueryParam("session_state", null);
        return builder.buildAsString(new Object[0]);
    }

    private String rewrittenRedirectUri(String originalUri) {
        Map<String, String> rewriteRules = this.deployment.getRedirectRewriteRules();
        if (rewriteRules != null && !rewriteRules.isEmpty()) {
            try {
                URL url = new URL(originalUri);
                Map.Entry<String, String> rule = rewriteRules.entrySet().iterator().next();
                StringBuilder redirectUriBuilder = new StringBuilder(url.getProtocol());
                redirectUriBuilder.append("://" + url.getAuthority());
                redirectUriBuilder.append(url.getPath().replaceFirst(rule.getKey(), rule.getValue()));
                return redirectUriBuilder.toString();
            }
            catch (MalformedURLException ex) {
                log.error((Object)"Not a valid request url");
                throw new RuntimeException(ex);
            }
        }
        return originalUri;
    }

    private void logToken(String name, String token) {
        try {
            JWSInput jwsInput = new JWSInput(token);
            String wireString = jwsInput.getWireString();
            log.tracef("\t%s: %s", (Object)name, (Object)(wireString.substring(0, wireString.lastIndexOf(".")) + ".signature"));
        }
        catch (JWSInputException e) {
            log.errorf((Throwable)e, "Failed to parse %s: %s", (Object)name, (Object)token);
        }
    }
}

