/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.util;

public final class Assert {
    private Assert() {
    }

    public static void isNull(Object object) {
        if (object != null) {
            throw new IllegalArgumentException();
        }
    }

    public static void isNull(Object object, String message, Object ... args) {
        if (object != null) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void isTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void isTrue(boolean expression, String errorMessage, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessage, args));
        }
    }

    public static <T> T notNull(T reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return reference;
    }

    public static <T> T notNull(T reference, String parameterName) {
        if (reference == null) {
            throw new IllegalArgumentException(parameterName + " cannot be null");
        }
        return reference;
    }

    public static void state(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void state(boolean expression, String errorMessage, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(String.format(errorMessage, args));
        }
    }
}

